/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.TraitDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Condition {
    private final String accountId;
    private final Optional<TraitDefinition> comparisonTraitDefinition;
    private final String conditionType;
    private final Optional<Double> consumptionRate;
    private final Optional<String> creditId;
    private final String environmentId;
    private final Optional<String> eventSubtype;
    private final String id;
    private final Optional<String> metricPeriod;
    private final Optional<String> metricPeriodMonthReset;
    private final Optional<Integer> metricValue;
    private final String operator;
    private final List<String> resourceIds;
    private final Optional<TraitDefinition> traitDefinition;
    private final String traitValue;
    private final Map<String, Object> additionalProperties;

    private Condition(String accountId, Optional<TraitDefinition> comparisonTraitDefinition, String conditionType, Optional<Double> consumptionRate, Optional<String> creditId, String environmentId, Optional<String> eventSubtype, String id, Optional<String> metricPeriod, Optional<String> metricPeriodMonthReset, Optional<Integer> metricValue, String operator, List<String> resourceIds, Optional<TraitDefinition> traitDefinition, String traitValue, Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.comparisonTraitDefinition = comparisonTraitDefinition;
        this.conditionType = conditionType;
        this.consumptionRate = consumptionRate;
        this.creditId = creditId;
        this.environmentId = environmentId;
        this.eventSubtype = eventSubtype;
        this.id = id;
        this.metricPeriod = metricPeriod;
        this.metricPeriodMonthReset = metricPeriodMonthReset;
        this.metricValue = metricValue;
        this.operator = operator;
        this.resourceIds = resourceIds;
        this.traitDefinition = traitDefinition;
        this.traitValue = traitValue;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="account_id")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="comparison_trait_definition")
    public Optional<TraitDefinition> getComparisonTraitDefinition() {
        return this.comparisonTraitDefinition;
    }

    @JsonProperty(value="condition_type")
    public String getConditionType() {
        return this.conditionType;
    }

    @JsonProperty(value="consumption_rate")
    public Optional<Double> getConsumptionRate() {
        return this.consumptionRate;
    }

    @JsonProperty(value="credit_id")
    public Optional<String> getCreditId() {
        return this.creditId;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="event_subtype")
    public Optional<String> getEventSubtype() {
        return this.eventSubtype;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="metric_period")
    public Optional<String> getMetricPeriod() {
        return this.metricPeriod;
    }

    @JsonProperty(value="metric_period_month_reset")
    public Optional<String> getMetricPeriodMonthReset() {
        return this.metricPeriodMonthReset;
    }

    @JsonProperty(value="metric_value")
    public Optional<Integer> getMetricValue() {
        return this.metricValue;
    }

    @JsonProperty(value="operator")
    public String getOperator() {
        return this.operator;
    }

    @JsonProperty(value="resource_ids")
    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    @JsonProperty(value="trait_definition")
    public Optional<TraitDefinition> getTraitDefinition() {
        return this.traitDefinition;
    }

    @JsonProperty(value="trait_value")
    public String getTraitValue() {
        return this.traitValue;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Condition && this.equalTo((Condition)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Condition other) {
        return this.accountId.equals(other.accountId) && this.comparisonTraitDefinition.equals(other.comparisonTraitDefinition) && this.conditionType.equals(other.conditionType) && this.consumptionRate.equals(other.consumptionRate) && this.creditId.equals(other.creditId) && this.environmentId.equals(other.environmentId) && this.eventSubtype.equals(other.eventSubtype) && this.id.equals(other.id) && this.metricPeriod.equals(other.metricPeriod) && this.metricPeriodMonthReset.equals(other.metricPeriodMonthReset) && this.metricValue.equals(other.metricValue) && this.operator.equals(other.operator) && this.resourceIds.equals(other.resourceIds) && this.traitDefinition.equals(other.traitDefinition) && this.traitValue.equals(other.traitValue);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.comparisonTraitDefinition, this.conditionType, this.consumptionRate, this.creditId, this.environmentId, this.eventSubtype, this.id, this.metricPeriod, this.metricPeriodMonthReset, this.metricValue, this.operator, this.resourceIds, this.traitDefinition, this.traitValue);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccountIdStage,
    ConditionTypeStage,
    EnvironmentIdStage,
    IdStage,
    OperatorStage,
    TraitValueStage,
    _FinalStage {
        private String accountId;
        private String conditionType;
        private String environmentId;
        private String id;
        private String operator;
        private String traitValue;
        private Optional<TraitDefinition> traitDefinition = Optional.empty();
        private List<String> resourceIds = new ArrayList<String>();
        private Optional<Integer> metricValue = Optional.empty();
        private Optional<String> metricPeriodMonthReset = Optional.empty();
        private Optional<String> metricPeriod = Optional.empty();
        private Optional<String> eventSubtype = Optional.empty();
        private Optional<String> creditId = Optional.empty();
        private Optional<Double> consumptionRate = Optional.empty();
        private Optional<TraitDefinition> comparisonTraitDefinition = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Condition other) {
            this.accountId(other.getAccountId());
            this.comparisonTraitDefinition(other.getComparisonTraitDefinition());
            this.conditionType(other.getConditionType());
            this.consumptionRate(other.getConsumptionRate());
            this.creditId(other.getCreditId());
            this.environmentId(other.getEnvironmentId());
            this.eventSubtype(other.getEventSubtype());
            this.id(other.getId());
            this.metricPeriod(other.getMetricPeriod());
            this.metricPeriodMonthReset(other.getMetricPeriodMonthReset());
            this.metricValue(other.getMetricValue());
            this.operator(other.getOperator());
            this.resourceIds(other.getResourceIds());
            this.traitDefinition(other.getTraitDefinition());
            this.traitValue(other.getTraitValue());
            return this;
        }

        @Override
        @JsonSetter(value="account_id")
        public ConditionTypeStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="condition_type")
        public EnvironmentIdStage conditionType(@NotNull String conditionType) {
            this.conditionType = Objects.requireNonNull(conditionType, "conditionType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public OperatorStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="operator")
        public TraitValueStage operator(@NotNull String operator) {
            this.operator = Objects.requireNonNull(operator, "operator must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="trait_value")
        public _FinalStage traitValue(@NotNull String traitValue) {
            this.traitValue = Objects.requireNonNull(traitValue, "traitValue must not be null");
            return this;
        }

        @Override
        public _FinalStage traitDefinition(TraitDefinition traitDefinition) {
            this.traitDefinition = Optional.ofNullable(traitDefinition);
            return this;
        }

        @Override
        @JsonSetter(value="trait_definition", nulls=Nulls.SKIP)
        public _FinalStage traitDefinition(Optional<TraitDefinition> traitDefinition) {
            this.traitDefinition = traitDefinition;
            return this;
        }

        @Override
        public _FinalStage addAllResourceIds(List<String> resourceIds) {
            if (resourceIds != null) {
                this.resourceIds.addAll(resourceIds);
            }
            return this;
        }

        @Override
        public _FinalStage addResourceIds(String resourceIds) {
            this.resourceIds.add(resourceIds);
            return this;
        }

        @Override
        @JsonSetter(value="resource_ids", nulls=Nulls.SKIP)
        public _FinalStage resourceIds(List<String> resourceIds) {
            this.resourceIds.clear();
            if (resourceIds != null) {
                this.resourceIds.addAll(resourceIds);
            }
            return this;
        }

        @Override
        public _FinalStage metricValue(Integer metricValue) {
            this.metricValue = Optional.ofNullable(metricValue);
            return this;
        }

        @Override
        @JsonSetter(value="metric_value", nulls=Nulls.SKIP)
        public _FinalStage metricValue(Optional<Integer> metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        @Override
        public _FinalStage metricPeriodMonthReset(String metricPeriodMonthReset) {
            this.metricPeriodMonthReset = Optional.ofNullable(metricPeriodMonthReset);
            return this;
        }

        @Override
        @JsonSetter(value="metric_period_month_reset", nulls=Nulls.SKIP)
        public _FinalStage metricPeriodMonthReset(Optional<String> metricPeriodMonthReset) {
            this.metricPeriodMonthReset = metricPeriodMonthReset;
            return this;
        }

        @Override
        public _FinalStage metricPeriod(String metricPeriod) {
            this.metricPeriod = Optional.ofNullable(metricPeriod);
            return this;
        }

        @Override
        @JsonSetter(value="metric_period", nulls=Nulls.SKIP)
        public _FinalStage metricPeriod(Optional<String> metricPeriod) {
            this.metricPeriod = metricPeriod;
            return this;
        }

        @Override
        public _FinalStage eventSubtype(String eventSubtype) {
            this.eventSubtype = Optional.ofNullable(eventSubtype);
            return this;
        }

        @Override
        @JsonSetter(value="event_subtype", nulls=Nulls.SKIP)
        public _FinalStage eventSubtype(Optional<String> eventSubtype) {
            this.eventSubtype = eventSubtype;
            return this;
        }

        @Override
        public _FinalStage creditId(String creditId) {
            this.creditId = Optional.ofNullable(creditId);
            return this;
        }

        @Override
        @JsonSetter(value="credit_id", nulls=Nulls.SKIP)
        public _FinalStage creditId(Optional<String> creditId) {
            this.creditId = creditId;
            return this;
        }

        @Override
        public _FinalStage consumptionRate(Double consumptionRate) {
            this.consumptionRate = Optional.ofNullable(consumptionRate);
            return this;
        }

        @Override
        @JsonSetter(value="consumption_rate", nulls=Nulls.SKIP)
        public _FinalStage consumptionRate(Optional<Double> consumptionRate) {
            this.consumptionRate = consumptionRate;
            return this;
        }

        @Override
        public _FinalStage comparisonTraitDefinition(TraitDefinition comparisonTraitDefinition) {
            this.comparisonTraitDefinition = Optional.ofNullable(comparisonTraitDefinition);
            return this;
        }

        @Override
        @JsonSetter(value="comparison_trait_definition", nulls=Nulls.SKIP)
        public _FinalStage comparisonTraitDefinition(Optional<TraitDefinition> comparisonTraitDefinition) {
            this.comparisonTraitDefinition = comparisonTraitDefinition;
            return this;
        }

        @Override
        public Condition build() {
            return new Condition(this.accountId, this.comparisonTraitDefinition, this.conditionType, this.consumptionRate, this.creditId, this.environmentId, this.eventSubtype, this.id, this.metricPeriod, this.metricPeriodMonthReset, this.metricValue, this.operator, this.resourceIds, this.traitDefinition, this.traitValue, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Condition build();

        public _FinalStage comparisonTraitDefinition(Optional<TraitDefinition> var1);

        public _FinalStage comparisonTraitDefinition(TraitDefinition var1);

        public _FinalStage consumptionRate(Optional<Double> var1);

        public _FinalStage consumptionRate(Double var1);

        public _FinalStage creditId(Optional<String> var1);

        public _FinalStage creditId(String var1);

        public _FinalStage eventSubtype(Optional<String> var1);

        public _FinalStage eventSubtype(String var1);

        public _FinalStage metricPeriod(Optional<String> var1);

        public _FinalStage metricPeriod(String var1);

        public _FinalStage metricPeriodMonthReset(Optional<String> var1);

        public _FinalStage metricPeriodMonthReset(String var1);

        public _FinalStage metricValue(Optional<Integer> var1);

        public _FinalStage metricValue(Integer var1);

        public _FinalStage resourceIds(List<String> var1);

        public _FinalStage addResourceIds(String var1);

        public _FinalStage addAllResourceIds(List<String> var1);

        public _FinalStage traitDefinition(Optional<TraitDefinition> var1);

        public _FinalStage traitDefinition(TraitDefinition var1);
    }

    public static interface TraitValueStage {
        public _FinalStage traitValue(@NotNull String var1);
    }

    public static interface OperatorStage {
        public TraitValueStage operator(@NotNull String var1);
    }

    public static interface IdStage {
        public OperatorStage id(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public IdStage environmentId(@NotNull String var1);
    }

    public static interface ConditionTypeStage {
        public EnvironmentIdStage conditionType(@NotNull String var1);
    }

    public static interface AccountIdStage {
        public ConditionTypeStage accountId(@NotNull String var1);

        public Builder from(Condition var1);
    }
}

