/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.Condition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConditionGroup {
    private final List<Condition> conditions;
    private final Map<String, Object> additionalProperties;

    private ConditionGroup(List<Condition> conditions, Map<String, Object> additionalProperties) {
        this.conditions = conditions;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="conditions")
    public List<Condition> getConditions() {
        return this.conditions;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConditionGroup && this.equalTo((ConditionGroup)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConditionGroup other) {
        return this.conditions.equals(other.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.conditions);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<Condition> conditions = new ArrayList<Condition>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConditionGroup other) {
            this.conditions(other.getConditions());
            return this;
        }

        @JsonSetter(value="conditions", nulls=Nulls.SKIP)
        public Builder conditions(List<Condition> conditions) {
            this.conditions.clear();
            if (conditions != null) {
                this.conditions.addAll(conditions);
            }
            return this;
        }

        public Builder addConditions(Condition conditions) {
            this.conditions.add(conditions);
            return this;
        }

        public Builder addAllConditions(List<Condition> conditions) {
            if (conditions != null) {
                this.conditions.addAll(conditions);
            }
            return this;
        }

        public ConditionGroup build() {
            return new ConditionGroup(this.conditions, this.additionalProperties);
        }
    }
}

