/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CouponRequestBody {
    private final int amountOff;
    private final Optional<String> currency;
    private final String duration;
    private final int durationInMonths;
    private final int maxRedemptions;
    private final String name;
    private final double percentOff;
    private final int timesRedeemed;
    private final Map<String, Object> additionalProperties;

    private CouponRequestBody(int amountOff, Optional<String> currency, String duration, int durationInMonths, int maxRedemptions, String name, double percentOff, int timesRedeemed, Map<String, Object> additionalProperties) {
        this.amountOff = amountOff;
        this.currency = currency;
        this.duration = duration;
        this.durationInMonths = durationInMonths;
        this.maxRedemptions = maxRedemptions;
        this.name = name;
        this.percentOff = percentOff;
        this.timesRedeemed = timesRedeemed;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="amount_off")
    public int getAmountOff() {
        return this.amountOff;
    }

    @JsonProperty(value="currency")
    public Optional<String> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="duration")
    public String getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration_in_months")
    public int getDurationInMonths() {
        return this.durationInMonths;
    }

    @JsonProperty(value="max_redemptions")
    public int getMaxRedemptions() {
        return this.maxRedemptions;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="percent_off")
    public double getPercentOff() {
        return this.percentOff;
    }

    @JsonProperty(value="times_redeemed")
    public int getTimesRedeemed() {
        return this.timesRedeemed;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CouponRequestBody && this.equalTo((CouponRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CouponRequestBody other) {
        return this.amountOff == other.amountOff && this.currency.equals(other.currency) && this.duration.equals(other.duration) && this.durationInMonths == other.durationInMonths && this.maxRedemptions == other.maxRedemptions && this.name.equals(other.name) && this.percentOff == other.percentOff && this.timesRedeemed == other.timesRedeemed;
    }

    public int hashCode() {
        return Objects.hash(this.amountOff, this.currency, this.duration, this.durationInMonths, this.maxRedemptions, this.name, this.percentOff, this.timesRedeemed);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AmountOffStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AmountOffStage,
    DurationStage,
    DurationInMonthsStage,
    MaxRedemptionsStage,
    NameStage,
    PercentOffStage,
    TimesRedeemedStage,
    _FinalStage {
        private int amountOff;
        private String duration;
        private int durationInMonths;
        private int maxRedemptions;
        private String name;
        private double percentOff;
        private int timesRedeemed;
        private Optional<String> currency = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CouponRequestBody other) {
            this.amountOff(other.getAmountOff());
            this.currency(other.getCurrency());
            this.duration(other.getDuration());
            this.durationInMonths(other.getDurationInMonths());
            this.maxRedemptions(other.getMaxRedemptions());
            this.name(other.getName());
            this.percentOff(other.getPercentOff());
            this.timesRedeemed(other.getTimesRedeemed());
            return this;
        }

        @Override
        @JsonSetter(value="amount_off")
        public DurationStage amountOff(int amountOff) {
            this.amountOff = amountOff;
            return this;
        }

        @Override
        @JsonSetter(value="duration")
        public DurationInMonthsStage duration(@NotNull String duration) {
            this.duration = Objects.requireNonNull(duration, "duration must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="duration_in_months")
        public MaxRedemptionsStage durationInMonths(int durationInMonths) {
            this.durationInMonths = durationInMonths;
            return this;
        }

        @Override
        @JsonSetter(value="max_redemptions")
        public NameStage maxRedemptions(int maxRedemptions) {
            this.maxRedemptions = maxRedemptions;
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PercentOffStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="percent_off")
        public TimesRedeemedStage percentOff(double percentOff) {
            this.percentOff = percentOff;
            return this;
        }

        @Override
        @JsonSetter(value="times_redeemed")
        public _FinalStage timesRedeemed(int timesRedeemed) {
            this.timesRedeemed = timesRedeemed;
            return this;
        }

        @Override
        public _FinalStage currency(String currency) {
            this.currency = Optional.ofNullable(currency);
            return this;
        }

        @Override
        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public _FinalStage currency(Optional<String> currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public CouponRequestBody build() {
            return new CouponRequestBody(this.amountOff, this.currency, this.duration, this.durationInMonths, this.maxRedemptions, this.name, this.percentOff, this.timesRedeemed, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CouponRequestBody build();

        public _FinalStage currency(Optional<String> var1);

        public _FinalStage currency(String var1);
    }

    public static interface TimesRedeemedStage {
        public _FinalStage timesRedeemed(int var1);
    }

    public static interface PercentOffStage {
        public TimesRedeemedStage percentOff(double var1);
    }

    public static interface NameStage {
        public PercentOffStage name(@NotNull String var1);
    }

    public static interface MaxRedemptionsStage {
        public NameStage maxRedemptions(int var1);
    }

    public static interface DurationInMonthsStage {
        public MaxRedemptionsStage durationInMonths(int var1);
    }

    public static interface DurationStage {
        public DurationInMonthsStage duration(@NotNull String var1);
    }

    public static interface AmountOffStage {
        public DurationStage amountOff(int var1);

        public Builder from(CouponRequestBody var1);
    }
}

