/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateBillingPriceTierRequestBody {
    private final Optional<Integer> flatAmount;
    private final Optional<String> perUnitDecimal;
    private final Optional<Integer> perUnitPrice;
    private final String priceExternalId;
    private final Optional<Integer> upTo;
    private final Map<String, Object> additionalProperties;

    private CreateBillingPriceTierRequestBody(Optional<Integer> flatAmount, Optional<String> perUnitDecimal, Optional<Integer> perUnitPrice, String priceExternalId, Optional<Integer> upTo, Map<String, Object> additionalProperties) {
        this.flatAmount = flatAmount;
        this.perUnitDecimal = perUnitDecimal;
        this.perUnitPrice = perUnitPrice;
        this.priceExternalId = priceExternalId;
        this.upTo = upTo;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="flat_amount")
    public Optional<Integer> getFlatAmount() {
        return this.flatAmount;
    }

    @JsonProperty(value="per_unit_decimal")
    public Optional<String> getPerUnitDecimal() {
        return this.perUnitDecimal;
    }

    @JsonProperty(value="per_unit_price")
    public Optional<Integer> getPerUnitPrice() {
        return this.perUnitPrice;
    }

    @JsonProperty(value="price_external_id")
    public String getPriceExternalId() {
        return this.priceExternalId;
    }

    @JsonProperty(value="up_to")
    public Optional<Integer> getUpTo() {
        return this.upTo;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateBillingPriceTierRequestBody && this.equalTo((CreateBillingPriceTierRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateBillingPriceTierRequestBody other) {
        return this.flatAmount.equals(other.flatAmount) && this.perUnitDecimal.equals(other.perUnitDecimal) && this.perUnitPrice.equals(other.perUnitPrice) && this.priceExternalId.equals(other.priceExternalId) && this.upTo.equals(other.upTo);
    }

    public int hashCode() {
        return Objects.hash(this.flatAmount, this.perUnitDecimal, this.perUnitPrice, this.priceExternalId, this.upTo);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PriceExternalIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PriceExternalIdStage,
    _FinalStage {
        private String priceExternalId;
        private Optional<Integer> upTo = Optional.empty();
        private Optional<Integer> perUnitPrice = Optional.empty();
        private Optional<String> perUnitDecimal = Optional.empty();
        private Optional<Integer> flatAmount = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateBillingPriceTierRequestBody other) {
            this.flatAmount(other.getFlatAmount());
            this.perUnitDecimal(other.getPerUnitDecimal());
            this.perUnitPrice(other.getPerUnitPrice());
            this.priceExternalId(other.getPriceExternalId());
            this.upTo(other.getUpTo());
            return this;
        }

        @Override
        @JsonSetter(value="price_external_id")
        public _FinalStage priceExternalId(@NotNull String priceExternalId) {
            this.priceExternalId = Objects.requireNonNull(priceExternalId, "priceExternalId must not be null");
            return this;
        }

        @Override
        public _FinalStage upTo(Integer upTo) {
            this.upTo = Optional.ofNullable(upTo);
            return this;
        }

        @Override
        @JsonSetter(value="up_to", nulls=Nulls.SKIP)
        public _FinalStage upTo(Optional<Integer> upTo) {
            this.upTo = upTo;
            return this;
        }

        @Override
        public _FinalStage perUnitPrice(Integer perUnitPrice) {
            this.perUnitPrice = Optional.ofNullable(perUnitPrice);
            return this;
        }

        @Override
        @JsonSetter(value="per_unit_price", nulls=Nulls.SKIP)
        public _FinalStage perUnitPrice(Optional<Integer> perUnitPrice) {
            this.perUnitPrice = perUnitPrice;
            return this;
        }

        @Override
        public _FinalStage perUnitDecimal(String perUnitDecimal) {
            this.perUnitDecimal = Optional.ofNullable(perUnitDecimal);
            return this;
        }

        @Override
        @JsonSetter(value="per_unit_decimal", nulls=Nulls.SKIP)
        public _FinalStage perUnitDecimal(Optional<String> perUnitDecimal) {
            this.perUnitDecimal = perUnitDecimal;
            return this;
        }

        @Override
        public _FinalStage flatAmount(Integer flatAmount) {
            this.flatAmount = Optional.ofNullable(flatAmount);
            return this;
        }

        @Override
        @JsonSetter(value="flat_amount", nulls=Nulls.SKIP)
        public _FinalStage flatAmount(Optional<Integer> flatAmount) {
            this.flatAmount = flatAmount;
            return this;
        }

        @Override
        public CreateBillingPriceTierRequestBody build() {
            return new CreateBillingPriceTierRequestBody(this.flatAmount, this.perUnitDecimal, this.perUnitPrice, this.priceExternalId, this.upTo, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateBillingPriceTierRequestBody build();

        public _FinalStage flatAmount(Optional<Integer> var1);

        public _FinalStage flatAmount(Integer var1);

        public _FinalStage perUnitDecimal(Optional<String> var1);

        public _FinalStage perUnitDecimal(String var1);

        public _FinalStage perUnitPrice(Optional<Integer> var1);

        public _FinalStage perUnitPrice(Integer var1);

        public _FinalStage upTo(Optional<Integer> var1);

        public _FinalStage upTo(Integer var1);
    }

    public static interface PriceExternalIdStage {
        public _FinalStage priceExternalId(@NotNull String var1);

        public Builder from(CreateBillingPriceTierRequestBody var1);
    }
}

