/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.CreateEventRequestBodyEventType;
import com.schematic.api.types.EventBody;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateEventRequestBody {
    private final Optional<EventBody> body;
    private final CreateEventRequestBodyEventType eventType;
    private final Optional<OffsetDateTime> sentAt;
    private final Map<String, Object> additionalProperties;

    private CreateEventRequestBody(Optional<EventBody> body, CreateEventRequestBodyEventType eventType, Optional<OffsetDateTime> sentAt, Map<String, Object> additionalProperties) {
        this.body = body;
        this.eventType = eventType;
        this.sentAt = sentAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="body")
    public Optional<EventBody> getBody() {
        return this.body;
    }

    @JsonProperty(value="event_type")
    public CreateEventRequestBodyEventType getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="sent_at")
    public Optional<OffsetDateTime> getSentAt() {
        return this.sentAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateEventRequestBody && this.equalTo((CreateEventRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateEventRequestBody other) {
        return this.body.equals(other.body) && this.eventType.equals(other.eventType) && this.sentAt.equals(other.sentAt);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.eventType, this.sentAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EventTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EventTypeStage,
    _FinalStage {
        private CreateEventRequestBodyEventType eventType;
        private Optional<OffsetDateTime> sentAt = Optional.empty();
        private Optional<EventBody> body = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateEventRequestBody other) {
            this.body(other.getBody());
            this.eventType(other.getEventType());
            this.sentAt(other.getSentAt());
            return this;
        }

        @Override
        @JsonSetter(value="event_type")
        public _FinalStage eventType(@NotNull CreateEventRequestBodyEventType eventType) {
            this.eventType = Objects.requireNonNull(eventType, "eventType must not be null");
            return this;
        }

        @Override
        public _FinalStage sentAt(OffsetDateTime sentAt) {
            this.sentAt = Optional.ofNullable(sentAt);
            return this;
        }

        @Override
        @JsonSetter(value="sent_at", nulls=Nulls.SKIP)
        public _FinalStage sentAt(Optional<OffsetDateTime> sentAt) {
            this.sentAt = sentAt;
            return this;
        }

        @Override
        public _FinalStage body(EventBody body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Optional<EventBody> body) {
            this.body = body;
            return this;
        }

        @Override
        public CreateEventRequestBody build() {
            return new CreateEventRequestBody(this.body, this.eventType, this.sentAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateEventRequestBody build();

        public _FinalStage body(Optional<EventBody> var1);

        public _FinalStage body(EventBody var1);

        public _FinalStage sentAt(Optional<OffsetDateTime> var1);

        public _FinalStage sentAt(OffsetDateTime var1);
    }

    public static interface EventTypeStage {
        public _FinalStage eventType(@NotNull CreateEventRequestBodyEventType var1);

        public Builder from(CreateEventRequestBody var1);
    }
}

