/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateOrUpdateFlagRequestBody {
    private final boolean defaultValue;
    private final String description;
    private final Optional<String> featureId;
    private final Optional<String> id;
    private final String key;
    private final Optional<String> maintainerId;
    private final String name;
    private final Map<String, Object> additionalProperties;

    private CreateOrUpdateFlagRequestBody(boolean defaultValue, String description, Optional<String> featureId, Optional<String> id, String key, Optional<String> maintainerId, String name, Map<String, Object> additionalProperties) {
        this.defaultValue = defaultValue;
        this.description = description;
        this.featureId = featureId;
        this.id = id;
        this.key = key;
        this.maintainerId = maintainerId;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="default_value")
    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="feature_id")
    public Optional<String> getFeatureId() {
        return this.featureId;
    }

    @JsonProperty(value="flag_type")
    public String getFlagType() {
        return "boolean";
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="maintainer_id")
    public Optional<String> getMaintainerId() {
        return this.maintainerId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateOrUpdateFlagRequestBody && this.equalTo((CreateOrUpdateFlagRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateOrUpdateFlagRequestBody other) {
        return this.defaultValue == other.defaultValue && this.description.equals(other.description) && this.featureId.equals(other.featureId) && this.id.equals(other.id) && this.key.equals(other.key) && this.maintainerId.equals(other.maintainerId) && this.name.equals(other.name);
    }

    public int hashCode() {
        return Objects.hash(this.defaultValue, this.description, this.featureId, this.id, this.key, this.maintainerId, this.name);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DefaultValueStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DefaultValueStage,
    DescriptionStage,
    KeyStage,
    NameStage,
    _FinalStage {
        private boolean defaultValue;
        private String description;
        private String key;
        private String name;
        private Optional<String> maintainerId = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> featureId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateOrUpdateFlagRequestBody other) {
            this.defaultValue(other.getDefaultValue());
            this.description(other.getDescription());
            this.featureId(other.getFeatureId());
            this.id(other.getId());
            this.key(other.getKey());
            this.maintainerId(other.getMaintainerId());
            this.name(other.getName());
            return this;
        }

        @Override
        @JsonSetter(value="default_value")
        public DescriptionStage defaultValue(boolean defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public KeyStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="key")
        public NameStage key(@NotNull String key) {
            this.key = Objects.requireNonNull(key, "key must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage maintainerId(String maintainerId) {
            this.maintainerId = Optional.ofNullable(maintainerId);
            return this;
        }

        @Override
        @JsonSetter(value="maintainer_id", nulls=Nulls.SKIP)
        public _FinalStage maintainerId(Optional<String> maintainerId) {
            this.maintainerId = maintainerId;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public _FinalStage featureId(String featureId) {
            this.featureId = Optional.ofNullable(featureId);
            return this;
        }

        @Override
        @JsonSetter(value="feature_id", nulls=Nulls.SKIP)
        public _FinalStage featureId(Optional<String> featureId) {
            this.featureId = featureId;
            return this;
        }

        @Override
        public CreateOrUpdateFlagRequestBody build() {
            return new CreateOrUpdateFlagRequestBody(this.defaultValue, this.description, this.featureId, this.id, this.key, this.maintainerId, this.name, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateOrUpdateFlagRequestBody build();

        public _FinalStage featureId(Optional<String> var1);

        public _FinalStage featureId(String var1);

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage maintainerId(Optional<String> var1);

        public _FinalStage maintainerId(String var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface KeyStage {
        public NameStage key(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public KeyStage description(@NotNull String var1);
    }

    public static interface DefaultValueStage {
        public DescriptionStage defaultValue(boolean var1);

        public Builder from(CreateOrUpdateFlagRequestBody var1);
    }
}

