/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingCreditBundleResponseData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreditBundlePurchaseResponseData {
    private final Optional<BillingCreditBundleResponseData> bundle;
    private final int quantity;
    private final int total;
    private final Map<String, Object> additionalProperties;

    private CreditBundlePurchaseResponseData(Optional<BillingCreditBundleResponseData> bundle, int quantity, int total, Map<String, Object> additionalProperties) {
        this.bundle = bundle;
        this.quantity = quantity;
        this.total = total;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="bundle")
    public Optional<BillingCreditBundleResponseData> getBundle() {
        return this.bundle;
    }

    @JsonProperty(value="quantity")
    public int getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="total")
    public int getTotal() {
        return this.total;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreditBundlePurchaseResponseData && this.equalTo((CreditBundlePurchaseResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreditBundlePurchaseResponseData other) {
        return this.bundle.equals(other.bundle) && this.quantity == other.quantity && this.total == other.total;
    }

    public int hashCode() {
        return Objects.hash(this.bundle, this.quantity, this.total);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static QuantityStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements QuantityStage,
    TotalStage,
    _FinalStage {
        private int quantity;
        private int total;
        private Optional<BillingCreditBundleResponseData> bundle = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreditBundlePurchaseResponseData other) {
            this.bundle(other.getBundle());
            this.quantity(other.getQuantity());
            this.total(other.getTotal());
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public TotalStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        @JsonSetter(value="total")
        public _FinalStage total(int total) {
            this.total = total;
            return this;
        }

        @Override
        public _FinalStage bundle(BillingCreditBundleResponseData bundle) {
            this.bundle = Optional.ofNullable(bundle);
            return this;
        }

        @Override
        @JsonSetter(value="bundle", nulls=Nulls.SKIP)
        public _FinalStage bundle(Optional<BillingCreditBundleResponseData> bundle) {
            this.bundle = bundle;
            return this;
        }

        @Override
        public CreditBundlePurchaseResponseData build() {
            return new CreditBundlePurchaseResponseData(this.bundle, this.quantity, this.total, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreditBundlePurchaseResponseData build();

        public _FinalStage bundle(Optional<BillingCreditBundleResponseData> var1);

        public _FinalStage bundle(BillingCreditBundleResponseData var1);
    }

    public static interface TotalStage {
        public _FinalStage total(int var1);
    }

    public static interface QuantityStage {
        public TotalStage quantity(int var1);

        public Builder from(CreditBundlePurchaseResponseData var1);
    }
}

