/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingProductPriceResponseData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreditCompanyGrantView {
    private final Optional<String> billingCreditBundleId;
    private final String billingCreditId;
    private final String companyId;
    private final String companyName;
    private final OffsetDateTime createdAt;
    private final String creditDescription;
    private final Optional<String> creditIcon;
    private final String creditName;
    private final Optional<OffsetDateTime> expiresAt;
    private final Optional<String> expiryType;
    private final Optional<String> expiryUnit;
    private final Optional<Integer> expiryUnitCount;
    private final String grantReason;
    private final String id;
    private final Optional<String> planId;
    private final Optional<String> planName;
    private final Optional<String> pluralName;
    private final Optional<BillingProductPriceResponseData> price;
    private final int quantity;
    private final double quantityRemaining;
    private final double quantityUsed;
    private final Optional<String> singularName;
    private final String sourceLabel;
    private final OffsetDateTime updatedAt;
    private final Optional<OffsetDateTime> validFrom;
    private final Optional<OffsetDateTime> zeroedOutDate;
    private final Optional<String> zeroedOutReason;
    private final Map<String, Object> additionalProperties;

    private CreditCompanyGrantView(Optional<String> billingCreditBundleId, String billingCreditId, String companyId, String companyName, OffsetDateTime createdAt, String creditDescription, Optional<String> creditIcon, String creditName, Optional<OffsetDateTime> expiresAt, Optional<String> expiryType, Optional<String> expiryUnit, Optional<Integer> expiryUnitCount, String grantReason, String id, Optional<String> planId, Optional<String> planName, Optional<String> pluralName, Optional<BillingProductPriceResponseData> price, int quantity, double quantityRemaining, double quantityUsed, Optional<String> singularName, String sourceLabel, OffsetDateTime updatedAt, Optional<OffsetDateTime> validFrom, Optional<OffsetDateTime> zeroedOutDate, Optional<String> zeroedOutReason, Map<String, Object> additionalProperties) {
        this.billingCreditBundleId = billingCreditBundleId;
        this.billingCreditId = billingCreditId;
        this.companyId = companyId;
        this.companyName = companyName;
        this.createdAt = createdAt;
        this.creditDescription = creditDescription;
        this.creditIcon = creditIcon;
        this.creditName = creditName;
        this.expiresAt = expiresAt;
        this.expiryType = expiryType;
        this.expiryUnit = expiryUnit;
        this.expiryUnitCount = expiryUnitCount;
        this.grantReason = grantReason;
        this.id = id;
        this.planId = planId;
        this.planName = planName;
        this.pluralName = pluralName;
        this.price = price;
        this.quantity = quantity;
        this.quantityRemaining = quantityRemaining;
        this.quantityUsed = quantityUsed;
        this.singularName = singularName;
        this.sourceLabel = sourceLabel;
        this.updatedAt = updatedAt;
        this.validFrom = validFrom;
        this.zeroedOutDate = zeroedOutDate;
        this.zeroedOutReason = zeroedOutReason;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="billing_credit_bundle_id")
    public Optional<String> getBillingCreditBundleId() {
        return this.billingCreditBundleId;
    }

    @JsonProperty(value="billing_credit_id")
    public String getBillingCreditId() {
        return this.billingCreditId;
    }

    @JsonProperty(value="company_id")
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="company_name")
    public String getCompanyName() {
        return this.companyName;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="credit_description")
    public String getCreditDescription() {
        return this.creditDescription;
    }

    @JsonProperty(value="credit_icon")
    public Optional<String> getCreditIcon() {
        return this.creditIcon;
    }

    @JsonProperty(value="credit_name")
    public String getCreditName() {
        return this.creditName;
    }

    @JsonProperty(value="expires_at")
    public Optional<OffsetDateTime> getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expiry_type")
    public Optional<String> getExpiryType() {
        return this.expiryType;
    }

    @JsonProperty(value="expiry_unit")
    public Optional<String> getExpiryUnit() {
        return this.expiryUnit;
    }

    @JsonProperty(value="expiry_unit_count")
    public Optional<Integer> getExpiryUnitCount() {
        return this.expiryUnitCount;
    }

    @JsonProperty(value="grant_reason")
    public String getGrantReason() {
        return this.grantReason;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="plan_id")
    public Optional<String> getPlanId() {
        return this.planId;
    }

    @JsonProperty(value="plan_name")
    public Optional<String> getPlanName() {
        return this.planName;
    }

    @JsonProperty(value="plural_name")
    public Optional<String> getPluralName() {
        return this.pluralName;
    }

    @JsonProperty(value="price")
    public Optional<BillingProductPriceResponseData> getPrice() {
        return this.price;
    }

    @JsonProperty(value="quantity")
    public int getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity_remaining")
    public double getQuantityRemaining() {
        return this.quantityRemaining;
    }

    @JsonProperty(value="quantity_used")
    public double getQuantityUsed() {
        return this.quantityUsed;
    }

    @JsonProperty(value="singular_name")
    public Optional<String> getSingularName() {
        return this.singularName;
    }

    @JsonProperty(value="source_label")
    public String getSourceLabel() {
        return this.sourceLabel;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="valid_from")
    public Optional<OffsetDateTime> getValidFrom() {
        return this.validFrom;
    }

    @JsonProperty(value="zeroed_out_date")
    public Optional<OffsetDateTime> getZeroedOutDate() {
        return this.zeroedOutDate;
    }

    @JsonProperty(value="zeroed_out_reason")
    public Optional<String> getZeroedOutReason() {
        return this.zeroedOutReason;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreditCompanyGrantView && this.equalTo((CreditCompanyGrantView)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreditCompanyGrantView other) {
        return this.billingCreditBundleId.equals(other.billingCreditBundleId) && this.billingCreditId.equals(other.billingCreditId) && this.companyId.equals(other.companyId) && this.companyName.equals(other.companyName) && this.createdAt.equals(other.createdAt) && this.creditDescription.equals(other.creditDescription) && this.creditIcon.equals(other.creditIcon) && this.creditName.equals(other.creditName) && this.expiresAt.equals(other.expiresAt) && this.expiryType.equals(other.expiryType) && this.expiryUnit.equals(other.expiryUnit) && this.expiryUnitCount.equals(other.expiryUnitCount) && this.grantReason.equals(other.grantReason) && this.id.equals(other.id) && this.planId.equals(other.planId) && this.planName.equals(other.planName) && this.pluralName.equals(other.pluralName) && this.price.equals(other.price) && this.quantity == other.quantity && this.quantityRemaining == other.quantityRemaining && this.quantityUsed == other.quantityUsed && this.singularName.equals(other.singularName) && this.sourceLabel.equals(other.sourceLabel) && this.updatedAt.equals(other.updatedAt) && this.validFrom.equals(other.validFrom) && this.zeroedOutDate.equals(other.zeroedOutDate) && this.zeroedOutReason.equals(other.zeroedOutReason);
    }

    public int hashCode() {
        return Objects.hash(this.billingCreditBundleId, this.billingCreditId, this.companyId, this.companyName, this.createdAt, this.creditDescription, this.creditIcon, this.creditName, this.expiresAt, this.expiryType, this.expiryUnit, this.expiryUnitCount, this.grantReason, this.id, this.planId, this.planName, this.pluralName, this.price, this.quantity, this.quantityRemaining, this.quantityUsed, this.singularName, this.sourceLabel, this.updatedAt, this.validFrom, this.zeroedOutDate, this.zeroedOutReason);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BillingCreditIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BillingCreditIdStage,
    CompanyIdStage,
    CompanyNameStage,
    CreatedAtStage,
    CreditDescriptionStage,
    CreditNameStage,
    GrantReasonStage,
    IdStage,
    QuantityStage,
    QuantityRemainingStage,
    QuantityUsedStage,
    SourceLabelStage,
    UpdatedAtStage,
    _FinalStage {
        private String billingCreditId;
        private String companyId;
        private String companyName;
        private OffsetDateTime createdAt;
        private String creditDescription;
        private String creditName;
        private String grantReason;
        private String id;
        private int quantity;
        private double quantityRemaining;
        private double quantityUsed;
        private String sourceLabel;
        private OffsetDateTime updatedAt;
        private Optional<String> zeroedOutReason = Optional.empty();
        private Optional<OffsetDateTime> zeroedOutDate = Optional.empty();
        private Optional<OffsetDateTime> validFrom = Optional.empty();
        private Optional<String> singularName = Optional.empty();
        private Optional<BillingProductPriceResponseData> price = Optional.empty();
        private Optional<String> pluralName = Optional.empty();
        private Optional<String> planName = Optional.empty();
        private Optional<String> planId = Optional.empty();
        private Optional<Integer> expiryUnitCount = Optional.empty();
        private Optional<String> expiryUnit = Optional.empty();
        private Optional<String> expiryType = Optional.empty();
        private Optional<OffsetDateTime> expiresAt = Optional.empty();
        private Optional<String> creditIcon = Optional.empty();
        private Optional<String> billingCreditBundleId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreditCompanyGrantView other) {
            this.billingCreditBundleId(other.getBillingCreditBundleId());
            this.billingCreditId(other.getBillingCreditId());
            this.companyId(other.getCompanyId());
            this.companyName(other.getCompanyName());
            this.createdAt(other.getCreatedAt());
            this.creditDescription(other.getCreditDescription());
            this.creditIcon(other.getCreditIcon());
            this.creditName(other.getCreditName());
            this.expiresAt(other.getExpiresAt());
            this.expiryType(other.getExpiryType());
            this.expiryUnit(other.getExpiryUnit());
            this.expiryUnitCount(other.getExpiryUnitCount());
            this.grantReason(other.getGrantReason());
            this.id(other.getId());
            this.planId(other.getPlanId());
            this.planName(other.getPlanName());
            this.pluralName(other.getPluralName());
            this.price(other.getPrice());
            this.quantity(other.getQuantity());
            this.quantityRemaining(other.getQuantityRemaining());
            this.quantityUsed(other.getQuantityUsed());
            this.singularName(other.getSingularName());
            this.sourceLabel(other.getSourceLabel());
            this.updatedAt(other.getUpdatedAt());
            this.validFrom(other.getValidFrom());
            this.zeroedOutDate(other.getZeroedOutDate());
            this.zeroedOutReason(other.getZeroedOutReason());
            return this;
        }

        @Override
        @JsonSetter(value="billing_credit_id")
        public CompanyIdStage billingCreditId(@NotNull String billingCreditId) {
            this.billingCreditId = Objects.requireNonNull(billingCreditId, "billingCreditId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="company_id")
        public CompanyNameStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="company_name")
        public CreatedAtStage companyName(@NotNull String companyName) {
            this.companyName = Objects.requireNonNull(companyName, "companyName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public CreditDescriptionStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="credit_description")
        public CreditNameStage creditDescription(@NotNull String creditDescription) {
            this.creditDescription = Objects.requireNonNull(creditDescription, "creditDescription must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="credit_name")
        public GrantReasonStage creditName(@NotNull String creditName) {
            this.creditName = Objects.requireNonNull(creditName, "creditName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="grant_reason")
        public IdStage grantReason(@NotNull String grantReason) {
            this.grantReason = Objects.requireNonNull(grantReason, "grantReason must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public QuantityStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public QuantityRemainingStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        @JsonSetter(value="quantity_remaining")
        public QuantityUsedStage quantityRemaining(double quantityRemaining) {
            this.quantityRemaining = quantityRemaining;
            return this;
        }

        @Override
        @JsonSetter(value="quantity_used")
        public SourceLabelStage quantityUsed(double quantityUsed) {
            this.quantityUsed = quantityUsed;
            return this;
        }

        @Override
        @JsonSetter(value="source_label")
        public UpdatedAtStage sourceLabel(@NotNull String sourceLabel) {
            this.sourceLabel = Objects.requireNonNull(sourceLabel, "sourceLabel must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage zeroedOutReason(String zeroedOutReason) {
            this.zeroedOutReason = Optional.ofNullable(zeroedOutReason);
            return this;
        }

        @Override
        @JsonSetter(value="zeroed_out_reason", nulls=Nulls.SKIP)
        public _FinalStage zeroedOutReason(Optional<String> zeroedOutReason) {
            this.zeroedOutReason = zeroedOutReason;
            return this;
        }

        @Override
        public _FinalStage zeroedOutDate(OffsetDateTime zeroedOutDate) {
            this.zeroedOutDate = Optional.ofNullable(zeroedOutDate);
            return this;
        }

        @Override
        @JsonSetter(value="zeroed_out_date", nulls=Nulls.SKIP)
        public _FinalStage zeroedOutDate(Optional<OffsetDateTime> zeroedOutDate) {
            this.zeroedOutDate = zeroedOutDate;
            return this;
        }

        @Override
        public _FinalStage validFrom(OffsetDateTime validFrom) {
            this.validFrom = Optional.ofNullable(validFrom);
            return this;
        }

        @Override
        @JsonSetter(value="valid_from", nulls=Nulls.SKIP)
        public _FinalStage validFrom(Optional<OffsetDateTime> validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        @Override
        public _FinalStage singularName(String singularName) {
            this.singularName = Optional.ofNullable(singularName);
            return this;
        }

        @Override
        @JsonSetter(value="singular_name", nulls=Nulls.SKIP)
        public _FinalStage singularName(Optional<String> singularName) {
            this.singularName = singularName;
            return this;
        }

        @Override
        public _FinalStage price(BillingProductPriceResponseData price) {
            this.price = Optional.ofNullable(price);
            return this;
        }

        @Override
        @JsonSetter(value="price", nulls=Nulls.SKIP)
        public _FinalStage price(Optional<BillingProductPriceResponseData> price) {
            this.price = price;
            return this;
        }

        @Override
        public _FinalStage pluralName(String pluralName) {
            this.pluralName = Optional.ofNullable(pluralName);
            return this;
        }

        @Override
        @JsonSetter(value="plural_name", nulls=Nulls.SKIP)
        public _FinalStage pluralName(Optional<String> pluralName) {
            this.pluralName = pluralName;
            return this;
        }

        @Override
        public _FinalStage planName(String planName) {
            this.planName = Optional.ofNullable(planName);
            return this;
        }

        @Override
        @JsonSetter(value="plan_name", nulls=Nulls.SKIP)
        public _FinalStage planName(Optional<String> planName) {
            this.planName = planName;
            return this;
        }

        @Override
        public _FinalStage planId(String planId) {
            this.planId = Optional.ofNullable(planId);
            return this;
        }

        @Override
        @JsonSetter(value="plan_id", nulls=Nulls.SKIP)
        public _FinalStage planId(Optional<String> planId) {
            this.planId = planId;
            return this;
        }

        @Override
        public _FinalStage expiryUnitCount(Integer expiryUnitCount) {
            this.expiryUnitCount = Optional.ofNullable(expiryUnitCount);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_unit_count", nulls=Nulls.SKIP)
        public _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount) {
            this.expiryUnitCount = expiryUnitCount;
            return this;
        }

        @Override
        public _FinalStage expiryUnit(String expiryUnit) {
            this.expiryUnit = Optional.ofNullable(expiryUnit);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_unit", nulls=Nulls.SKIP)
        public _FinalStage expiryUnit(Optional<String> expiryUnit) {
            this.expiryUnit = expiryUnit;
            return this;
        }

        @Override
        public _FinalStage expiryType(String expiryType) {
            this.expiryType = Optional.ofNullable(expiryType);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_type", nulls=Nulls.SKIP)
        public _FinalStage expiryType(Optional<String> expiryType) {
            this.expiryType = expiryType;
            return this;
        }

        @Override
        public _FinalStage expiresAt(OffsetDateTime expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        @Override
        @JsonSetter(value="expires_at", nulls=Nulls.SKIP)
        public _FinalStage expiresAt(Optional<OffsetDateTime> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public _FinalStage creditIcon(String creditIcon) {
            this.creditIcon = Optional.ofNullable(creditIcon);
            return this;
        }

        @Override
        @JsonSetter(value="credit_icon", nulls=Nulls.SKIP)
        public _FinalStage creditIcon(Optional<String> creditIcon) {
            this.creditIcon = creditIcon;
            return this;
        }

        @Override
        public _FinalStage billingCreditBundleId(String billingCreditBundleId) {
            this.billingCreditBundleId = Optional.ofNullable(billingCreditBundleId);
            return this;
        }

        @Override
        @JsonSetter(value="billing_credit_bundle_id", nulls=Nulls.SKIP)
        public _FinalStage billingCreditBundleId(Optional<String> billingCreditBundleId) {
            this.billingCreditBundleId = billingCreditBundleId;
            return this;
        }

        @Override
        public CreditCompanyGrantView build() {
            return new CreditCompanyGrantView(this.billingCreditBundleId, this.billingCreditId, this.companyId, this.companyName, this.createdAt, this.creditDescription, this.creditIcon, this.creditName, this.expiresAt, this.expiryType, this.expiryUnit, this.expiryUnitCount, this.grantReason, this.id, this.planId, this.planName, this.pluralName, this.price, this.quantity, this.quantityRemaining, this.quantityUsed, this.singularName, this.sourceLabel, this.updatedAt, this.validFrom, this.zeroedOutDate, this.zeroedOutReason, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreditCompanyGrantView build();

        public _FinalStage billingCreditBundleId(Optional<String> var1);

        public _FinalStage billingCreditBundleId(String var1);

        public _FinalStage creditIcon(Optional<String> var1);

        public _FinalStage creditIcon(String var1);

        public _FinalStage expiresAt(Optional<OffsetDateTime> var1);

        public _FinalStage expiresAt(OffsetDateTime var1);

        public _FinalStage expiryType(Optional<String> var1);

        public _FinalStage expiryType(String var1);

        public _FinalStage expiryUnit(Optional<String> var1);

        public _FinalStage expiryUnit(String var1);

        public _FinalStage expiryUnitCount(Optional<Integer> var1);

        public _FinalStage expiryUnitCount(Integer var1);

        public _FinalStage planId(Optional<String> var1);

        public _FinalStage planId(String var1);

        public _FinalStage planName(Optional<String> var1);

        public _FinalStage planName(String var1);

        public _FinalStage pluralName(Optional<String> var1);

        public _FinalStage pluralName(String var1);

        public _FinalStage price(Optional<BillingProductPriceResponseData> var1);

        public _FinalStage price(BillingProductPriceResponseData var1);

        public _FinalStage singularName(Optional<String> var1);

        public _FinalStage singularName(String var1);

        public _FinalStage validFrom(Optional<OffsetDateTime> var1);

        public _FinalStage validFrom(OffsetDateTime var1);

        public _FinalStage zeroedOutDate(Optional<OffsetDateTime> var1);

        public _FinalStage zeroedOutDate(OffsetDateTime var1);

        public _FinalStage zeroedOutReason(Optional<String> var1);

        public _FinalStage zeroedOutReason(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface SourceLabelStage {
        public UpdatedAtStage sourceLabel(@NotNull String var1);
    }

    public static interface QuantityUsedStage {
        public SourceLabelStage quantityUsed(double var1);
    }

    public static interface QuantityRemainingStage {
        public QuantityUsedStage quantityRemaining(double var1);
    }

    public static interface QuantityStage {
        public QuantityRemainingStage quantity(int var1);
    }

    public static interface IdStage {
        public QuantityStage id(@NotNull String var1);
    }

    public static interface GrantReasonStage {
        public IdStage grantReason(@NotNull String var1);
    }

    public static interface CreditNameStage {
        public GrantReasonStage creditName(@NotNull String var1);
    }

    public static interface CreditDescriptionStage {
        public CreditNameStage creditDescription(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public CreditDescriptionStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface CompanyNameStage {
        public CreatedAtStage companyName(@NotNull String var1);
    }

    public static interface CompanyIdStage {
        public CompanyNameStage companyId(@NotNull String var1);
    }

    public static interface BillingCreditIdStage {
        public CompanyIdStage billingCreditId(@NotNull String var1);

        public Builder from(CreditCompanyGrantView var1);
    }
}

