/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.CreditGrantDetailGrantReason;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreditGrantDetail {
    private final Optional<String> creditTypeIcon;
    private final Optional<OffsetDateTime> expiresAt;
    private final CreditGrantDetailGrantReason grantReason;
    private final double quantity;
    private final Map<String, Object> additionalProperties;

    private CreditGrantDetail(Optional<String> creditTypeIcon, Optional<OffsetDateTime> expiresAt, CreditGrantDetailGrantReason grantReason, double quantity, Map<String, Object> additionalProperties) {
        this.creditTypeIcon = creditTypeIcon;
        this.expiresAt = expiresAt;
        this.grantReason = grantReason;
        this.quantity = quantity;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="credit_type_icon")
    public Optional<String> getCreditTypeIcon() {
        return this.creditTypeIcon;
    }

    @JsonProperty(value="expires_at")
    public Optional<OffsetDateTime> getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="grant_reason")
    public CreditGrantDetailGrantReason getGrantReason() {
        return this.grantReason;
    }

    @JsonProperty(value="quantity")
    public double getQuantity() {
        return this.quantity;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreditGrantDetail && this.equalTo((CreditGrantDetail)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreditGrantDetail other) {
        return this.creditTypeIcon.equals(other.creditTypeIcon) && this.expiresAt.equals(other.expiresAt) && this.grantReason.equals(other.grantReason) && this.quantity == other.quantity;
    }

    public int hashCode() {
        return Objects.hash(this.creditTypeIcon, this.expiresAt, this.grantReason, this.quantity);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GrantReasonStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GrantReasonStage,
    QuantityStage,
    _FinalStage {
        private CreditGrantDetailGrantReason grantReason;
        private double quantity;
        private Optional<OffsetDateTime> expiresAt = Optional.empty();
        private Optional<String> creditTypeIcon = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreditGrantDetail other) {
            this.creditTypeIcon(other.getCreditTypeIcon());
            this.expiresAt(other.getExpiresAt());
            this.grantReason(other.getGrantReason());
            this.quantity(other.getQuantity());
            return this;
        }

        @Override
        @JsonSetter(value="grant_reason")
        public QuantityStage grantReason(@NotNull CreditGrantDetailGrantReason grantReason) {
            this.grantReason = Objects.requireNonNull(grantReason, "grantReason must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public _FinalStage quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        public _FinalStage expiresAt(OffsetDateTime expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        @Override
        @JsonSetter(value="expires_at", nulls=Nulls.SKIP)
        public _FinalStage expiresAt(Optional<OffsetDateTime> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public _FinalStage creditTypeIcon(String creditTypeIcon) {
            this.creditTypeIcon = Optional.ofNullable(creditTypeIcon);
            return this;
        }

        @Override
        @JsonSetter(value="credit_type_icon", nulls=Nulls.SKIP)
        public _FinalStage creditTypeIcon(Optional<String> creditTypeIcon) {
            this.creditTypeIcon = creditTypeIcon;
            return this;
        }

        @Override
        public CreditGrantDetail build() {
            return new CreditGrantDetail(this.creditTypeIcon, this.expiresAt, this.grantReason, this.quantity, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreditGrantDetail build();

        public _FinalStage creditTypeIcon(Optional<String> var1);

        public _FinalStage creditTypeIcon(String var1);

        public _FinalStage expiresAt(Optional<OffsetDateTime> var1);

        public _FinalStage expiresAt(OffsetDateTime var1);
    }

    public static interface QuantityStage {
        public _FinalStage quantity(double var1);
    }

    public static interface GrantReasonStage {
        public QuantityStage grantReason(@NotNull CreditGrantDetailGrantReason var1);

        public Builder from(CreditGrantDetail var1);
    }
}

