/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingCreditLedgerResponseData;
import com.schematic.api.types.CompanyLedgerResponseData;
import com.schematic.api.types.FeatureLedgerResponseData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreditLedgerEnrichedEntryResponseData {
    private final String billingCreditId;
    private final Optional<CompanyLedgerResponseData> company;
    private final String companyId;
    private final Optional<BillingCreditLedgerResponseData> credit;
    private final int expiredGrantCount;
    private final Optional<FeatureLedgerResponseData> feature;
    private final Optional<String> featureId;
    private final OffsetDateTime firstTransactionAt;
    private final int freeGrantCount;
    private final int grantCount;
    private final OffsetDateTime lastTransactionAt;
    private final int manuallyZeroedCount;
    private final double netChange;
    private final int planGrantCount;
    private final int purchasedGrantCount;
    private final OffsetDateTime timeBucket;
    private final double totalConsumed;
    private final double totalGranted;
    private final int transactionCount;
    private final int usageCount;
    private final int zeroedOutCount;
    private final Map<String, Object> additionalProperties;

    private CreditLedgerEnrichedEntryResponseData(String billingCreditId, Optional<CompanyLedgerResponseData> company, String companyId, Optional<BillingCreditLedgerResponseData> credit, int expiredGrantCount, Optional<FeatureLedgerResponseData> feature, Optional<String> featureId, OffsetDateTime firstTransactionAt, int freeGrantCount, int grantCount, OffsetDateTime lastTransactionAt, int manuallyZeroedCount, double netChange, int planGrantCount, int purchasedGrantCount, OffsetDateTime timeBucket, double totalConsumed, double totalGranted, int transactionCount, int usageCount, int zeroedOutCount, Map<String, Object> additionalProperties) {
        this.billingCreditId = billingCreditId;
        this.company = company;
        this.companyId = companyId;
        this.credit = credit;
        this.expiredGrantCount = expiredGrantCount;
        this.feature = feature;
        this.featureId = featureId;
        this.firstTransactionAt = firstTransactionAt;
        this.freeGrantCount = freeGrantCount;
        this.grantCount = grantCount;
        this.lastTransactionAt = lastTransactionAt;
        this.manuallyZeroedCount = manuallyZeroedCount;
        this.netChange = netChange;
        this.planGrantCount = planGrantCount;
        this.purchasedGrantCount = purchasedGrantCount;
        this.timeBucket = timeBucket;
        this.totalConsumed = totalConsumed;
        this.totalGranted = totalGranted;
        this.transactionCount = transactionCount;
        this.usageCount = usageCount;
        this.zeroedOutCount = zeroedOutCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="billing_credit_id")
    public String getBillingCreditId() {
        return this.billingCreditId;
    }

    @JsonProperty(value="company")
    public Optional<CompanyLedgerResponseData> getCompany() {
        return this.company;
    }

    @JsonProperty(value="company_id")
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="credit")
    public Optional<BillingCreditLedgerResponseData> getCredit() {
        return this.credit;
    }

    @JsonProperty(value="expired_grant_count")
    public int getExpiredGrantCount() {
        return this.expiredGrantCount;
    }

    @JsonProperty(value="feature")
    public Optional<FeatureLedgerResponseData> getFeature() {
        return this.feature;
    }

    @JsonProperty(value="feature_id")
    public Optional<String> getFeatureId() {
        return this.featureId;
    }

    @JsonProperty(value="first_transaction_at")
    public OffsetDateTime getFirstTransactionAt() {
        return this.firstTransactionAt;
    }

    @JsonProperty(value="free_grant_count")
    public int getFreeGrantCount() {
        return this.freeGrantCount;
    }

    @JsonProperty(value="grant_count")
    public int getGrantCount() {
        return this.grantCount;
    }

    @JsonProperty(value="last_transaction_at")
    public OffsetDateTime getLastTransactionAt() {
        return this.lastTransactionAt;
    }

    @JsonProperty(value="manually_zeroed_count")
    public int getManuallyZeroedCount() {
        return this.manuallyZeroedCount;
    }

    @JsonProperty(value="net_change")
    public double getNetChange() {
        return this.netChange;
    }

    @JsonProperty(value="plan_grant_count")
    public int getPlanGrantCount() {
        return this.planGrantCount;
    }

    @JsonProperty(value="purchased_grant_count")
    public int getPurchasedGrantCount() {
        return this.purchasedGrantCount;
    }

    @JsonProperty(value="time_bucket")
    public OffsetDateTime getTimeBucket() {
        return this.timeBucket;
    }

    @JsonProperty(value="total_consumed")
    public double getTotalConsumed() {
        return this.totalConsumed;
    }

    @JsonProperty(value="total_granted")
    public double getTotalGranted() {
        return this.totalGranted;
    }

    @JsonProperty(value="transaction_count")
    public int getTransactionCount() {
        return this.transactionCount;
    }

    @JsonProperty(value="usage_count")
    public int getUsageCount() {
        return this.usageCount;
    }

    @JsonProperty(value="zeroed_out_count")
    public int getZeroedOutCount() {
        return this.zeroedOutCount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreditLedgerEnrichedEntryResponseData && this.equalTo((CreditLedgerEnrichedEntryResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreditLedgerEnrichedEntryResponseData other) {
        return this.billingCreditId.equals(other.billingCreditId) && this.company.equals(other.company) && this.companyId.equals(other.companyId) && this.credit.equals(other.credit) && this.expiredGrantCount == other.expiredGrantCount && this.feature.equals(other.feature) && this.featureId.equals(other.featureId) && this.firstTransactionAt.equals(other.firstTransactionAt) && this.freeGrantCount == other.freeGrantCount && this.grantCount == other.grantCount && this.lastTransactionAt.equals(other.lastTransactionAt) && this.manuallyZeroedCount == other.manuallyZeroedCount && this.netChange == other.netChange && this.planGrantCount == other.planGrantCount && this.purchasedGrantCount == other.purchasedGrantCount && this.timeBucket.equals(other.timeBucket) && this.totalConsumed == other.totalConsumed && this.totalGranted == other.totalGranted && this.transactionCount == other.transactionCount && this.usageCount == other.usageCount && this.zeroedOutCount == other.zeroedOutCount;
    }

    public int hashCode() {
        return Objects.hash(this.billingCreditId, this.company, this.companyId, this.credit, this.expiredGrantCount, this.feature, this.featureId, this.firstTransactionAt, this.freeGrantCount, this.grantCount, this.lastTransactionAt, this.manuallyZeroedCount, this.netChange, this.planGrantCount, this.purchasedGrantCount, this.timeBucket, this.totalConsumed, this.totalGranted, this.transactionCount, this.usageCount, this.zeroedOutCount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BillingCreditIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BillingCreditIdStage,
    CompanyIdStage,
    ExpiredGrantCountStage,
    FirstTransactionAtStage,
    FreeGrantCountStage,
    GrantCountStage,
    LastTransactionAtStage,
    ManuallyZeroedCountStage,
    NetChangeStage,
    PlanGrantCountStage,
    PurchasedGrantCountStage,
    TimeBucketStage,
    TotalConsumedStage,
    TotalGrantedStage,
    TransactionCountStage,
    UsageCountStage,
    ZeroedOutCountStage,
    _FinalStage {
        private String billingCreditId;
        private String companyId;
        private int expiredGrantCount;
        private OffsetDateTime firstTransactionAt;
        private int freeGrantCount;
        private int grantCount;
        private OffsetDateTime lastTransactionAt;
        private int manuallyZeroedCount;
        private double netChange;
        private int planGrantCount;
        private int purchasedGrantCount;
        private OffsetDateTime timeBucket;
        private double totalConsumed;
        private double totalGranted;
        private int transactionCount;
        private int usageCount;
        private int zeroedOutCount;
        private Optional<String> featureId = Optional.empty();
        private Optional<FeatureLedgerResponseData> feature = Optional.empty();
        private Optional<BillingCreditLedgerResponseData> credit = Optional.empty();
        private Optional<CompanyLedgerResponseData> company = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreditLedgerEnrichedEntryResponseData other) {
            this.billingCreditId(other.getBillingCreditId());
            this.company(other.getCompany());
            this.companyId(other.getCompanyId());
            this.credit(other.getCredit());
            this.expiredGrantCount(other.getExpiredGrantCount());
            this.feature(other.getFeature());
            this.featureId(other.getFeatureId());
            this.firstTransactionAt(other.getFirstTransactionAt());
            this.freeGrantCount(other.getFreeGrantCount());
            this.grantCount(other.getGrantCount());
            this.lastTransactionAt(other.getLastTransactionAt());
            this.manuallyZeroedCount(other.getManuallyZeroedCount());
            this.netChange(other.getNetChange());
            this.planGrantCount(other.getPlanGrantCount());
            this.purchasedGrantCount(other.getPurchasedGrantCount());
            this.timeBucket(other.getTimeBucket());
            this.totalConsumed(other.getTotalConsumed());
            this.totalGranted(other.getTotalGranted());
            this.transactionCount(other.getTransactionCount());
            this.usageCount(other.getUsageCount());
            this.zeroedOutCount(other.getZeroedOutCount());
            return this;
        }

        @Override
        @JsonSetter(value="billing_credit_id")
        public CompanyIdStage billingCreditId(@NotNull String billingCreditId) {
            this.billingCreditId = Objects.requireNonNull(billingCreditId, "billingCreditId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="company_id")
        public ExpiredGrantCountStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="expired_grant_count")
        public FirstTransactionAtStage expiredGrantCount(int expiredGrantCount) {
            this.expiredGrantCount = expiredGrantCount;
            return this;
        }

        @Override
        @JsonSetter(value="first_transaction_at")
        public FreeGrantCountStage firstTransactionAt(@NotNull OffsetDateTime firstTransactionAt) {
            this.firstTransactionAt = Objects.requireNonNull(firstTransactionAt, "firstTransactionAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="free_grant_count")
        public GrantCountStage freeGrantCount(int freeGrantCount) {
            this.freeGrantCount = freeGrantCount;
            return this;
        }

        @Override
        @JsonSetter(value="grant_count")
        public LastTransactionAtStage grantCount(int grantCount) {
            this.grantCount = grantCount;
            return this;
        }

        @Override
        @JsonSetter(value="last_transaction_at")
        public ManuallyZeroedCountStage lastTransactionAt(@NotNull OffsetDateTime lastTransactionAt) {
            this.lastTransactionAt = Objects.requireNonNull(lastTransactionAt, "lastTransactionAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="manually_zeroed_count")
        public NetChangeStage manuallyZeroedCount(int manuallyZeroedCount) {
            this.manuallyZeroedCount = manuallyZeroedCount;
            return this;
        }

        @Override
        @JsonSetter(value="net_change")
        public PlanGrantCountStage netChange(double netChange) {
            this.netChange = netChange;
            return this;
        }

        @Override
        @JsonSetter(value="plan_grant_count")
        public PurchasedGrantCountStage planGrantCount(int planGrantCount) {
            this.planGrantCount = planGrantCount;
            return this;
        }

        @Override
        @JsonSetter(value="purchased_grant_count")
        public TimeBucketStage purchasedGrantCount(int purchasedGrantCount) {
            this.purchasedGrantCount = purchasedGrantCount;
            return this;
        }

        @Override
        @JsonSetter(value="time_bucket")
        public TotalConsumedStage timeBucket(@NotNull OffsetDateTime timeBucket) {
            this.timeBucket = Objects.requireNonNull(timeBucket, "timeBucket must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="total_consumed")
        public TotalGrantedStage totalConsumed(double totalConsumed) {
            this.totalConsumed = totalConsumed;
            return this;
        }

        @Override
        @JsonSetter(value="total_granted")
        public TransactionCountStage totalGranted(double totalGranted) {
            this.totalGranted = totalGranted;
            return this;
        }

        @Override
        @JsonSetter(value="transaction_count")
        public UsageCountStage transactionCount(int transactionCount) {
            this.transactionCount = transactionCount;
            return this;
        }

        @Override
        @JsonSetter(value="usage_count")
        public ZeroedOutCountStage usageCount(int usageCount) {
            this.usageCount = usageCount;
            return this;
        }

        @Override
        @JsonSetter(value="zeroed_out_count")
        public _FinalStage zeroedOutCount(int zeroedOutCount) {
            this.zeroedOutCount = zeroedOutCount;
            return this;
        }

        @Override
        public _FinalStage featureId(String featureId) {
            this.featureId = Optional.ofNullable(featureId);
            return this;
        }

        @Override
        @JsonSetter(value="feature_id", nulls=Nulls.SKIP)
        public _FinalStage featureId(Optional<String> featureId) {
            this.featureId = featureId;
            return this;
        }

        @Override
        public _FinalStage feature(FeatureLedgerResponseData feature) {
            this.feature = Optional.ofNullable(feature);
            return this;
        }

        @Override
        @JsonSetter(value="feature", nulls=Nulls.SKIP)
        public _FinalStage feature(Optional<FeatureLedgerResponseData> feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public _FinalStage credit(BillingCreditLedgerResponseData credit) {
            this.credit = Optional.ofNullable(credit);
            return this;
        }

        @Override
        @JsonSetter(value="credit", nulls=Nulls.SKIP)
        public _FinalStage credit(Optional<BillingCreditLedgerResponseData> credit) {
            this.credit = credit;
            return this;
        }

        @Override
        public _FinalStage company(CompanyLedgerResponseData company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @Override
        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public _FinalStage company(Optional<CompanyLedgerResponseData> company) {
            this.company = company;
            return this;
        }

        @Override
        public CreditLedgerEnrichedEntryResponseData build() {
            return new CreditLedgerEnrichedEntryResponseData(this.billingCreditId, this.company, this.companyId, this.credit, this.expiredGrantCount, this.feature, this.featureId, this.firstTransactionAt, this.freeGrantCount, this.grantCount, this.lastTransactionAt, this.manuallyZeroedCount, this.netChange, this.planGrantCount, this.purchasedGrantCount, this.timeBucket, this.totalConsumed, this.totalGranted, this.transactionCount, this.usageCount, this.zeroedOutCount, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreditLedgerEnrichedEntryResponseData build();

        public _FinalStage company(Optional<CompanyLedgerResponseData> var1);

        public _FinalStage company(CompanyLedgerResponseData var1);

        public _FinalStage credit(Optional<BillingCreditLedgerResponseData> var1);

        public _FinalStage credit(BillingCreditLedgerResponseData var1);

        public _FinalStage feature(Optional<FeatureLedgerResponseData> var1);

        public _FinalStage feature(FeatureLedgerResponseData var1);

        public _FinalStage featureId(Optional<String> var1);

        public _FinalStage featureId(String var1);
    }

    public static interface ZeroedOutCountStage {
        public _FinalStage zeroedOutCount(int var1);
    }

    public static interface UsageCountStage {
        public ZeroedOutCountStage usageCount(int var1);
    }

    public static interface TransactionCountStage {
        public UsageCountStage transactionCount(int var1);
    }

    public static interface TotalGrantedStage {
        public TransactionCountStage totalGranted(double var1);
    }

    public static interface TotalConsumedStage {
        public TotalGrantedStage totalConsumed(double var1);
    }

    public static interface TimeBucketStage {
        public TotalConsumedStage timeBucket(@NotNull OffsetDateTime var1);
    }

    public static interface PurchasedGrantCountStage {
        public TimeBucketStage purchasedGrantCount(int var1);
    }

    public static interface PlanGrantCountStage {
        public PurchasedGrantCountStage planGrantCount(int var1);
    }

    public static interface NetChangeStage {
        public PlanGrantCountStage netChange(double var1);
    }

    public static interface ManuallyZeroedCountStage {
        public NetChangeStage manuallyZeroedCount(int var1);
    }

    public static interface LastTransactionAtStage {
        public ManuallyZeroedCountStage lastTransactionAt(@NotNull OffsetDateTime var1);
    }

    public static interface GrantCountStage {
        public LastTransactionAtStage grantCount(int var1);
    }

    public static interface FreeGrantCountStage {
        public GrantCountStage freeGrantCount(int var1);
    }

    public static interface FirstTransactionAtStage {
        public FreeGrantCountStage firstTransactionAt(@NotNull OffsetDateTime var1);
    }

    public static interface ExpiredGrantCountStage {
        public FirstTransactionAtStage expiredGrantCount(int var1);
    }

    public static interface CompanyIdStage {
        public ExpiredGrantCountStage companyId(@NotNull String var1);
    }

    public static interface BillingCreditIdStage {
        public CompanyIdStage billingCreditId(@NotNull String var1);

        public Builder from(CreditLedgerEnrichedEntryResponseData var1);
    }
}

