/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreditTriggerConfig {
    private final String creditId;
    private final Map<String, Object> additionalProperties;

    private CreditTriggerConfig(String creditId, Map<String, Object> additionalProperties) {
        this.creditId = creditId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="credit_id")
    public String getCreditId() {
        return this.creditId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreditTriggerConfig && this.equalTo((CreditTriggerConfig)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreditTriggerConfig other) {
        return this.creditId.equals(other.creditId);
    }

    public int hashCode() {
        return Objects.hash(this.creditId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreditIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreditIdStage,
    _FinalStage {
        private String creditId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreditTriggerConfig other) {
            this.creditId(other.getCreditId());
            return this;
        }

        @Override
        @JsonSetter(value="credit_id")
        public _FinalStage creditId(@NotNull String creditId) {
            this.creditId = Objects.requireNonNull(creditId, "creditId must not be null");
            return this;
        }

        @Override
        public CreditTriggerConfig build() {
            return new CreditTriggerConfig(this.creditId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreditTriggerConfig build();
    }

    public static interface CreditIdStage {
        public _FinalStage creditId(@NotNull String var1);

        public Builder from(CreditTriggerConfig var1);
    }
}

