/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.CreditGrantDetail;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreditUsage {
    private final Optional<Double> creditConsumptionRate;
    private final Optional<Map<String, Double>> creditGrantCounts;
    private final Optional<List<CreditGrantDetail>> creditGrantDetails;
    private final Optional<Double> creditRemaining;
    private final Optional<Double> creditTotal;
    private final Optional<String> creditTypeIcon;
    private final Optional<String> creditTypeName;
    private final Optional<Double> creditUsed;
    private final Map<String, Object> additionalProperties;

    private CreditUsage(Optional<Double> creditConsumptionRate, Optional<Map<String, Double>> creditGrantCounts, Optional<List<CreditGrantDetail>> creditGrantDetails, Optional<Double> creditRemaining, Optional<Double> creditTotal, Optional<String> creditTypeIcon, Optional<String> creditTypeName, Optional<Double> creditUsed, Map<String, Object> additionalProperties) {
        this.creditConsumptionRate = creditConsumptionRate;
        this.creditGrantCounts = creditGrantCounts;
        this.creditGrantDetails = creditGrantDetails;
        this.creditRemaining = creditRemaining;
        this.creditTotal = creditTotal;
        this.creditTypeIcon = creditTypeIcon;
        this.creditTypeName = creditTypeName;
        this.creditUsed = creditUsed;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="credit_consumption_rate")
    public Optional<Double> getCreditConsumptionRate() {
        return this.creditConsumptionRate;
    }

    @JsonProperty(value="credit_grant_counts")
    public Optional<Map<String, Double>> getCreditGrantCounts() {
        return this.creditGrantCounts;
    }

    @JsonProperty(value="credit_grant_details")
    public Optional<List<CreditGrantDetail>> getCreditGrantDetails() {
        return this.creditGrantDetails;
    }

    @JsonProperty(value="credit_remaining")
    public Optional<Double> getCreditRemaining() {
        return this.creditRemaining;
    }

    @JsonProperty(value="credit_total")
    public Optional<Double> getCreditTotal() {
        return this.creditTotal;
    }

    @JsonProperty(value="credit_type_icon")
    public Optional<String> getCreditTypeIcon() {
        return this.creditTypeIcon;
    }

    @JsonProperty(value="credit_type_name")
    public Optional<String> getCreditTypeName() {
        return this.creditTypeName;
    }

    @JsonProperty(value="credit_used")
    public Optional<Double> getCreditUsed() {
        return this.creditUsed;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreditUsage && this.equalTo((CreditUsage)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreditUsage other) {
        return this.creditConsumptionRate.equals(other.creditConsumptionRate) && this.creditGrantCounts.equals(other.creditGrantCounts) && this.creditGrantDetails.equals(other.creditGrantDetails) && this.creditRemaining.equals(other.creditRemaining) && this.creditTotal.equals(other.creditTotal) && this.creditTypeIcon.equals(other.creditTypeIcon) && this.creditTypeName.equals(other.creditTypeName) && this.creditUsed.equals(other.creditUsed);
    }

    public int hashCode() {
        return Objects.hash(this.creditConsumptionRate, this.creditGrantCounts, this.creditGrantDetails, this.creditRemaining, this.creditTotal, this.creditTypeIcon, this.creditTypeName, this.creditUsed);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Double> creditConsumptionRate = Optional.empty();
        private Optional<Map<String, Double>> creditGrantCounts = Optional.empty();
        private Optional<List<CreditGrantDetail>> creditGrantDetails = Optional.empty();
        private Optional<Double> creditRemaining = Optional.empty();
        private Optional<Double> creditTotal = Optional.empty();
        private Optional<String> creditTypeIcon = Optional.empty();
        private Optional<String> creditTypeName = Optional.empty();
        private Optional<Double> creditUsed = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreditUsage other) {
            this.creditConsumptionRate(other.getCreditConsumptionRate());
            this.creditGrantCounts(other.getCreditGrantCounts());
            this.creditGrantDetails(other.getCreditGrantDetails());
            this.creditRemaining(other.getCreditRemaining());
            this.creditTotal(other.getCreditTotal());
            this.creditTypeIcon(other.getCreditTypeIcon());
            this.creditTypeName(other.getCreditTypeName());
            this.creditUsed(other.getCreditUsed());
            return this;
        }

        @JsonSetter(value="credit_consumption_rate", nulls=Nulls.SKIP)
        public Builder creditConsumptionRate(Optional<Double> creditConsumptionRate) {
            this.creditConsumptionRate = creditConsumptionRate;
            return this;
        }

        public Builder creditConsumptionRate(Double creditConsumptionRate) {
            this.creditConsumptionRate = Optional.ofNullable(creditConsumptionRate);
            return this;
        }

        @JsonSetter(value="credit_grant_counts", nulls=Nulls.SKIP)
        public Builder creditGrantCounts(Optional<Map<String, Double>> creditGrantCounts) {
            this.creditGrantCounts = creditGrantCounts;
            return this;
        }

        public Builder creditGrantCounts(Map<String, Double> creditGrantCounts) {
            this.creditGrantCounts = Optional.ofNullable(creditGrantCounts);
            return this;
        }

        @JsonSetter(value="credit_grant_details", nulls=Nulls.SKIP)
        public Builder creditGrantDetails(Optional<List<CreditGrantDetail>> creditGrantDetails) {
            this.creditGrantDetails = creditGrantDetails;
            return this;
        }

        public Builder creditGrantDetails(List<CreditGrantDetail> creditGrantDetails) {
            this.creditGrantDetails = Optional.ofNullable(creditGrantDetails);
            return this;
        }

        @JsonSetter(value="credit_remaining", nulls=Nulls.SKIP)
        public Builder creditRemaining(Optional<Double> creditRemaining) {
            this.creditRemaining = creditRemaining;
            return this;
        }

        public Builder creditRemaining(Double creditRemaining) {
            this.creditRemaining = Optional.ofNullable(creditRemaining);
            return this;
        }

        @JsonSetter(value="credit_total", nulls=Nulls.SKIP)
        public Builder creditTotal(Optional<Double> creditTotal) {
            this.creditTotal = creditTotal;
            return this;
        }

        public Builder creditTotal(Double creditTotal) {
            this.creditTotal = Optional.ofNullable(creditTotal);
            return this;
        }

        @JsonSetter(value="credit_type_icon", nulls=Nulls.SKIP)
        public Builder creditTypeIcon(Optional<String> creditTypeIcon) {
            this.creditTypeIcon = creditTypeIcon;
            return this;
        }

        public Builder creditTypeIcon(String creditTypeIcon) {
            this.creditTypeIcon = Optional.ofNullable(creditTypeIcon);
            return this;
        }

        @JsonSetter(value="credit_type_name", nulls=Nulls.SKIP)
        public Builder creditTypeName(Optional<String> creditTypeName) {
            this.creditTypeName = creditTypeName;
            return this;
        }

        public Builder creditTypeName(String creditTypeName) {
            this.creditTypeName = Optional.ofNullable(creditTypeName);
            return this;
        }

        @JsonSetter(value="credit_used", nulls=Nulls.SKIP)
        public Builder creditUsed(Optional<Double> creditUsed) {
            this.creditUsed = creditUsed;
            return this;
        }

        public Builder creditUsed(Double creditUsed) {
            this.creditUsed = Optional.ofNullable(creditUsed);
            return this;
        }

        public CreditUsage build() {
            return new CreditUsage(this.creditConsumptionRate, this.creditGrantCounts, this.creditGrantDetails, this.creditRemaining, this.creditTotal, this.creditTypeIcon, this.creditTypeName, this.creditUsed, this.additionalProperties);
        }
    }
}

