/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomPlanConfig {
    private final String ctaText;
    private final String ctaWebSite;
    private final String priceText;
    private final Map<String, Object> additionalProperties;

    private CustomPlanConfig(String ctaText, String ctaWebSite, String priceText, Map<String, Object> additionalProperties) {
        this.ctaText = ctaText;
        this.ctaWebSite = ctaWebSite;
        this.priceText = priceText;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="cta_text")
    public String getCtaText() {
        return this.ctaText;
    }

    @JsonProperty(value="cta_web_site")
    public String getCtaWebSite() {
        return this.ctaWebSite;
    }

    @JsonProperty(value="price_text")
    public String getPriceText() {
        return this.priceText;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomPlanConfig && this.equalTo((CustomPlanConfig)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomPlanConfig other) {
        return this.ctaText.equals(other.ctaText) && this.ctaWebSite.equals(other.ctaWebSite) && this.priceText.equals(other.priceText);
    }

    public int hashCode() {
        return Objects.hash(this.ctaText, this.ctaWebSite, this.priceText);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CtaTextStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CtaTextStage,
    CtaWebSiteStage,
    PriceTextStage,
    _FinalStage {
        private String ctaText;
        private String ctaWebSite;
        private String priceText;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CustomPlanConfig other) {
            this.ctaText(other.getCtaText());
            this.ctaWebSite(other.getCtaWebSite());
            this.priceText(other.getPriceText());
            return this;
        }

        @Override
        @JsonSetter(value="cta_text")
        public CtaWebSiteStage ctaText(@NotNull String ctaText) {
            this.ctaText = Objects.requireNonNull(ctaText, "ctaText must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="cta_web_site")
        public PriceTextStage ctaWebSite(@NotNull String ctaWebSite) {
            this.ctaWebSite = Objects.requireNonNull(ctaWebSite, "ctaWebSite must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="price_text")
        public _FinalStage priceText(@NotNull String priceText) {
            this.priceText = Objects.requireNonNull(priceText, "priceText must not be null");
            return this;
        }

        @Override
        public CustomPlanConfig build() {
            return new CustomPlanConfig(this.ctaText, this.ctaWebSite, this.priceText, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CustomPlanConfig build();
    }

    public static interface PriceTextStage {
        public _FinalStage priceText(@NotNull String var1);
    }

    public static interface CtaWebSiteStage {
        public PriceTextStage ctaWebSite(@NotNull String var1);
    }

    public static interface CtaTextStage {
        public CtaWebSiteStage ctaText(@NotNull String var1);

        public Builder from(CustomPlanConfig var1);
    }
}

