/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DataExportResponseData {
    private final String accountId;
    private final OffsetDateTime createdAt;
    private final String environmentId;
    private final String exportType;
    private final String id;
    private final String metadata;
    private final String outputFileType;
    private final String status;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private DataExportResponseData(String accountId, OffsetDateTime createdAt, String environmentId, String exportType, String id, String metadata, String outputFileType, String status, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.createdAt = createdAt;
        this.environmentId = environmentId;
        this.exportType = exportType;
        this.id = id;
        this.metadata = metadata;
        this.outputFileType = outputFileType;
        this.status = status;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="account_id")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="export_type")
    public String getExportType() {
        return this.exportType;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="metadata")
    public String getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="output_file_type")
    public String getOutputFileType() {
        return this.outputFileType;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DataExportResponseData && this.equalTo((DataExportResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataExportResponseData other) {
        return this.accountId.equals(other.accountId) && this.createdAt.equals(other.createdAt) && this.environmentId.equals(other.environmentId) && this.exportType.equals(other.exportType) && this.id.equals(other.id) && this.metadata.equals(other.metadata) && this.outputFileType.equals(other.outputFileType) && this.status.equals(other.status) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.createdAt, this.environmentId, this.exportType, this.id, this.metadata, this.outputFileType, this.status, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccountIdStage,
    CreatedAtStage,
    EnvironmentIdStage,
    ExportTypeStage,
    IdStage,
    MetadataStage,
    OutputFileTypeStage,
    StatusStage,
    UpdatedAtStage,
    _FinalStage {
        private String accountId;
        private OffsetDateTime createdAt;
        private String environmentId;
        private String exportType;
        private String id;
        private String metadata;
        private String outputFileType;
        private String status;
        private OffsetDateTime updatedAt;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DataExportResponseData other) {
            this.accountId(other.getAccountId());
            this.createdAt(other.getCreatedAt());
            this.environmentId(other.getEnvironmentId());
            this.exportType(other.getExportType());
            this.id(other.getId());
            this.metadata(other.getMetadata());
            this.outputFileType(other.getOutputFileType());
            this.status(other.getStatus());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="account_id")
        public CreatedAtStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public ExportTypeStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="export_type")
        public IdStage exportType(@NotNull String exportType) {
            this.exportType = Objects.requireNonNull(exportType, "exportType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public MetadataStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="metadata")
        public OutputFileTypeStage metadata(@NotNull String metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="output_file_type")
        public StatusStage outputFileType(@NotNull String outputFileType) {
            this.outputFileType = Objects.requireNonNull(outputFileType, "outputFileType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public UpdatedAtStage status(@NotNull String status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public DataExportResponseData build() {
            return new DataExportResponseData(this.accountId, this.createdAt, this.environmentId, this.exportType, this.id, this.metadata, this.outputFileType, this.status, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DataExportResponseData build();
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface StatusStage {
        public UpdatedAtStage status(@NotNull String var1);
    }

    public static interface OutputFileTypeStage {
        public StatusStage outputFileType(@NotNull String var1);
    }

    public static interface MetadataStage {
        public OutputFileTypeStage metadata(@NotNull String var1);
    }

    public static interface IdStage {
        public MetadataStage id(@NotNull String var1);
    }

    public static interface ExportTypeStage {
        public IdStage exportType(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public ExportTypeStage environmentId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface AccountIdStage {
        public CreatedAtStage accountId(@NotNull String var1);

        public Builder from(DataExportResponseData var1);
    }
}

