/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EntityTraitResponseData {
    private final OffsetDateTime createdAt;
    private final String definitionId;
    private final String environmentId;
    private final String id;
    private final OffsetDateTime updatedAt;
    private final String value;
    private final Map<String, Object> additionalProperties;

    private EntityTraitResponseData(OffsetDateTime createdAt, String definitionId, String environmentId, String id, OffsetDateTime updatedAt, String value, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.definitionId = definitionId;
        this.environmentId = environmentId;
        this.id = id;
        this.updatedAt = updatedAt;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="definition_id")
    public String getDefinitionId() {
        return this.definitionId;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EntityTraitResponseData && this.equalTo((EntityTraitResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EntityTraitResponseData other) {
        return this.createdAt.equals(other.createdAt) && this.definitionId.equals(other.definitionId) && this.environmentId.equals(other.environmentId) && this.id.equals(other.id) && this.updatedAt.equals(other.updatedAt) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.definitionId, this.environmentId, this.id, this.updatedAt, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    DefinitionIdStage,
    EnvironmentIdStage,
    IdStage,
    UpdatedAtStage,
    ValueStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String definitionId;
        private String environmentId;
        private String id;
        private OffsetDateTime updatedAt;
        private String value;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(EntityTraitResponseData other) {
            this.createdAt(other.getCreatedAt());
            this.definitionId(other.getDefinitionId());
            this.environmentId(other.getEnvironmentId());
            this.id(other.getId());
            this.updatedAt(other.getUpdatedAt());
            this.value(other.getValue());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public DefinitionIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="definition_id")
        public EnvironmentIdStage definitionId(@NotNull String definitionId) {
            this.definitionId = Objects.requireNonNull(definitionId, "definitionId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public UpdatedAtStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public ValueStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(@NotNull String value) {
            this.value = Objects.requireNonNull(value, "value must not be null");
            return this;
        }

        @Override
        public EntityTraitResponseData build() {
            return new EntityTraitResponseData(this.createdAt, this.definitionId, this.environmentId, this.id, this.updatedAt, this.value, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public EntityTraitResponseData build();
    }

    public static interface ValueStage {
        public _FinalStage value(@NotNull String var1);
    }

    public static interface UpdatedAtStage {
        public ValueStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface IdStage {
        public UpdatedAtStage id(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public IdStage environmentId(@NotNull String var1);
    }

    public static interface DefinitionIdStage {
        public EnvironmentIdStage definitionId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public DefinitionIdStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(EntityTraitResponseData var1);
    }
}

