/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.ApiKeyResponseData;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EnvironmentDetailResponseData {
    private final List<ApiKeyResponseData> apiKeys;
    private final OffsetDateTime createdAt;
    private final String environmentType;
    private final String id;
    private final String name;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private EnvironmentDetailResponseData(List<ApiKeyResponseData> apiKeys, OffsetDateTime createdAt, String environmentType, String id, String name, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.apiKeys = apiKeys;
        this.createdAt = createdAt;
        this.environmentType = environmentType;
        this.id = id;
        this.name = name;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="api_keys")
    public List<ApiKeyResponseData> getApiKeys() {
        return this.apiKeys;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="environment_type")
    public String getEnvironmentType() {
        return this.environmentType;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EnvironmentDetailResponseData && this.equalTo((EnvironmentDetailResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EnvironmentDetailResponseData other) {
        return this.apiKeys.equals(other.apiKeys) && this.createdAt.equals(other.createdAt) && this.environmentType.equals(other.environmentType) && this.id.equals(other.id) && this.name.equals(other.name) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.apiKeys, this.createdAt, this.environmentType, this.id, this.name, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    EnvironmentTypeStage,
    IdStage,
    NameStage,
    UpdatedAtStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String environmentType;
        private String id;
        private String name;
        private OffsetDateTime updatedAt;
        private List<ApiKeyResponseData> apiKeys = new ArrayList<ApiKeyResponseData>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(EnvironmentDetailResponseData other) {
            this.apiKeys(other.getApiKeys());
            this.createdAt(other.getCreatedAt());
            this.environmentType(other.getEnvironmentType());
            this.id(other.getId());
            this.name(other.getName());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public EnvironmentTypeStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_type")
        public IdStage environmentType(@NotNull String environmentType) {
            this.environmentType = Objects.requireNonNull(environmentType, "environmentType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public UpdatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllApiKeys(List<ApiKeyResponseData> apiKeys) {
            if (apiKeys != null) {
                this.apiKeys.addAll(apiKeys);
            }
            return this;
        }

        @Override
        public _FinalStage addApiKeys(ApiKeyResponseData apiKeys) {
            this.apiKeys.add(apiKeys);
            return this;
        }

        @Override
        @JsonSetter(value="api_keys", nulls=Nulls.SKIP)
        public _FinalStage apiKeys(List<ApiKeyResponseData> apiKeys) {
            this.apiKeys.clear();
            if (apiKeys != null) {
                this.apiKeys.addAll(apiKeys);
            }
            return this;
        }

        @Override
        public EnvironmentDetailResponseData build() {
            return new EnvironmentDetailResponseData(this.apiKeys, this.createdAt, this.environmentType, this.id, this.name, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public EnvironmentDetailResponseData build();

        public _FinalStage apiKeys(List<ApiKeyResponseData> var1);

        public _FinalStage addApiKeys(ApiKeyResponseData var1);

        public _FinalStage addAllApiKeys(List<ApiKeyResponseData> var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface NameStage {
        public UpdatedAtStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface EnvironmentTypeStage {
        public IdStage environmentType(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public EnvironmentTypeStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(EnvironmentDetailResponseData var1);
    }
}

