/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingPriceView;
import com.schematic.api.types.CompanyDetailResponseData;
import com.schematic.api.types.CompanyOverrideResponseData;
import com.schematic.api.types.CreditGrantDetail;
import com.schematic.api.types.CreditUsage;
import com.schematic.api.types.FeatureCompanyResponseDataAllocationType;
import com.schematic.api.types.FeatureCompanyResponseDataCreditGrantReason;
import com.schematic.api.types.FeatureDetailResponseData;
import com.schematic.api.types.PlanEntitlementResponseData;
import com.schematic.api.types.PlanResponseData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FeatureCompanyResponseData {
    private final boolean access;
    private final Optional<Integer> allocation;
    private final FeatureCompanyResponseDataAllocationType allocationType;
    private final Optional<CompanyDetailResponseData> company;
    private final Optional<CompanyOverrideResponseData> companyOverride;
    private final Optional<Double> creditConsumptionRate;
    private final Optional<Map<String, Double>> creditGrantCounts;
    private final Optional<List<CreditGrantDetail>> creditGrantDetails;
    private final Optional<FeatureCompanyResponseDataCreditGrantReason> creditGrantReason;
    private final Optional<Double> creditRemaining;
    private final Optional<Double> creditTotal;
    private final Optional<String> creditTypeIcon;
    private final Optional<CreditUsage> creditUsage;
    private final Optional<Double> creditUsed;
    private final Optional<Integer> effectiveLimit;
    private final Optional<Double> effectivePrice;
    private final Optional<OffsetDateTime> entitlementExpirationDate;
    private final String entitlementId;
    private final Optional<String> entitlementSource;
    private final String entitlementType;
    private final Optional<FeatureDetailResponseData> feature;
    private final Optional<Boolean> hasValidAllocation;
    private final Optional<Boolean> isUnlimited;
    private final Optional<OffsetDateTime> metricResetAt;
    private final Optional<String> monthReset;
    private final Optional<BillingPriceView> monthlyUsageBasedPrice;
    private final Optional<Integer> overuse;
    private final Optional<Double> percentUsed;
    private final Optional<String> period;
    private final Optional<PlanResponseData> plan;
    private final Optional<PlanEntitlementResponseData> planEntitlement;
    private final Optional<String> priceBehavior;
    private final Optional<Integer> softLimit;
    private final Optional<Integer> usage;
    private final Optional<BillingPriceView> yearlyUsageBasedPrice;
    private final Map<String, Object> additionalProperties;

    private FeatureCompanyResponseData(boolean access, Optional<Integer> allocation, FeatureCompanyResponseDataAllocationType allocationType, Optional<CompanyDetailResponseData> company, Optional<CompanyOverrideResponseData> companyOverride, Optional<Double> creditConsumptionRate, Optional<Map<String, Double>> creditGrantCounts, Optional<List<CreditGrantDetail>> creditGrantDetails, Optional<FeatureCompanyResponseDataCreditGrantReason> creditGrantReason, Optional<Double> creditRemaining, Optional<Double> creditTotal, Optional<String> creditTypeIcon, Optional<CreditUsage> creditUsage, Optional<Double> creditUsed, Optional<Integer> effectiveLimit, Optional<Double> effectivePrice, Optional<OffsetDateTime> entitlementExpirationDate, String entitlementId, Optional<String> entitlementSource, String entitlementType, Optional<FeatureDetailResponseData> feature, Optional<Boolean> hasValidAllocation, Optional<Boolean> isUnlimited, Optional<OffsetDateTime> metricResetAt, Optional<String> monthReset, Optional<BillingPriceView> monthlyUsageBasedPrice, Optional<Integer> overuse, Optional<Double> percentUsed, Optional<String> period, Optional<PlanResponseData> plan, Optional<PlanEntitlementResponseData> planEntitlement, Optional<String> priceBehavior, Optional<Integer> softLimit, Optional<Integer> usage, Optional<BillingPriceView> yearlyUsageBasedPrice, Map<String, Object> additionalProperties) {
        this.access = access;
        this.allocation = allocation;
        this.allocationType = allocationType;
        this.company = company;
        this.companyOverride = companyOverride;
        this.creditConsumptionRate = creditConsumptionRate;
        this.creditGrantCounts = creditGrantCounts;
        this.creditGrantDetails = creditGrantDetails;
        this.creditGrantReason = creditGrantReason;
        this.creditRemaining = creditRemaining;
        this.creditTotal = creditTotal;
        this.creditTypeIcon = creditTypeIcon;
        this.creditUsage = creditUsage;
        this.creditUsed = creditUsed;
        this.effectiveLimit = effectiveLimit;
        this.effectivePrice = effectivePrice;
        this.entitlementExpirationDate = entitlementExpirationDate;
        this.entitlementId = entitlementId;
        this.entitlementSource = entitlementSource;
        this.entitlementType = entitlementType;
        this.feature = feature;
        this.hasValidAllocation = hasValidAllocation;
        this.isUnlimited = isUnlimited;
        this.metricResetAt = metricResetAt;
        this.monthReset = monthReset;
        this.monthlyUsageBasedPrice = monthlyUsageBasedPrice;
        this.overuse = overuse;
        this.percentUsed = percentUsed;
        this.period = period;
        this.plan = plan;
        this.planEntitlement = planEntitlement;
        this.priceBehavior = priceBehavior;
        this.softLimit = softLimit;
        this.usage = usage;
        this.yearlyUsageBasedPrice = yearlyUsageBasedPrice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="access")
    public boolean getAccess() {
        return this.access;
    }

    @JsonProperty(value="allocation")
    public Optional<Integer> getAllocation() {
        return this.allocation;
    }

    @JsonProperty(value="allocation_type")
    public FeatureCompanyResponseDataAllocationType getAllocationType() {
        return this.allocationType;
    }

    @JsonProperty(value="company")
    public Optional<CompanyDetailResponseData> getCompany() {
        return this.company;
    }

    @JsonProperty(value="company_override")
    public Optional<CompanyOverrideResponseData> getCompanyOverride() {
        return this.companyOverride;
    }

    @JsonProperty(value="credit_consumption_rate")
    public Optional<Double> getCreditConsumptionRate() {
        return this.creditConsumptionRate;
    }

    @JsonProperty(value="credit_grant_counts")
    public Optional<Map<String, Double>> getCreditGrantCounts() {
        return this.creditGrantCounts;
    }

    @JsonProperty(value="credit_grant_details")
    public Optional<List<CreditGrantDetail>> getCreditGrantDetails() {
        return this.creditGrantDetails;
    }

    @JsonProperty(value="credit_grant_reason")
    public Optional<FeatureCompanyResponseDataCreditGrantReason> getCreditGrantReason() {
        return this.creditGrantReason;
    }

    @JsonProperty(value="credit_remaining")
    public Optional<Double> getCreditRemaining() {
        return this.creditRemaining;
    }

    @JsonProperty(value="credit_total")
    public Optional<Double> getCreditTotal() {
        return this.creditTotal;
    }

    @JsonProperty(value="credit_type_icon")
    public Optional<String> getCreditTypeIcon() {
        return this.creditTypeIcon;
    }

    @JsonProperty(value="credit_usage")
    public Optional<CreditUsage> getCreditUsage() {
        return this.creditUsage;
    }

    @JsonProperty(value="credit_used")
    public Optional<Double> getCreditUsed() {
        return this.creditUsed;
    }

    @JsonProperty(value="effective_limit")
    public Optional<Integer> getEffectiveLimit() {
        return this.effectiveLimit;
    }

    @JsonProperty(value="effective_price")
    public Optional<Double> getEffectivePrice() {
        return this.effectivePrice;
    }

    @JsonProperty(value="entitlement_expiration_date")
    public Optional<OffsetDateTime> getEntitlementExpirationDate() {
        return this.entitlementExpirationDate;
    }

    @JsonProperty(value="entitlement_id")
    public String getEntitlementId() {
        return this.entitlementId;
    }

    @JsonProperty(value="entitlement_source")
    public Optional<String> getEntitlementSource() {
        return this.entitlementSource;
    }

    @JsonProperty(value="entitlement_type")
    public String getEntitlementType() {
        return this.entitlementType;
    }

    @JsonProperty(value="feature")
    public Optional<FeatureDetailResponseData> getFeature() {
        return this.feature;
    }

    @JsonProperty(value="has_valid_allocation")
    public Optional<Boolean> getHasValidAllocation() {
        return this.hasValidAllocation;
    }

    @JsonProperty(value="is_unlimited")
    public Optional<Boolean> getIsUnlimited() {
        return this.isUnlimited;
    }

    @JsonProperty(value="metric_reset_at")
    public Optional<OffsetDateTime> getMetricResetAt() {
        return this.metricResetAt;
    }

    @JsonProperty(value="month_reset")
    public Optional<String> getMonthReset() {
        return this.monthReset;
    }

    @JsonProperty(value="monthly_usage_based_price")
    public Optional<BillingPriceView> getMonthlyUsageBasedPrice() {
        return this.monthlyUsageBasedPrice;
    }

    @JsonProperty(value="overuse")
    public Optional<Integer> getOveruse() {
        return this.overuse;
    }

    @JsonProperty(value="percent_used")
    public Optional<Double> getPercentUsed() {
        return this.percentUsed;
    }

    @JsonProperty(value="period")
    public Optional<String> getPeriod() {
        return this.period;
    }

    @JsonProperty(value="plan")
    public Optional<PlanResponseData> getPlan() {
        return this.plan;
    }

    @JsonProperty(value="plan_entitlement")
    public Optional<PlanEntitlementResponseData> getPlanEntitlement() {
        return this.planEntitlement;
    }

    @JsonProperty(value="price_behavior")
    public Optional<String> getPriceBehavior() {
        return this.priceBehavior;
    }

    @JsonProperty(value="soft_limit")
    public Optional<Integer> getSoftLimit() {
        return this.softLimit;
    }

    @JsonProperty(value="usage")
    public Optional<Integer> getUsage() {
        return this.usage;
    }

    @JsonProperty(value="yearly_usage_based_price")
    public Optional<BillingPriceView> getYearlyUsageBasedPrice() {
        return this.yearlyUsageBasedPrice;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FeatureCompanyResponseData && this.equalTo((FeatureCompanyResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FeatureCompanyResponseData other) {
        return this.access == other.access && this.allocation.equals(other.allocation) && this.allocationType.equals(other.allocationType) && this.company.equals(other.company) && this.companyOverride.equals(other.companyOverride) && this.creditConsumptionRate.equals(other.creditConsumptionRate) && this.creditGrantCounts.equals(other.creditGrantCounts) && this.creditGrantDetails.equals(other.creditGrantDetails) && this.creditGrantReason.equals(other.creditGrantReason) && this.creditRemaining.equals(other.creditRemaining) && this.creditTotal.equals(other.creditTotal) && this.creditTypeIcon.equals(other.creditTypeIcon) && this.creditUsage.equals(other.creditUsage) && this.creditUsed.equals(other.creditUsed) && this.effectiveLimit.equals(other.effectiveLimit) && this.effectivePrice.equals(other.effectivePrice) && this.entitlementExpirationDate.equals(other.entitlementExpirationDate) && this.entitlementId.equals(other.entitlementId) && this.entitlementSource.equals(other.entitlementSource) && this.entitlementType.equals(other.entitlementType) && this.feature.equals(other.feature) && this.hasValidAllocation.equals(other.hasValidAllocation) && this.isUnlimited.equals(other.isUnlimited) && this.metricResetAt.equals(other.metricResetAt) && this.monthReset.equals(other.monthReset) && this.monthlyUsageBasedPrice.equals(other.monthlyUsageBasedPrice) && this.overuse.equals(other.overuse) && this.percentUsed.equals(other.percentUsed) && this.period.equals(other.period) && this.plan.equals(other.plan) && this.planEntitlement.equals(other.planEntitlement) && this.priceBehavior.equals(other.priceBehavior) && this.softLimit.equals(other.softLimit) && this.usage.equals(other.usage) && this.yearlyUsageBasedPrice.equals(other.yearlyUsageBasedPrice);
    }

    public int hashCode() {
        return Objects.hash(this.access, this.allocation, this.allocationType, this.company, this.companyOverride, this.creditConsumptionRate, this.creditGrantCounts, this.creditGrantDetails, this.creditGrantReason, this.creditRemaining, this.creditTotal, this.creditTypeIcon, this.creditUsage, this.creditUsed, this.effectiveLimit, this.effectivePrice, this.entitlementExpirationDate, this.entitlementId, this.entitlementSource, this.entitlementType, this.feature, this.hasValidAllocation, this.isUnlimited, this.metricResetAt, this.monthReset, this.monthlyUsageBasedPrice, this.overuse, this.percentUsed, this.period, this.plan, this.planEntitlement, this.priceBehavior, this.softLimit, this.usage, this.yearlyUsageBasedPrice);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccessStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccessStage,
    AllocationTypeStage,
    EntitlementIdStage,
    EntitlementTypeStage,
    _FinalStage {
        private boolean access;
        private FeatureCompanyResponseDataAllocationType allocationType;
        private String entitlementId;
        private String entitlementType;
        private Optional<BillingPriceView> yearlyUsageBasedPrice = Optional.empty();
        private Optional<Integer> usage = Optional.empty();
        private Optional<Integer> softLimit = Optional.empty();
        private Optional<String> priceBehavior = Optional.empty();
        private Optional<PlanEntitlementResponseData> planEntitlement = Optional.empty();
        private Optional<PlanResponseData> plan = Optional.empty();
        private Optional<String> period = Optional.empty();
        private Optional<Double> percentUsed = Optional.empty();
        private Optional<Integer> overuse = Optional.empty();
        private Optional<BillingPriceView> monthlyUsageBasedPrice = Optional.empty();
        private Optional<String> monthReset = Optional.empty();
        private Optional<OffsetDateTime> metricResetAt = Optional.empty();
        private Optional<Boolean> isUnlimited = Optional.empty();
        private Optional<Boolean> hasValidAllocation = Optional.empty();
        private Optional<FeatureDetailResponseData> feature = Optional.empty();
        private Optional<String> entitlementSource = Optional.empty();
        private Optional<OffsetDateTime> entitlementExpirationDate = Optional.empty();
        private Optional<Double> effectivePrice = Optional.empty();
        private Optional<Integer> effectiveLimit = Optional.empty();
        private Optional<Double> creditUsed = Optional.empty();
        private Optional<CreditUsage> creditUsage = Optional.empty();
        private Optional<String> creditTypeIcon = Optional.empty();
        private Optional<Double> creditTotal = Optional.empty();
        private Optional<Double> creditRemaining = Optional.empty();
        private Optional<FeatureCompanyResponseDataCreditGrantReason> creditGrantReason = Optional.empty();
        private Optional<List<CreditGrantDetail>> creditGrantDetails = Optional.empty();
        private Optional<Map<String, Double>> creditGrantCounts = Optional.empty();
        private Optional<Double> creditConsumptionRate = Optional.empty();
        private Optional<CompanyOverrideResponseData> companyOverride = Optional.empty();
        private Optional<CompanyDetailResponseData> company = Optional.empty();
        private Optional<Integer> allocation = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(FeatureCompanyResponseData other) {
            this.access(other.getAccess());
            this.allocation(other.getAllocation());
            this.allocationType(other.getAllocationType());
            this.company(other.getCompany());
            this.companyOverride(other.getCompanyOverride());
            this.creditConsumptionRate(other.getCreditConsumptionRate());
            this.creditGrantCounts(other.getCreditGrantCounts());
            this.creditGrantDetails(other.getCreditGrantDetails());
            this.creditGrantReason(other.getCreditGrantReason());
            this.creditRemaining(other.getCreditRemaining());
            this.creditTotal(other.getCreditTotal());
            this.creditTypeIcon(other.getCreditTypeIcon());
            this.creditUsage(other.getCreditUsage());
            this.creditUsed(other.getCreditUsed());
            this.effectiveLimit(other.getEffectiveLimit());
            this.effectivePrice(other.getEffectivePrice());
            this.entitlementExpirationDate(other.getEntitlementExpirationDate());
            this.entitlementId(other.getEntitlementId());
            this.entitlementSource(other.getEntitlementSource());
            this.entitlementType(other.getEntitlementType());
            this.feature(other.getFeature());
            this.hasValidAllocation(other.getHasValidAllocation());
            this.isUnlimited(other.getIsUnlimited());
            this.metricResetAt(other.getMetricResetAt());
            this.monthReset(other.getMonthReset());
            this.monthlyUsageBasedPrice(other.getMonthlyUsageBasedPrice());
            this.overuse(other.getOveruse());
            this.percentUsed(other.getPercentUsed());
            this.period(other.getPeriod());
            this.plan(other.getPlan());
            this.planEntitlement(other.getPlanEntitlement());
            this.priceBehavior(other.getPriceBehavior());
            this.softLimit(other.getSoftLimit());
            this.usage(other.getUsage());
            this.yearlyUsageBasedPrice(other.getYearlyUsageBasedPrice());
            return this;
        }

        @Override
        @JsonSetter(value="access")
        public AllocationTypeStage access(boolean access) {
            this.access = access;
            return this;
        }

        @Override
        @JsonSetter(value="allocation_type")
        public EntitlementIdStage allocationType(@NotNull FeatureCompanyResponseDataAllocationType allocationType) {
            this.allocationType = Objects.requireNonNull(allocationType, "allocationType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="entitlement_id")
        public EntitlementTypeStage entitlementId(@NotNull String entitlementId) {
            this.entitlementId = Objects.requireNonNull(entitlementId, "entitlementId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="entitlement_type")
        public _FinalStage entitlementType(@NotNull String entitlementType) {
            this.entitlementType = Objects.requireNonNull(entitlementType, "entitlementType must not be null");
            return this;
        }

        @Override
        public _FinalStage yearlyUsageBasedPrice(BillingPriceView yearlyUsageBasedPrice) {
            this.yearlyUsageBasedPrice = Optional.ofNullable(yearlyUsageBasedPrice);
            return this;
        }

        @Override
        @JsonSetter(value="yearly_usage_based_price", nulls=Nulls.SKIP)
        public _FinalStage yearlyUsageBasedPrice(Optional<BillingPriceView> yearlyUsageBasedPrice) {
            this.yearlyUsageBasedPrice = yearlyUsageBasedPrice;
            return this;
        }

        @Override
        public _FinalStage usage(Integer usage) {
            this.usage = Optional.ofNullable(usage);
            return this;
        }

        @Override
        @JsonSetter(value="usage", nulls=Nulls.SKIP)
        public _FinalStage usage(Optional<Integer> usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public _FinalStage softLimit(Integer softLimit) {
            this.softLimit = Optional.ofNullable(softLimit);
            return this;
        }

        @Override
        @JsonSetter(value="soft_limit", nulls=Nulls.SKIP)
        public _FinalStage softLimit(Optional<Integer> softLimit) {
            this.softLimit = softLimit;
            return this;
        }

        @Override
        public _FinalStage priceBehavior(String priceBehavior) {
            this.priceBehavior = Optional.ofNullable(priceBehavior);
            return this;
        }

        @Override
        @JsonSetter(value="price_behavior", nulls=Nulls.SKIP)
        public _FinalStage priceBehavior(Optional<String> priceBehavior) {
            this.priceBehavior = priceBehavior;
            return this;
        }

        @Override
        public _FinalStage planEntitlement(PlanEntitlementResponseData planEntitlement) {
            this.planEntitlement = Optional.ofNullable(planEntitlement);
            return this;
        }

        @Override
        @JsonSetter(value="plan_entitlement", nulls=Nulls.SKIP)
        public _FinalStage planEntitlement(Optional<PlanEntitlementResponseData> planEntitlement) {
            this.planEntitlement = planEntitlement;
            return this;
        }

        @Override
        public _FinalStage plan(PlanResponseData plan) {
            this.plan = Optional.ofNullable(plan);
            return this;
        }

        @Override
        @JsonSetter(value="plan", nulls=Nulls.SKIP)
        public _FinalStage plan(Optional<PlanResponseData> plan) {
            this.plan = plan;
            return this;
        }

        @Override
        public _FinalStage period(String period) {
            this.period = Optional.ofNullable(period);
            return this;
        }

        @Override
        @JsonSetter(value="period", nulls=Nulls.SKIP)
        public _FinalStage period(Optional<String> period) {
            this.period = period;
            return this;
        }

        @Override
        public _FinalStage percentUsed(Double percentUsed) {
            this.percentUsed = Optional.ofNullable(percentUsed);
            return this;
        }

        @Override
        @JsonSetter(value="percent_used", nulls=Nulls.SKIP)
        public _FinalStage percentUsed(Optional<Double> percentUsed) {
            this.percentUsed = percentUsed;
            return this;
        }

        @Override
        public _FinalStage overuse(Integer overuse) {
            this.overuse = Optional.ofNullable(overuse);
            return this;
        }

        @Override
        @JsonSetter(value="overuse", nulls=Nulls.SKIP)
        public _FinalStage overuse(Optional<Integer> overuse) {
            this.overuse = overuse;
            return this;
        }

        @Override
        public _FinalStage monthlyUsageBasedPrice(BillingPriceView monthlyUsageBasedPrice) {
            this.monthlyUsageBasedPrice = Optional.ofNullable(monthlyUsageBasedPrice);
            return this;
        }

        @Override
        @JsonSetter(value="monthly_usage_based_price", nulls=Nulls.SKIP)
        public _FinalStage monthlyUsageBasedPrice(Optional<BillingPriceView> monthlyUsageBasedPrice) {
            this.monthlyUsageBasedPrice = monthlyUsageBasedPrice;
            return this;
        }

        @Override
        public _FinalStage monthReset(String monthReset) {
            this.monthReset = Optional.ofNullable(monthReset);
            return this;
        }

        @Override
        @JsonSetter(value="month_reset", nulls=Nulls.SKIP)
        public _FinalStage monthReset(Optional<String> monthReset) {
            this.monthReset = monthReset;
            return this;
        }

        @Override
        public _FinalStage metricResetAt(OffsetDateTime metricResetAt) {
            this.metricResetAt = Optional.ofNullable(metricResetAt);
            return this;
        }

        @Override
        @JsonSetter(value="metric_reset_at", nulls=Nulls.SKIP)
        public _FinalStage metricResetAt(Optional<OffsetDateTime> metricResetAt) {
            this.metricResetAt = metricResetAt;
            return this;
        }

        @Override
        public _FinalStage isUnlimited(Boolean isUnlimited) {
            this.isUnlimited = Optional.ofNullable(isUnlimited);
            return this;
        }

        @Override
        @JsonSetter(value="is_unlimited", nulls=Nulls.SKIP)
        public _FinalStage isUnlimited(Optional<Boolean> isUnlimited) {
            this.isUnlimited = isUnlimited;
            return this;
        }

        @Override
        public _FinalStage hasValidAllocation(Boolean hasValidAllocation) {
            this.hasValidAllocation = Optional.ofNullable(hasValidAllocation);
            return this;
        }

        @Override
        @JsonSetter(value="has_valid_allocation", nulls=Nulls.SKIP)
        public _FinalStage hasValidAllocation(Optional<Boolean> hasValidAllocation) {
            this.hasValidAllocation = hasValidAllocation;
            return this;
        }

        @Override
        public _FinalStage feature(FeatureDetailResponseData feature) {
            this.feature = Optional.ofNullable(feature);
            return this;
        }

        @Override
        @JsonSetter(value="feature", nulls=Nulls.SKIP)
        public _FinalStage feature(Optional<FeatureDetailResponseData> feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public _FinalStage entitlementSource(String entitlementSource) {
            this.entitlementSource = Optional.ofNullable(entitlementSource);
            return this;
        }

        @Override
        @JsonSetter(value="entitlement_source", nulls=Nulls.SKIP)
        public _FinalStage entitlementSource(Optional<String> entitlementSource) {
            this.entitlementSource = entitlementSource;
            return this;
        }

        @Override
        public _FinalStage entitlementExpirationDate(OffsetDateTime entitlementExpirationDate) {
            this.entitlementExpirationDate = Optional.ofNullable(entitlementExpirationDate);
            return this;
        }

        @Override
        @JsonSetter(value="entitlement_expiration_date", nulls=Nulls.SKIP)
        public _FinalStage entitlementExpirationDate(Optional<OffsetDateTime> entitlementExpirationDate) {
            this.entitlementExpirationDate = entitlementExpirationDate;
            return this;
        }

        @Override
        public _FinalStage effectivePrice(Double effectivePrice) {
            this.effectivePrice = Optional.ofNullable(effectivePrice);
            return this;
        }

        @Override
        @JsonSetter(value="effective_price", nulls=Nulls.SKIP)
        public _FinalStage effectivePrice(Optional<Double> effectivePrice) {
            this.effectivePrice = effectivePrice;
            return this;
        }

        @Override
        public _FinalStage effectiveLimit(Integer effectiveLimit) {
            this.effectiveLimit = Optional.ofNullable(effectiveLimit);
            return this;
        }

        @Override
        @JsonSetter(value="effective_limit", nulls=Nulls.SKIP)
        public _FinalStage effectiveLimit(Optional<Integer> effectiveLimit) {
            this.effectiveLimit = effectiveLimit;
            return this;
        }

        @Override
        public _FinalStage creditUsed(Double creditUsed) {
            this.creditUsed = Optional.ofNullable(creditUsed);
            return this;
        }

        @Override
        @JsonSetter(value="credit_used", nulls=Nulls.SKIP)
        public _FinalStage creditUsed(Optional<Double> creditUsed) {
            this.creditUsed = creditUsed;
            return this;
        }

        @Override
        public _FinalStage creditUsage(CreditUsage creditUsage) {
            this.creditUsage = Optional.ofNullable(creditUsage);
            return this;
        }

        @Override
        @JsonSetter(value="credit_usage", nulls=Nulls.SKIP)
        public _FinalStage creditUsage(Optional<CreditUsage> creditUsage) {
            this.creditUsage = creditUsage;
            return this;
        }

        @Override
        public _FinalStage creditTypeIcon(String creditTypeIcon) {
            this.creditTypeIcon = Optional.ofNullable(creditTypeIcon);
            return this;
        }

        @Override
        @JsonSetter(value="credit_type_icon", nulls=Nulls.SKIP)
        public _FinalStage creditTypeIcon(Optional<String> creditTypeIcon) {
            this.creditTypeIcon = creditTypeIcon;
            return this;
        }

        @Override
        public _FinalStage creditTotal(Double creditTotal) {
            this.creditTotal = Optional.ofNullable(creditTotal);
            return this;
        }

        @Override
        @JsonSetter(value="credit_total", nulls=Nulls.SKIP)
        public _FinalStage creditTotal(Optional<Double> creditTotal) {
            this.creditTotal = creditTotal;
            return this;
        }

        @Override
        public _FinalStage creditRemaining(Double creditRemaining) {
            this.creditRemaining = Optional.ofNullable(creditRemaining);
            return this;
        }

        @Override
        @JsonSetter(value="credit_remaining", nulls=Nulls.SKIP)
        public _FinalStage creditRemaining(Optional<Double> creditRemaining) {
            this.creditRemaining = creditRemaining;
            return this;
        }

        @Override
        public _FinalStage creditGrantReason(FeatureCompanyResponseDataCreditGrantReason creditGrantReason) {
            this.creditGrantReason = Optional.ofNullable(creditGrantReason);
            return this;
        }

        @Override
        @JsonSetter(value="credit_grant_reason", nulls=Nulls.SKIP)
        public _FinalStage creditGrantReason(Optional<FeatureCompanyResponseDataCreditGrantReason> creditGrantReason) {
            this.creditGrantReason = creditGrantReason;
            return this;
        }

        @Override
        public _FinalStage creditGrantDetails(List<CreditGrantDetail> creditGrantDetails) {
            this.creditGrantDetails = Optional.ofNullable(creditGrantDetails);
            return this;
        }

        @Override
        @JsonSetter(value="credit_grant_details", nulls=Nulls.SKIP)
        public _FinalStage creditGrantDetails(Optional<List<CreditGrantDetail>> creditGrantDetails) {
            this.creditGrantDetails = creditGrantDetails;
            return this;
        }

        @Override
        public _FinalStage creditGrantCounts(Map<String, Double> creditGrantCounts) {
            this.creditGrantCounts = Optional.ofNullable(creditGrantCounts);
            return this;
        }

        @Override
        @JsonSetter(value="credit_grant_counts", nulls=Nulls.SKIP)
        public _FinalStage creditGrantCounts(Optional<Map<String, Double>> creditGrantCounts) {
            this.creditGrantCounts = creditGrantCounts;
            return this;
        }

        @Override
        public _FinalStage creditConsumptionRate(Double creditConsumptionRate) {
            this.creditConsumptionRate = Optional.ofNullable(creditConsumptionRate);
            return this;
        }

        @Override
        @JsonSetter(value="credit_consumption_rate", nulls=Nulls.SKIP)
        public _FinalStage creditConsumptionRate(Optional<Double> creditConsumptionRate) {
            this.creditConsumptionRate = creditConsumptionRate;
            return this;
        }

        @Override
        public _FinalStage companyOverride(CompanyOverrideResponseData companyOverride) {
            this.companyOverride = Optional.ofNullable(companyOverride);
            return this;
        }

        @Override
        @JsonSetter(value="company_override", nulls=Nulls.SKIP)
        public _FinalStage companyOverride(Optional<CompanyOverrideResponseData> companyOverride) {
            this.companyOverride = companyOverride;
            return this;
        }

        @Override
        public _FinalStage company(CompanyDetailResponseData company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @Override
        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public _FinalStage company(Optional<CompanyDetailResponseData> company) {
            this.company = company;
            return this;
        }

        @Override
        public _FinalStage allocation(Integer allocation) {
            this.allocation = Optional.ofNullable(allocation);
            return this;
        }

        @Override
        @JsonSetter(value="allocation", nulls=Nulls.SKIP)
        public _FinalStage allocation(Optional<Integer> allocation) {
            this.allocation = allocation;
            return this;
        }

        @Override
        public FeatureCompanyResponseData build() {
            return new FeatureCompanyResponseData(this.access, this.allocation, this.allocationType, this.company, this.companyOverride, this.creditConsumptionRate, this.creditGrantCounts, this.creditGrantDetails, this.creditGrantReason, this.creditRemaining, this.creditTotal, this.creditTypeIcon, this.creditUsage, this.creditUsed, this.effectiveLimit, this.effectivePrice, this.entitlementExpirationDate, this.entitlementId, this.entitlementSource, this.entitlementType, this.feature, this.hasValidAllocation, this.isUnlimited, this.metricResetAt, this.monthReset, this.monthlyUsageBasedPrice, this.overuse, this.percentUsed, this.period, this.plan, this.planEntitlement, this.priceBehavior, this.softLimit, this.usage, this.yearlyUsageBasedPrice, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public FeatureCompanyResponseData build();

        public _FinalStage allocation(Optional<Integer> var1);

        public _FinalStage allocation(Integer var1);

        public _FinalStage company(Optional<CompanyDetailResponseData> var1);

        public _FinalStage company(CompanyDetailResponseData var1);

        public _FinalStage companyOverride(Optional<CompanyOverrideResponseData> var1);

        public _FinalStage companyOverride(CompanyOverrideResponseData var1);

        public _FinalStage creditConsumptionRate(Optional<Double> var1);

        public _FinalStage creditConsumptionRate(Double var1);

        public _FinalStage creditGrantCounts(Optional<Map<String, Double>> var1);

        public _FinalStage creditGrantCounts(Map<String, Double> var1);

        public _FinalStage creditGrantDetails(Optional<List<CreditGrantDetail>> var1);

        public _FinalStage creditGrantDetails(List<CreditGrantDetail> var1);

        public _FinalStage creditGrantReason(Optional<FeatureCompanyResponseDataCreditGrantReason> var1);

        public _FinalStage creditGrantReason(FeatureCompanyResponseDataCreditGrantReason var1);

        public _FinalStage creditRemaining(Optional<Double> var1);

        public _FinalStage creditRemaining(Double var1);

        public _FinalStage creditTotal(Optional<Double> var1);

        public _FinalStage creditTotal(Double var1);

        public _FinalStage creditTypeIcon(Optional<String> var1);

        public _FinalStage creditTypeIcon(String var1);

        public _FinalStage creditUsage(Optional<CreditUsage> var1);

        public _FinalStage creditUsage(CreditUsage var1);

        public _FinalStage creditUsed(Optional<Double> var1);

        public _FinalStage creditUsed(Double var1);

        public _FinalStage effectiveLimit(Optional<Integer> var1);

        public _FinalStage effectiveLimit(Integer var1);

        public _FinalStage effectivePrice(Optional<Double> var1);

        public _FinalStage effectivePrice(Double var1);

        public _FinalStage entitlementExpirationDate(Optional<OffsetDateTime> var1);

        public _FinalStage entitlementExpirationDate(OffsetDateTime var1);

        public _FinalStage entitlementSource(Optional<String> var1);

        public _FinalStage entitlementSource(String var1);

        public _FinalStage feature(Optional<FeatureDetailResponseData> var1);

        public _FinalStage feature(FeatureDetailResponseData var1);

        public _FinalStage hasValidAllocation(Optional<Boolean> var1);

        public _FinalStage hasValidAllocation(Boolean var1);

        public _FinalStage isUnlimited(Optional<Boolean> var1);

        public _FinalStage isUnlimited(Boolean var1);

        public _FinalStage metricResetAt(Optional<OffsetDateTime> var1);

        public _FinalStage metricResetAt(OffsetDateTime var1);

        public _FinalStage monthReset(Optional<String> var1);

        public _FinalStage monthReset(String var1);

        public _FinalStage monthlyUsageBasedPrice(Optional<BillingPriceView> var1);

        public _FinalStage monthlyUsageBasedPrice(BillingPriceView var1);

        public _FinalStage overuse(Optional<Integer> var1);

        public _FinalStage overuse(Integer var1);

        public _FinalStage percentUsed(Optional<Double> var1);

        public _FinalStage percentUsed(Double var1);

        public _FinalStage period(Optional<String> var1);

        public _FinalStage period(String var1);

        public _FinalStage plan(Optional<PlanResponseData> var1);

        public _FinalStage plan(PlanResponseData var1);

        public _FinalStage planEntitlement(Optional<PlanEntitlementResponseData> var1);

        public _FinalStage planEntitlement(PlanEntitlementResponseData var1);

        public _FinalStage priceBehavior(Optional<String> var1);

        public _FinalStage priceBehavior(String var1);

        public _FinalStage softLimit(Optional<Integer> var1);

        public _FinalStage softLimit(Integer var1);

        public _FinalStage usage(Optional<Integer> var1);

        public _FinalStage usage(Integer var1);

        public _FinalStage yearlyUsageBasedPrice(Optional<BillingPriceView> var1);

        public _FinalStage yearlyUsageBasedPrice(BillingPriceView var1);
    }

    public static interface EntitlementTypeStage {
        public _FinalStage entitlementType(@NotNull String var1);
    }

    public static interface EntitlementIdStage {
        public EntitlementTypeStage entitlementId(@NotNull String var1);
    }

    public static interface AllocationTypeStage {
        public EntitlementIdStage allocationType(@NotNull FeatureCompanyResponseDataAllocationType var1);
    }

    public static interface AccessStage {
        public AllocationTypeStage access(boolean var1);

        public Builder from(FeatureCompanyResponseData var1);
    }
}

