/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FeatureLedgerResponseData {
    private final Optional<String> description;
    private final Optional<String> icon;
    private final String id;
    private final String name;
    private final Map<String, Object> additionalProperties;

    private FeatureLedgerResponseData(Optional<String> description, Optional<String> icon, String id, String name, Map<String, Object> additionalProperties) {
        this.description = description;
        this.icon = icon;
        this.id = id;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="icon")
    public Optional<String> getIcon() {
        return this.icon;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FeatureLedgerResponseData && this.equalTo((FeatureLedgerResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FeatureLedgerResponseData other) {
        return this.description.equals(other.description) && this.icon.equals(other.icon) && this.id.equals(other.id) && this.name.equals(other.name);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.icon, this.id, this.name);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    _FinalStage {
        private String id;
        private String name;
        private Optional<String> icon = Optional.empty();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(FeatureLedgerResponseData other) {
            this.description(other.getDescription());
            this.icon(other.getIcon());
            this.id(other.getId());
            this.name(other.getName());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        @Override
        @JsonSetter(value="icon", nulls=Nulls.SKIP)
        public _FinalStage icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public FeatureLedgerResponseData build() {
            return new FeatureLedgerResponseData(this.description, this.icon, this.id, this.name, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public FeatureLedgerResponseData build();

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage icon(Optional<String> var1);

        public _FinalStage icon(String var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(FeatureLedgerResponseData var1);
    }
}

