/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingPriceView;
import com.schematic.api.types.CreditUsageResponseData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FeatureUsageDataResponseData {
    private final Optional<String> creditTypeId;
    private final Optional<CreditUsageResponseData> creditUsage;
    private final String entitlementSource;
    private final String entitlementValueType;
    private final String featureId;
    private final String featureName;
    private final String featureType;
    private final String hardLimit;
    private final boolean hasAccess;
    private final Optional<OffsetDateTime> metricResetAt;
    private final Optional<BillingPriceView> monthlyUsageBasedPrice;
    private final Optional<String> priceBehavior;
    private final String softLimit;
    private final String usage;
    private final Optional<Integer> valueNumeric;
    private final Optional<BillingPriceView> yearlyUsageBasedPrice;
    private final Map<String, Object> additionalProperties;

    private FeatureUsageDataResponseData(Optional<String> creditTypeId, Optional<CreditUsageResponseData> creditUsage, String entitlementSource, String entitlementValueType, String featureId, String featureName, String featureType, String hardLimit, boolean hasAccess, Optional<OffsetDateTime> metricResetAt, Optional<BillingPriceView> monthlyUsageBasedPrice, Optional<String> priceBehavior, String softLimit, String usage, Optional<Integer> valueNumeric, Optional<BillingPriceView> yearlyUsageBasedPrice, Map<String, Object> additionalProperties) {
        this.creditTypeId = creditTypeId;
        this.creditUsage = creditUsage;
        this.entitlementSource = entitlementSource;
        this.entitlementValueType = entitlementValueType;
        this.featureId = featureId;
        this.featureName = featureName;
        this.featureType = featureType;
        this.hardLimit = hardLimit;
        this.hasAccess = hasAccess;
        this.metricResetAt = metricResetAt;
        this.monthlyUsageBasedPrice = monthlyUsageBasedPrice;
        this.priceBehavior = priceBehavior;
        this.softLimit = softLimit;
        this.usage = usage;
        this.valueNumeric = valueNumeric;
        this.yearlyUsageBasedPrice = yearlyUsageBasedPrice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="credit_type_id")
    public Optional<String> getCreditTypeId() {
        return this.creditTypeId;
    }

    @JsonProperty(value="credit_usage")
    public Optional<CreditUsageResponseData> getCreditUsage() {
        return this.creditUsage;
    }

    @JsonProperty(value="entitlement_source")
    public String getEntitlementSource() {
        return this.entitlementSource;
    }

    @JsonProperty(value="entitlement_value_type")
    public String getEntitlementValueType() {
        return this.entitlementValueType;
    }

    @JsonProperty(value="feature_id")
    public String getFeatureId() {
        return this.featureId;
    }

    @JsonProperty(value="feature_name")
    public String getFeatureName() {
        return this.featureName;
    }

    @JsonProperty(value="feature_type")
    public String getFeatureType() {
        return this.featureType;
    }

    @JsonProperty(value="hard_limit")
    public String getHardLimit() {
        return this.hardLimit;
    }

    @JsonProperty(value="has_access")
    public boolean getHasAccess() {
        return this.hasAccess;
    }

    @JsonProperty(value="metric_reset_at")
    public Optional<OffsetDateTime> getMetricResetAt() {
        return this.metricResetAt;
    }

    @JsonProperty(value="monthly_usage_based_price")
    public Optional<BillingPriceView> getMonthlyUsageBasedPrice() {
        return this.monthlyUsageBasedPrice;
    }

    @JsonProperty(value="price_behavior")
    public Optional<String> getPriceBehavior() {
        return this.priceBehavior;
    }

    @JsonProperty(value="soft_limit")
    public String getSoftLimit() {
        return this.softLimit;
    }

    @JsonProperty(value="usage")
    public String getUsage() {
        return this.usage;
    }

    @JsonProperty(value="value_numeric")
    public Optional<Integer> getValueNumeric() {
        return this.valueNumeric;
    }

    @JsonProperty(value="yearly_usage_based_price")
    public Optional<BillingPriceView> getYearlyUsageBasedPrice() {
        return this.yearlyUsageBasedPrice;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FeatureUsageDataResponseData && this.equalTo((FeatureUsageDataResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FeatureUsageDataResponseData other) {
        return this.creditTypeId.equals(other.creditTypeId) && this.creditUsage.equals(other.creditUsage) && this.entitlementSource.equals(other.entitlementSource) && this.entitlementValueType.equals(other.entitlementValueType) && this.featureId.equals(other.featureId) && this.featureName.equals(other.featureName) && this.featureType.equals(other.featureType) && this.hardLimit.equals(other.hardLimit) && this.hasAccess == other.hasAccess && this.metricResetAt.equals(other.metricResetAt) && this.monthlyUsageBasedPrice.equals(other.monthlyUsageBasedPrice) && this.priceBehavior.equals(other.priceBehavior) && this.softLimit.equals(other.softLimit) && this.usage.equals(other.usage) && this.valueNumeric.equals(other.valueNumeric) && this.yearlyUsageBasedPrice.equals(other.yearlyUsageBasedPrice);
    }

    public int hashCode() {
        return Objects.hash(this.creditTypeId, this.creditUsage, this.entitlementSource, this.entitlementValueType, this.featureId, this.featureName, this.featureType, this.hardLimit, this.hasAccess, this.metricResetAt, this.monthlyUsageBasedPrice, this.priceBehavior, this.softLimit, this.usage, this.valueNumeric, this.yearlyUsageBasedPrice);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EntitlementSourceStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EntitlementSourceStage,
    EntitlementValueTypeStage,
    FeatureIdStage,
    FeatureNameStage,
    FeatureTypeStage,
    HardLimitStage,
    HasAccessStage,
    SoftLimitStage,
    UsageStage,
    _FinalStage {
        private String entitlementSource;
        private String entitlementValueType;
        private String featureId;
        private String featureName;
        private String featureType;
        private String hardLimit;
        private boolean hasAccess;
        private String softLimit;
        private String usage;
        private Optional<BillingPriceView> yearlyUsageBasedPrice = Optional.empty();
        private Optional<Integer> valueNumeric = Optional.empty();
        private Optional<String> priceBehavior = Optional.empty();
        private Optional<BillingPriceView> monthlyUsageBasedPrice = Optional.empty();
        private Optional<OffsetDateTime> metricResetAt = Optional.empty();
        private Optional<CreditUsageResponseData> creditUsage = Optional.empty();
        private Optional<String> creditTypeId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(FeatureUsageDataResponseData other) {
            this.creditTypeId(other.getCreditTypeId());
            this.creditUsage(other.getCreditUsage());
            this.entitlementSource(other.getEntitlementSource());
            this.entitlementValueType(other.getEntitlementValueType());
            this.featureId(other.getFeatureId());
            this.featureName(other.getFeatureName());
            this.featureType(other.getFeatureType());
            this.hardLimit(other.getHardLimit());
            this.hasAccess(other.getHasAccess());
            this.metricResetAt(other.getMetricResetAt());
            this.monthlyUsageBasedPrice(other.getMonthlyUsageBasedPrice());
            this.priceBehavior(other.getPriceBehavior());
            this.softLimit(other.getSoftLimit());
            this.usage(other.getUsage());
            this.valueNumeric(other.getValueNumeric());
            this.yearlyUsageBasedPrice(other.getYearlyUsageBasedPrice());
            return this;
        }

        @Override
        @JsonSetter(value="entitlement_source")
        public EntitlementValueTypeStage entitlementSource(@NotNull String entitlementSource) {
            this.entitlementSource = Objects.requireNonNull(entitlementSource, "entitlementSource must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="entitlement_value_type")
        public FeatureIdStage entitlementValueType(@NotNull String entitlementValueType) {
            this.entitlementValueType = Objects.requireNonNull(entitlementValueType, "entitlementValueType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="feature_id")
        public FeatureNameStage featureId(@NotNull String featureId) {
            this.featureId = Objects.requireNonNull(featureId, "featureId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="feature_name")
        public FeatureTypeStage featureName(@NotNull String featureName) {
            this.featureName = Objects.requireNonNull(featureName, "featureName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="feature_type")
        public HardLimitStage featureType(@NotNull String featureType) {
            this.featureType = Objects.requireNonNull(featureType, "featureType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="hard_limit")
        public HasAccessStage hardLimit(@NotNull String hardLimit) {
            this.hardLimit = Objects.requireNonNull(hardLimit, "hardLimit must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="has_access")
        public SoftLimitStage hasAccess(boolean hasAccess) {
            this.hasAccess = hasAccess;
            return this;
        }

        @Override
        @JsonSetter(value="soft_limit")
        public UsageStage softLimit(@NotNull String softLimit) {
            this.softLimit = Objects.requireNonNull(softLimit, "softLimit must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="usage")
        public _FinalStage usage(@NotNull String usage) {
            this.usage = Objects.requireNonNull(usage, "usage must not be null");
            return this;
        }

        @Override
        public _FinalStage yearlyUsageBasedPrice(BillingPriceView yearlyUsageBasedPrice) {
            this.yearlyUsageBasedPrice = Optional.ofNullable(yearlyUsageBasedPrice);
            return this;
        }

        @Override
        @JsonSetter(value="yearly_usage_based_price", nulls=Nulls.SKIP)
        public _FinalStage yearlyUsageBasedPrice(Optional<BillingPriceView> yearlyUsageBasedPrice) {
            this.yearlyUsageBasedPrice = yearlyUsageBasedPrice;
            return this;
        }

        @Override
        public _FinalStage valueNumeric(Integer valueNumeric) {
            this.valueNumeric = Optional.ofNullable(valueNumeric);
            return this;
        }

        @Override
        @JsonSetter(value="value_numeric", nulls=Nulls.SKIP)
        public _FinalStage valueNumeric(Optional<Integer> valueNumeric) {
            this.valueNumeric = valueNumeric;
            return this;
        }

        @Override
        public _FinalStage priceBehavior(String priceBehavior) {
            this.priceBehavior = Optional.ofNullable(priceBehavior);
            return this;
        }

        @Override
        @JsonSetter(value="price_behavior", nulls=Nulls.SKIP)
        public _FinalStage priceBehavior(Optional<String> priceBehavior) {
            this.priceBehavior = priceBehavior;
            return this;
        }

        @Override
        public _FinalStage monthlyUsageBasedPrice(BillingPriceView monthlyUsageBasedPrice) {
            this.monthlyUsageBasedPrice = Optional.ofNullable(monthlyUsageBasedPrice);
            return this;
        }

        @Override
        @JsonSetter(value="monthly_usage_based_price", nulls=Nulls.SKIP)
        public _FinalStage monthlyUsageBasedPrice(Optional<BillingPriceView> monthlyUsageBasedPrice) {
            this.monthlyUsageBasedPrice = monthlyUsageBasedPrice;
            return this;
        }

        @Override
        public _FinalStage metricResetAt(OffsetDateTime metricResetAt) {
            this.metricResetAt = Optional.ofNullable(metricResetAt);
            return this;
        }

        @Override
        @JsonSetter(value="metric_reset_at", nulls=Nulls.SKIP)
        public _FinalStage metricResetAt(Optional<OffsetDateTime> metricResetAt) {
            this.metricResetAt = metricResetAt;
            return this;
        }

        @Override
        public _FinalStage creditUsage(CreditUsageResponseData creditUsage) {
            this.creditUsage = Optional.ofNullable(creditUsage);
            return this;
        }

        @Override
        @JsonSetter(value="credit_usage", nulls=Nulls.SKIP)
        public _FinalStage creditUsage(Optional<CreditUsageResponseData> creditUsage) {
            this.creditUsage = creditUsage;
            return this;
        }

        @Override
        public _FinalStage creditTypeId(String creditTypeId) {
            this.creditTypeId = Optional.ofNullable(creditTypeId);
            return this;
        }

        @Override
        @JsonSetter(value="credit_type_id", nulls=Nulls.SKIP)
        public _FinalStage creditTypeId(Optional<String> creditTypeId) {
            this.creditTypeId = creditTypeId;
            return this;
        }

        @Override
        public FeatureUsageDataResponseData build() {
            return new FeatureUsageDataResponseData(this.creditTypeId, this.creditUsage, this.entitlementSource, this.entitlementValueType, this.featureId, this.featureName, this.featureType, this.hardLimit, this.hasAccess, this.metricResetAt, this.monthlyUsageBasedPrice, this.priceBehavior, this.softLimit, this.usage, this.valueNumeric, this.yearlyUsageBasedPrice, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public FeatureUsageDataResponseData build();

        public _FinalStage creditTypeId(Optional<String> var1);

        public _FinalStage creditTypeId(String var1);

        public _FinalStage creditUsage(Optional<CreditUsageResponseData> var1);

        public _FinalStage creditUsage(CreditUsageResponseData var1);

        public _FinalStage metricResetAt(Optional<OffsetDateTime> var1);

        public _FinalStage metricResetAt(OffsetDateTime var1);

        public _FinalStage monthlyUsageBasedPrice(Optional<BillingPriceView> var1);

        public _FinalStage monthlyUsageBasedPrice(BillingPriceView var1);

        public _FinalStage priceBehavior(Optional<String> var1);

        public _FinalStage priceBehavior(String var1);

        public _FinalStage valueNumeric(Optional<Integer> var1);

        public _FinalStage valueNumeric(Integer var1);

        public _FinalStage yearlyUsageBasedPrice(Optional<BillingPriceView> var1);

        public _FinalStage yearlyUsageBasedPrice(BillingPriceView var1);
    }

    public static interface UsageStage {
        public _FinalStage usage(@NotNull String var1);
    }

    public static interface SoftLimitStage {
        public UsageStage softLimit(@NotNull String var1);
    }

    public static interface HasAccessStage {
        public SoftLimitStage hasAccess(boolean var1);
    }

    public static interface HardLimitStage {
        public HasAccessStage hardLimit(@NotNull String var1);
    }

    public static interface FeatureTypeStage {
        public HardLimitStage featureType(@NotNull String var1);
    }

    public static interface FeatureNameStage {
        public FeatureTypeStage featureName(@NotNull String var1);
    }

    public static interface FeatureIdStage {
        public FeatureNameStage featureId(@NotNull String var1);
    }

    public static interface EntitlementValueTypeStage {
        public FeatureIdStage entitlementValueType(@NotNull String var1);
    }

    public static interface EntitlementSourceStage {
        public EntitlementValueTypeStage entitlementSource(@NotNull String var1);

        public Builder from(FeatureUsageDataResponseData var1);
    }
}

