/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.FeatureResponseData;
import com.schematic.api.types.RuleDetailResponseData;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FlagDetailResponseData {
    private final OffsetDateTime createdAt;
    private final boolean defaultValue;
    private final String description;
    private final Optional<FeatureResponseData> feature;
    private final Optional<String> featureId;
    private final String flagType;
    private final String id;
    private final String key;
    private final Optional<OffsetDateTime> lastCheckedAt;
    private final Optional<String> maintainerId;
    private final String name;
    private final List<RuleDetailResponseData> rules;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private FlagDetailResponseData(OffsetDateTime createdAt, boolean defaultValue, String description, Optional<FeatureResponseData> feature, Optional<String> featureId, String flagType, String id, String key, Optional<OffsetDateTime> lastCheckedAt, Optional<String> maintainerId, String name, List<RuleDetailResponseData> rules, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.defaultValue = defaultValue;
        this.description = description;
        this.feature = feature;
        this.featureId = featureId;
        this.flagType = flagType;
        this.id = id;
        this.key = key;
        this.lastCheckedAt = lastCheckedAt;
        this.maintainerId = maintainerId;
        this.name = name;
        this.rules = rules;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="default_value")
    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="feature")
    public Optional<FeatureResponseData> getFeature() {
        return this.feature;
    }

    @JsonProperty(value="feature_id")
    public Optional<String> getFeatureId() {
        return this.featureId;
    }

    @JsonProperty(value="flag_type")
    public String getFlagType() {
        return this.flagType;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="last_checked_at")
    public Optional<OffsetDateTime> getLastCheckedAt() {
        return this.lastCheckedAt;
    }

    @JsonProperty(value="maintainer_id")
    public Optional<String> getMaintainerId() {
        return this.maintainerId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="rules")
    public List<RuleDetailResponseData> getRules() {
        return this.rules;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FlagDetailResponseData && this.equalTo((FlagDetailResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FlagDetailResponseData other) {
        return this.createdAt.equals(other.createdAt) && this.defaultValue == other.defaultValue && this.description.equals(other.description) && this.feature.equals(other.feature) && this.featureId.equals(other.featureId) && this.flagType.equals(other.flagType) && this.id.equals(other.id) && this.key.equals(other.key) && this.lastCheckedAt.equals(other.lastCheckedAt) && this.maintainerId.equals(other.maintainerId) && this.name.equals(other.name) && this.rules.equals(other.rules) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.defaultValue, this.description, this.feature, this.featureId, this.flagType, this.id, this.key, this.lastCheckedAt, this.maintainerId, this.name, this.rules, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    DefaultValueStage,
    DescriptionStage,
    FlagTypeStage,
    IdStage,
    KeyStage,
    NameStage,
    UpdatedAtStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private boolean defaultValue;
        private String description;
        private String flagType;
        private String id;
        private String key;
        private String name;
        private OffsetDateTime updatedAt;
        private List<RuleDetailResponseData> rules = new ArrayList<RuleDetailResponseData>();
        private Optional<String> maintainerId = Optional.empty();
        private Optional<OffsetDateTime> lastCheckedAt = Optional.empty();
        private Optional<String> featureId = Optional.empty();
        private Optional<FeatureResponseData> feature = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(FlagDetailResponseData other) {
            this.createdAt(other.getCreatedAt());
            this.defaultValue(other.getDefaultValue());
            this.description(other.getDescription());
            this.feature(other.getFeature());
            this.featureId(other.getFeatureId());
            this.flagType(other.getFlagType());
            this.id(other.getId());
            this.key(other.getKey());
            this.lastCheckedAt(other.getLastCheckedAt());
            this.maintainerId(other.getMaintainerId());
            this.name(other.getName());
            this.rules(other.getRules());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public DefaultValueStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="default_value")
        public DescriptionStage defaultValue(boolean defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public FlagTypeStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="flag_type")
        public IdStage flagType(@NotNull String flagType) {
            this.flagType = Objects.requireNonNull(flagType, "flagType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public KeyStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="key")
        public NameStage key(@NotNull String key) {
            this.key = Objects.requireNonNull(key, "key must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public UpdatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllRules(List<RuleDetailResponseData> rules) {
            if (rules != null) {
                this.rules.addAll(rules);
            }
            return this;
        }

        @Override
        public _FinalStage addRules(RuleDetailResponseData rules) {
            this.rules.add(rules);
            return this;
        }

        @Override
        @JsonSetter(value="rules", nulls=Nulls.SKIP)
        public _FinalStage rules(List<RuleDetailResponseData> rules) {
            this.rules.clear();
            if (rules != null) {
                this.rules.addAll(rules);
            }
            return this;
        }

        @Override
        public _FinalStage maintainerId(String maintainerId) {
            this.maintainerId = Optional.ofNullable(maintainerId);
            return this;
        }

        @Override
        @JsonSetter(value="maintainer_id", nulls=Nulls.SKIP)
        public _FinalStage maintainerId(Optional<String> maintainerId) {
            this.maintainerId = maintainerId;
            return this;
        }

        @Override
        public _FinalStage lastCheckedAt(OffsetDateTime lastCheckedAt) {
            this.lastCheckedAt = Optional.ofNullable(lastCheckedAt);
            return this;
        }

        @Override
        @JsonSetter(value="last_checked_at", nulls=Nulls.SKIP)
        public _FinalStage lastCheckedAt(Optional<OffsetDateTime> lastCheckedAt) {
            this.lastCheckedAt = lastCheckedAt;
            return this;
        }

        @Override
        public _FinalStage featureId(String featureId) {
            this.featureId = Optional.ofNullable(featureId);
            return this;
        }

        @Override
        @JsonSetter(value="feature_id", nulls=Nulls.SKIP)
        public _FinalStage featureId(Optional<String> featureId) {
            this.featureId = featureId;
            return this;
        }

        @Override
        public _FinalStage feature(FeatureResponseData feature) {
            this.feature = Optional.ofNullable(feature);
            return this;
        }

        @Override
        @JsonSetter(value="feature", nulls=Nulls.SKIP)
        public _FinalStage feature(Optional<FeatureResponseData> feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public FlagDetailResponseData build() {
            return new FlagDetailResponseData(this.createdAt, this.defaultValue, this.description, this.feature, this.featureId, this.flagType, this.id, this.key, this.lastCheckedAt, this.maintainerId, this.name, this.rules, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public FlagDetailResponseData build();

        public _FinalStage feature(Optional<FeatureResponseData> var1);

        public _FinalStage feature(FeatureResponseData var1);

        public _FinalStage featureId(Optional<String> var1);

        public _FinalStage featureId(String var1);

        public _FinalStage lastCheckedAt(Optional<OffsetDateTime> var1);

        public _FinalStage lastCheckedAt(OffsetDateTime var1);

        public _FinalStage maintainerId(Optional<String> var1);

        public _FinalStage maintainerId(String var1);

        public _FinalStage rules(List<RuleDetailResponseData> var1);

        public _FinalStage addRules(RuleDetailResponseData var1);

        public _FinalStage addAllRules(List<RuleDetailResponseData> var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface NameStage {
        public UpdatedAtStage name(@NotNull String var1);
    }

    public static interface KeyStage {
        public NameStage key(@NotNull String var1);
    }

    public static interface IdStage {
        public KeyStage id(@NotNull String var1);
    }

    public static interface FlagTypeStage {
        public IdStage flagType(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public FlagTypeStage description(@NotNull String var1);
    }

    public static interface DefaultValueStage {
        public DescriptionStage defaultValue(boolean var1);
    }

    public static interface CreatedAtStage {
        public DefaultValueStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(FlagDetailResponseData var1);
    }
}

