/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class KeysRequestBody {
    private final Map<String, String> keys;
    private final Map<String, Object> additionalProperties;

    private KeysRequestBody(Map<String, String> keys, Map<String, Object> additionalProperties) {
        this.keys = keys;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="keys")
    public Map<String, String> getKeys() {
        return this.keys;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof KeysRequestBody && this.equalTo((KeysRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(KeysRequestBody other) {
        return this.keys.equals(other.keys);
    }

    public int hashCode() {
        return Objects.hash(this.keys);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Map<String, String> keys = new LinkedHashMap<String, String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(KeysRequestBody other) {
            this.keys(other.getKeys());
            return this;
        }

        @JsonSetter(value="keys", nulls=Nulls.SKIP)
        public Builder keys(Map<String, String> keys) {
            this.keys.clear();
            if (keys != null) {
                this.keys.putAll(keys);
            }
            return this;
        }

        public Builder putAllKeys(Map<String, String> keys) {
            if (keys != null) {
                this.keys.putAll(keys);
            }
            return this;
        }

        public Builder keys(String key, String value) {
            this.keys.put(key, value);
            return this;
        }

        public KeysRequestBody build() {
            return new KeysRequestBody(this.keys, this.additionalProperties);
        }
    }
}

