/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.PlanSelection;
import com.schematic.api.types.UpdateCreditBundleRequestBody;
import com.schematic.api.types.UpdatePayInAdvanceRequestBody;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ManagePlanRequest {
    private final List<PlanSelection> addOnSelections;
    private final Optional<String> basePlanId;
    private final Optional<String> basePlanPriceId;
    private final String companyId;
    private final Optional<String> couponExternalId;
    private final List<UpdateCreditBundleRequestBody> creditBundles;
    private final List<UpdatePayInAdvanceRequestBody> payInAdvanceEntitlements;
    private final Optional<String> paymentMethodExternalId;
    private final Optional<String> promoCode;
    private final Map<String, Object> additionalProperties;

    private ManagePlanRequest(List<PlanSelection> addOnSelections, Optional<String> basePlanId, Optional<String> basePlanPriceId, String companyId, Optional<String> couponExternalId, List<UpdateCreditBundleRequestBody> creditBundles, List<UpdatePayInAdvanceRequestBody> payInAdvanceEntitlements, Optional<String> paymentMethodExternalId, Optional<String> promoCode, Map<String, Object> additionalProperties) {
        this.addOnSelections = addOnSelections;
        this.basePlanId = basePlanId;
        this.basePlanPriceId = basePlanPriceId;
        this.companyId = companyId;
        this.couponExternalId = couponExternalId;
        this.creditBundles = creditBundles;
        this.payInAdvanceEntitlements = payInAdvanceEntitlements;
        this.paymentMethodExternalId = paymentMethodExternalId;
        this.promoCode = promoCode;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="add_on_selections")
    public List<PlanSelection> getAddOnSelections() {
        return this.addOnSelections;
    }

    @JsonProperty(value="base_plan_id")
    public Optional<String> getBasePlanId() {
        return this.basePlanId;
    }

    @JsonProperty(value="base_plan_price_id")
    public Optional<String> getBasePlanPriceId() {
        return this.basePlanPriceId;
    }

    @JsonProperty(value="company_id")
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="coupon_external_id")
    public Optional<String> getCouponExternalId() {
        return this.couponExternalId;
    }

    @JsonProperty(value="credit_bundles")
    public List<UpdateCreditBundleRequestBody> getCreditBundles() {
        return this.creditBundles;
    }

    @JsonProperty(value="pay_in_advance_entitlements")
    public List<UpdatePayInAdvanceRequestBody> getPayInAdvanceEntitlements() {
        return this.payInAdvanceEntitlements;
    }

    @JsonProperty(value="payment_method_external_id")
    public Optional<String> getPaymentMethodExternalId() {
        return this.paymentMethodExternalId;
    }

    @JsonProperty(value="promo_code")
    public Optional<String> getPromoCode() {
        return this.promoCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ManagePlanRequest && this.equalTo((ManagePlanRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ManagePlanRequest other) {
        return this.addOnSelections.equals(other.addOnSelections) && this.basePlanId.equals(other.basePlanId) && this.basePlanPriceId.equals(other.basePlanPriceId) && this.companyId.equals(other.companyId) && this.couponExternalId.equals(other.couponExternalId) && this.creditBundles.equals(other.creditBundles) && this.payInAdvanceEntitlements.equals(other.payInAdvanceEntitlements) && this.paymentMethodExternalId.equals(other.paymentMethodExternalId) && this.promoCode.equals(other.promoCode);
    }

    public int hashCode() {
        return Objects.hash(this.addOnSelections, this.basePlanId, this.basePlanPriceId, this.companyId, this.couponExternalId, this.creditBundles, this.payInAdvanceEntitlements, this.paymentMethodExternalId, this.promoCode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CompanyIdStage,
    _FinalStage {
        private String companyId;
        private Optional<String> promoCode = Optional.empty();
        private Optional<String> paymentMethodExternalId = Optional.empty();
        private List<UpdatePayInAdvanceRequestBody> payInAdvanceEntitlements = new ArrayList<UpdatePayInAdvanceRequestBody>();
        private List<UpdateCreditBundleRequestBody> creditBundles = new ArrayList<UpdateCreditBundleRequestBody>();
        private Optional<String> couponExternalId = Optional.empty();
        private Optional<String> basePlanPriceId = Optional.empty();
        private Optional<String> basePlanId = Optional.empty();
        private List<PlanSelection> addOnSelections = new ArrayList<PlanSelection>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ManagePlanRequest other) {
            this.addOnSelections(other.getAddOnSelections());
            this.basePlanId(other.getBasePlanId());
            this.basePlanPriceId(other.getBasePlanPriceId());
            this.companyId(other.getCompanyId());
            this.couponExternalId(other.getCouponExternalId());
            this.creditBundles(other.getCreditBundles());
            this.payInAdvanceEntitlements(other.getPayInAdvanceEntitlements());
            this.paymentMethodExternalId(other.getPaymentMethodExternalId());
            this.promoCode(other.getPromoCode());
            return this;
        }

        @Override
        @JsonSetter(value="company_id")
        public _FinalStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        public _FinalStage promoCode(String promoCode) {
            this.promoCode = Optional.ofNullable(promoCode);
            return this;
        }

        @Override
        @JsonSetter(value="promo_code", nulls=Nulls.SKIP)
        public _FinalStage promoCode(Optional<String> promoCode) {
            this.promoCode = promoCode;
            return this;
        }

        @Override
        public _FinalStage paymentMethodExternalId(String paymentMethodExternalId) {
            this.paymentMethodExternalId = Optional.ofNullable(paymentMethodExternalId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_method_external_id", nulls=Nulls.SKIP)
        public _FinalStage paymentMethodExternalId(Optional<String> paymentMethodExternalId) {
            this.paymentMethodExternalId = paymentMethodExternalId;
            return this;
        }

        @Override
        public _FinalStage addAllPayInAdvanceEntitlements(List<UpdatePayInAdvanceRequestBody> payInAdvanceEntitlements) {
            if (payInAdvanceEntitlements != null) {
                this.payInAdvanceEntitlements.addAll(payInAdvanceEntitlements);
            }
            return this;
        }

        @Override
        public _FinalStage addPayInAdvanceEntitlements(UpdatePayInAdvanceRequestBody payInAdvanceEntitlements) {
            this.payInAdvanceEntitlements.add(payInAdvanceEntitlements);
            return this;
        }

        @Override
        @JsonSetter(value="pay_in_advance_entitlements", nulls=Nulls.SKIP)
        public _FinalStage payInAdvanceEntitlements(List<UpdatePayInAdvanceRequestBody> payInAdvanceEntitlements) {
            this.payInAdvanceEntitlements.clear();
            if (payInAdvanceEntitlements != null) {
                this.payInAdvanceEntitlements.addAll(payInAdvanceEntitlements);
            }
            return this;
        }

        @Override
        public _FinalStage addAllCreditBundles(List<UpdateCreditBundleRequestBody> creditBundles) {
            if (creditBundles != null) {
                this.creditBundles.addAll(creditBundles);
            }
            return this;
        }

        @Override
        public _FinalStage addCreditBundles(UpdateCreditBundleRequestBody creditBundles) {
            this.creditBundles.add(creditBundles);
            return this;
        }

        @Override
        @JsonSetter(value="credit_bundles", nulls=Nulls.SKIP)
        public _FinalStage creditBundles(List<UpdateCreditBundleRequestBody> creditBundles) {
            this.creditBundles.clear();
            if (creditBundles != null) {
                this.creditBundles.addAll(creditBundles);
            }
            return this;
        }

        @Override
        public _FinalStage couponExternalId(String couponExternalId) {
            this.couponExternalId = Optional.ofNullable(couponExternalId);
            return this;
        }

        @Override
        @JsonSetter(value="coupon_external_id", nulls=Nulls.SKIP)
        public _FinalStage couponExternalId(Optional<String> couponExternalId) {
            this.couponExternalId = couponExternalId;
            return this;
        }

        @Override
        public _FinalStage basePlanPriceId(String basePlanPriceId) {
            this.basePlanPriceId = Optional.ofNullable(basePlanPriceId);
            return this;
        }

        @Override
        @JsonSetter(value="base_plan_price_id", nulls=Nulls.SKIP)
        public _FinalStage basePlanPriceId(Optional<String> basePlanPriceId) {
            this.basePlanPriceId = basePlanPriceId;
            return this;
        }

        @Override
        public _FinalStage basePlanId(String basePlanId) {
            this.basePlanId = Optional.ofNullable(basePlanId);
            return this;
        }

        @Override
        @JsonSetter(value="base_plan_id", nulls=Nulls.SKIP)
        public _FinalStage basePlanId(Optional<String> basePlanId) {
            this.basePlanId = basePlanId;
            return this;
        }

        @Override
        public _FinalStage addAllAddOnSelections(List<PlanSelection> addOnSelections) {
            if (addOnSelections != null) {
                this.addOnSelections.addAll(addOnSelections);
            }
            return this;
        }

        @Override
        public _FinalStage addAddOnSelections(PlanSelection addOnSelections) {
            this.addOnSelections.add(addOnSelections);
            return this;
        }

        @Override
        @JsonSetter(value="add_on_selections", nulls=Nulls.SKIP)
        public _FinalStage addOnSelections(List<PlanSelection> addOnSelections) {
            this.addOnSelections.clear();
            if (addOnSelections != null) {
                this.addOnSelections.addAll(addOnSelections);
            }
            return this;
        }

        @Override
        public ManagePlanRequest build() {
            return new ManagePlanRequest(this.addOnSelections, this.basePlanId, this.basePlanPriceId, this.companyId, this.couponExternalId, this.creditBundles, this.payInAdvanceEntitlements, this.paymentMethodExternalId, this.promoCode, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ManagePlanRequest build();

        public _FinalStage addOnSelections(List<PlanSelection> var1);

        public _FinalStage addAddOnSelections(PlanSelection var1);

        public _FinalStage addAllAddOnSelections(List<PlanSelection> var1);

        public _FinalStage basePlanId(Optional<String> var1);

        public _FinalStage basePlanId(String var1);

        public _FinalStage basePlanPriceId(Optional<String> var1);

        public _FinalStage basePlanPriceId(String var1);

        public _FinalStage couponExternalId(Optional<String> var1);

        public _FinalStage couponExternalId(String var1);

        public _FinalStage creditBundles(List<UpdateCreditBundleRequestBody> var1);

        public _FinalStage addCreditBundles(UpdateCreditBundleRequestBody var1);

        public _FinalStage addAllCreditBundles(List<UpdateCreditBundleRequestBody> var1);

        public _FinalStage payInAdvanceEntitlements(List<UpdatePayInAdvanceRequestBody> var1);

        public _FinalStage addPayInAdvanceEntitlements(UpdatePayInAdvanceRequestBody var1);

        public _FinalStage addAllPayInAdvanceEntitlements(List<UpdatePayInAdvanceRequestBody> var1);

        public _FinalStage paymentMethodExternalId(Optional<String> var1);

        public _FinalStage paymentMethodExternalId(String var1);

        public _FinalStage promoCode(Optional<String> var1);

        public _FinalStage promoCode(String var1);
    }

    public static interface CompanyIdStage {
        public _FinalStage companyId(@NotNull String var1);

        public Builder from(ManagePlanRequest var1);
    }
}

