/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MeterRequestBody {
    private final String displayName;
    private final String eventName;
    private final String eventPayloadKey;
    private final Map<String, Object> additionalProperties;

    private MeterRequestBody(String displayName, String eventName, String eventPayloadKey, Map<String, Object> additionalProperties) {
        this.displayName = displayName;
        this.eventName = eventName;
        this.eventPayloadKey = eventPayloadKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="event_name")
    public String getEventName() {
        return this.eventName;
    }

    @JsonProperty(value="event_payload_key")
    public String getEventPayloadKey() {
        return this.eventPayloadKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MeterRequestBody && this.equalTo((MeterRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MeterRequestBody other) {
        return this.displayName.equals(other.displayName) && this.eventName.equals(other.eventName) && this.eventPayloadKey.equals(other.eventPayloadKey);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.eventName, this.eventPayloadKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DisplayNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DisplayNameStage,
    EventNameStage,
    EventPayloadKeyStage,
    _FinalStage {
        private String displayName;
        private String eventName;
        private String eventPayloadKey;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(MeterRequestBody other) {
            this.displayName(other.getDisplayName());
            this.eventName(other.getEventName());
            this.eventPayloadKey(other.getEventPayloadKey());
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public EventNameStage displayName(@NotNull String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="event_name")
        public EventPayloadKeyStage eventName(@NotNull String eventName) {
            this.eventName = Objects.requireNonNull(eventName, "eventName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="event_payload_key")
        public _FinalStage eventPayloadKey(@NotNull String eventPayloadKey) {
            this.eventPayloadKey = Objects.requireNonNull(eventPayloadKey, "eventPayloadKey must not be null");
            return this;
        }

        @Override
        public MeterRequestBody build() {
            return new MeterRequestBody(this.displayName, this.eventName, this.eventPayloadKey, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public MeterRequestBody build();
    }

    public static interface EventPayloadKeyStage {
        public _FinalStage eventPayloadKey(@NotNull String var1);
    }

    public static interface EventNameStage {
        public EventPayloadKeyStage eventName(@NotNull String var1);
    }

    public static interface DisplayNameStage {
        public EventNameStage displayName(@NotNull String var1);

        public Builder from(MeterRequestBody var1);
    }
}

