/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PaymentMethodRequestBody {
    private final Optional<String> accountLast4;
    private final Optional<String> accountName;
    private final Optional<String> bankName;
    private final Optional<String> billingEmail;
    private final Optional<String> billingName;
    private final Optional<String> cardBrand;
    private final Optional<Integer> cardExpMonth;
    private final Optional<Integer> cardExpYear;
    private final Optional<String> cardLast4;
    private final String customerExternalId;
    private final String paymentMethodType;
    private final Map<String, Object> additionalProperties;

    private PaymentMethodRequestBody(Optional<String> accountLast4, Optional<String> accountName, Optional<String> bankName, Optional<String> billingEmail, Optional<String> billingName, Optional<String> cardBrand, Optional<Integer> cardExpMonth, Optional<Integer> cardExpYear, Optional<String> cardLast4, String customerExternalId, String paymentMethodType, Map<String, Object> additionalProperties) {
        this.accountLast4 = accountLast4;
        this.accountName = accountName;
        this.bankName = bankName;
        this.billingEmail = billingEmail;
        this.billingName = billingName;
        this.cardBrand = cardBrand;
        this.cardExpMonth = cardExpMonth;
        this.cardExpYear = cardExpYear;
        this.cardLast4 = cardLast4;
        this.customerExternalId = customerExternalId;
        this.paymentMethodType = paymentMethodType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="account_last4")
    public Optional<String> getAccountLast4() {
        return this.accountLast4;
    }

    @JsonProperty(value="account_name")
    public Optional<String> getAccountName() {
        return this.accountName;
    }

    @JsonProperty(value="bank_name")
    public Optional<String> getBankName() {
        return this.bankName;
    }

    @JsonProperty(value="billing_email")
    public Optional<String> getBillingEmail() {
        return this.billingEmail;
    }

    @JsonProperty(value="billing_name")
    public Optional<String> getBillingName() {
        return this.billingName;
    }

    @JsonProperty(value="card_brand")
    public Optional<String> getCardBrand() {
        return this.cardBrand;
    }

    @JsonProperty(value="card_exp_month")
    public Optional<Integer> getCardExpMonth() {
        return this.cardExpMonth;
    }

    @JsonProperty(value="card_exp_year")
    public Optional<Integer> getCardExpYear() {
        return this.cardExpYear;
    }

    @JsonProperty(value="card_last4")
    public Optional<String> getCardLast4() {
        return this.cardLast4;
    }

    @JsonProperty(value="customer_external_id")
    public String getCustomerExternalId() {
        return this.customerExternalId;
    }

    @JsonProperty(value="payment_method_type")
    public String getPaymentMethodType() {
        return this.paymentMethodType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PaymentMethodRequestBody && this.equalTo((PaymentMethodRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaymentMethodRequestBody other) {
        return this.accountLast4.equals(other.accountLast4) && this.accountName.equals(other.accountName) && this.bankName.equals(other.bankName) && this.billingEmail.equals(other.billingEmail) && this.billingName.equals(other.billingName) && this.cardBrand.equals(other.cardBrand) && this.cardExpMonth.equals(other.cardExpMonth) && this.cardExpYear.equals(other.cardExpYear) && this.cardLast4.equals(other.cardLast4) && this.customerExternalId.equals(other.customerExternalId) && this.paymentMethodType.equals(other.paymentMethodType);
    }

    public int hashCode() {
        return Objects.hash(this.accountLast4, this.accountName, this.bankName, this.billingEmail, this.billingName, this.cardBrand, this.cardExpMonth, this.cardExpYear, this.cardLast4, this.customerExternalId, this.paymentMethodType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomerExternalIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CustomerExternalIdStage,
    PaymentMethodTypeStage,
    _FinalStage {
        private String customerExternalId;
        private String paymentMethodType;
        private Optional<String> cardLast4 = Optional.empty();
        private Optional<Integer> cardExpYear = Optional.empty();
        private Optional<Integer> cardExpMonth = Optional.empty();
        private Optional<String> cardBrand = Optional.empty();
        private Optional<String> billingName = Optional.empty();
        private Optional<String> billingEmail = Optional.empty();
        private Optional<String> bankName = Optional.empty();
        private Optional<String> accountName = Optional.empty();
        private Optional<String> accountLast4 = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PaymentMethodRequestBody other) {
            this.accountLast4(other.getAccountLast4());
            this.accountName(other.getAccountName());
            this.bankName(other.getBankName());
            this.billingEmail(other.getBillingEmail());
            this.billingName(other.getBillingName());
            this.cardBrand(other.getCardBrand());
            this.cardExpMonth(other.getCardExpMonth());
            this.cardExpYear(other.getCardExpYear());
            this.cardLast4(other.getCardLast4());
            this.customerExternalId(other.getCustomerExternalId());
            this.paymentMethodType(other.getPaymentMethodType());
            return this;
        }

        @Override
        @JsonSetter(value="customer_external_id")
        public PaymentMethodTypeStage customerExternalId(@NotNull String customerExternalId) {
            this.customerExternalId = Objects.requireNonNull(customerExternalId, "customerExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="payment_method_type")
        public _FinalStage paymentMethodType(@NotNull String paymentMethodType) {
            this.paymentMethodType = Objects.requireNonNull(paymentMethodType, "paymentMethodType must not be null");
            return this;
        }

        @Override
        public _FinalStage cardLast4(String cardLast4) {
            this.cardLast4 = Optional.ofNullable(cardLast4);
            return this;
        }

        @Override
        @JsonSetter(value="card_last4", nulls=Nulls.SKIP)
        public _FinalStage cardLast4(Optional<String> cardLast4) {
            this.cardLast4 = cardLast4;
            return this;
        }

        @Override
        public _FinalStage cardExpYear(Integer cardExpYear) {
            this.cardExpYear = Optional.ofNullable(cardExpYear);
            return this;
        }

        @Override
        @JsonSetter(value="card_exp_year", nulls=Nulls.SKIP)
        public _FinalStage cardExpYear(Optional<Integer> cardExpYear) {
            this.cardExpYear = cardExpYear;
            return this;
        }

        @Override
        public _FinalStage cardExpMonth(Integer cardExpMonth) {
            this.cardExpMonth = Optional.ofNullable(cardExpMonth);
            return this;
        }

        @Override
        @JsonSetter(value="card_exp_month", nulls=Nulls.SKIP)
        public _FinalStage cardExpMonth(Optional<Integer> cardExpMonth) {
            this.cardExpMonth = cardExpMonth;
            return this;
        }

        @Override
        public _FinalStage cardBrand(String cardBrand) {
            this.cardBrand = Optional.ofNullable(cardBrand);
            return this;
        }

        @Override
        @JsonSetter(value="card_brand", nulls=Nulls.SKIP)
        public _FinalStage cardBrand(Optional<String> cardBrand) {
            this.cardBrand = cardBrand;
            return this;
        }

        @Override
        public _FinalStage billingName(String billingName) {
            this.billingName = Optional.ofNullable(billingName);
            return this;
        }

        @Override
        @JsonSetter(value="billing_name", nulls=Nulls.SKIP)
        public _FinalStage billingName(Optional<String> billingName) {
            this.billingName = billingName;
            return this;
        }

        @Override
        public _FinalStage billingEmail(String billingEmail) {
            this.billingEmail = Optional.ofNullable(billingEmail);
            return this;
        }

        @Override
        @JsonSetter(value="billing_email", nulls=Nulls.SKIP)
        public _FinalStage billingEmail(Optional<String> billingEmail) {
            this.billingEmail = billingEmail;
            return this;
        }

        @Override
        public _FinalStage bankName(String bankName) {
            this.bankName = Optional.ofNullable(bankName);
            return this;
        }

        @Override
        @JsonSetter(value="bank_name", nulls=Nulls.SKIP)
        public _FinalStage bankName(Optional<String> bankName) {
            this.bankName = bankName;
            return this;
        }

        @Override
        public _FinalStage accountName(String accountName) {
            this.accountName = Optional.ofNullable(accountName);
            return this;
        }

        @Override
        @JsonSetter(value="account_name", nulls=Nulls.SKIP)
        public _FinalStage accountName(Optional<String> accountName) {
            this.accountName = accountName;
            return this;
        }

        @Override
        public _FinalStage accountLast4(String accountLast4) {
            this.accountLast4 = Optional.ofNullable(accountLast4);
            return this;
        }

        @Override
        @JsonSetter(value="account_last4", nulls=Nulls.SKIP)
        public _FinalStage accountLast4(Optional<String> accountLast4) {
            this.accountLast4 = accountLast4;
            return this;
        }

        @Override
        public PaymentMethodRequestBody build() {
            return new PaymentMethodRequestBody(this.accountLast4, this.accountName, this.bankName, this.billingEmail, this.billingName, this.cardBrand, this.cardExpMonth, this.cardExpYear, this.cardLast4, this.customerExternalId, this.paymentMethodType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PaymentMethodRequestBody build();

        public _FinalStage accountLast4(Optional<String> var1);

        public _FinalStage accountLast4(String var1);

        public _FinalStage accountName(Optional<String> var1);

        public _FinalStage accountName(String var1);

        public _FinalStage bankName(Optional<String> var1);

        public _FinalStage bankName(String var1);

        public _FinalStage billingEmail(Optional<String> var1);

        public _FinalStage billingEmail(String var1);

        public _FinalStage billingName(Optional<String> var1);

        public _FinalStage billingName(String var1);

        public _FinalStage cardBrand(Optional<String> var1);

        public _FinalStage cardBrand(String var1);

        public _FinalStage cardExpMonth(Optional<Integer> var1);

        public _FinalStage cardExpMonth(Integer var1);

        public _FinalStage cardExpYear(Optional<Integer> var1);

        public _FinalStage cardExpYear(Integer var1);

        public _FinalStage cardLast4(Optional<String> var1);

        public _FinalStage cardLast4(String var1);
    }

    public static interface PaymentMethodTypeStage {
        public _FinalStage paymentMethodType(@NotNull String var1);
    }

    public static interface CustomerExternalIdStage {
        public PaymentMethodTypeStage customerExternalId(@NotNull String var1);

        public Builder from(PaymentMethodRequestBody var1);
    }
}

