/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.ApiKeyRequestListResponseData;
import com.schematic.api.types.ApiKeyResponseData;
import com.schematic.api.types.CompanyResponseData;
import com.schematic.api.types.PlanChangeResponseDataAction;
import com.schematic.api.types.PlanChangeResponseDataActorType;
import com.schematic.api.types.PlanChangeResponseDataBasePlanAction;
import com.schematic.api.types.PlanChangeResponseDataSubscriptionChangeAction;
import com.schematic.api.types.PlanSnapshotView;
import com.schematic.api.types.SubscriptionTraitUpdate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PlanChangeResponseData {
    private final PlanChangeResponseDataAction action;
    private final PlanChangeResponseDataActorType actorType;
    private final List<PlanSnapshotView> addOnsAdded;
    private final List<PlanSnapshotView> addOnsRemoved;
    private final Optional<ApiKeyResponseData> apiKey;
    private final Optional<ApiKeyRequestListResponseData> apiKeyRequest;
    private final Optional<PlanSnapshotView> basePlan;
    private final Optional<PlanChangeResponseDataBasePlanAction> basePlanAction;
    private final Optional<CompanyResponseData> company;
    private final String companyId;
    private final OffsetDateTime createdAt;
    private final String environmentId;
    private final String id;
    private final Optional<PlanSnapshotView> previousBasePlan;
    private final Optional<String> requestId;
    private final Optional<PlanChangeResponseDataSubscriptionChangeAction> subscriptionChangeAction;
    private final List<SubscriptionTraitUpdate> traitsUpdated;
    private final OffsetDateTime updatedAt;
    private final Optional<String> userId;
    private final Optional<String> userName;
    private final Map<String, Object> additionalProperties;

    private PlanChangeResponseData(PlanChangeResponseDataAction action, PlanChangeResponseDataActorType actorType, List<PlanSnapshotView> addOnsAdded, List<PlanSnapshotView> addOnsRemoved, Optional<ApiKeyResponseData> apiKey, Optional<ApiKeyRequestListResponseData> apiKeyRequest, Optional<PlanSnapshotView> basePlan, Optional<PlanChangeResponseDataBasePlanAction> basePlanAction, Optional<CompanyResponseData> company, String companyId, OffsetDateTime createdAt, String environmentId, String id, Optional<PlanSnapshotView> previousBasePlan, Optional<String> requestId, Optional<PlanChangeResponseDataSubscriptionChangeAction> subscriptionChangeAction, List<SubscriptionTraitUpdate> traitsUpdated, OffsetDateTime updatedAt, Optional<String> userId, Optional<String> userName, Map<String, Object> additionalProperties) {
        this.action = action;
        this.actorType = actorType;
        this.addOnsAdded = addOnsAdded;
        this.addOnsRemoved = addOnsRemoved;
        this.apiKey = apiKey;
        this.apiKeyRequest = apiKeyRequest;
        this.basePlan = basePlan;
        this.basePlanAction = basePlanAction;
        this.company = company;
        this.companyId = companyId;
        this.createdAt = createdAt;
        this.environmentId = environmentId;
        this.id = id;
        this.previousBasePlan = previousBasePlan;
        this.requestId = requestId;
        this.subscriptionChangeAction = subscriptionChangeAction;
        this.traitsUpdated = traitsUpdated;
        this.updatedAt = updatedAt;
        this.userId = userId;
        this.userName = userName;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="action")
    public PlanChangeResponseDataAction getAction() {
        return this.action;
    }

    @JsonProperty(value="actor_type")
    public PlanChangeResponseDataActorType getActorType() {
        return this.actorType;
    }

    @JsonProperty(value="add_ons_added")
    public List<PlanSnapshotView> getAddOnsAdded() {
        return this.addOnsAdded;
    }

    @JsonProperty(value="add_ons_removed")
    public List<PlanSnapshotView> getAddOnsRemoved() {
        return this.addOnsRemoved;
    }

    @JsonProperty(value="api_key")
    public Optional<ApiKeyResponseData> getApiKey() {
        return this.apiKey;
    }

    @JsonProperty(value="api_key_request")
    public Optional<ApiKeyRequestListResponseData> getApiKeyRequest() {
        return this.apiKeyRequest;
    }

    @JsonProperty(value="base_plan")
    public Optional<PlanSnapshotView> getBasePlan() {
        return this.basePlan;
    }

    @JsonProperty(value="base_plan_action")
    public Optional<PlanChangeResponseDataBasePlanAction> getBasePlanAction() {
        return this.basePlanAction;
    }

    @JsonProperty(value="company")
    public Optional<CompanyResponseData> getCompany() {
        return this.company;
    }

    @JsonProperty(value="company_id")
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="previous_base_plan")
    public Optional<PlanSnapshotView> getPreviousBasePlan() {
        return this.previousBasePlan;
    }

    @JsonProperty(value="request_id")
    public Optional<String> getRequestId() {
        return this.requestId;
    }

    @JsonProperty(value="subscription_change_action")
    public Optional<PlanChangeResponseDataSubscriptionChangeAction> getSubscriptionChangeAction() {
        return this.subscriptionChangeAction;
    }

    @JsonProperty(value="traits_updated")
    public List<SubscriptionTraitUpdate> getTraitsUpdated() {
        return this.traitsUpdated;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="user_id")
    public Optional<String> getUserId() {
        return this.userId;
    }

    @JsonProperty(value="user_name")
    public Optional<String> getUserName() {
        return this.userName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PlanChangeResponseData && this.equalTo((PlanChangeResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanChangeResponseData other) {
        return this.action.equals(other.action) && this.actorType.equals(other.actorType) && this.addOnsAdded.equals(other.addOnsAdded) && this.addOnsRemoved.equals(other.addOnsRemoved) && this.apiKey.equals(other.apiKey) && this.apiKeyRequest.equals(other.apiKeyRequest) && this.basePlan.equals(other.basePlan) && this.basePlanAction.equals(other.basePlanAction) && this.company.equals(other.company) && this.companyId.equals(other.companyId) && this.createdAt.equals(other.createdAt) && this.environmentId.equals(other.environmentId) && this.id.equals(other.id) && this.previousBasePlan.equals(other.previousBasePlan) && this.requestId.equals(other.requestId) && this.subscriptionChangeAction.equals(other.subscriptionChangeAction) && this.traitsUpdated.equals(other.traitsUpdated) && this.updatedAt.equals(other.updatedAt) && this.userId.equals(other.userId) && this.userName.equals(other.userName);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.actorType, this.addOnsAdded, this.addOnsRemoved, this.apiKey, this.apiKeyRequest, this.basePlan, this.basePlanAction, this.company, this.companyId, this.createdAt, this.environmentId, this.id, this.previousBasePlan, this.requestId, this.subscriptionChangeAction, this.traitsUpdated, this.updatedAt, this.userId, this.userName);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ActionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ActionStage,
    ActorTypeStage,
    CompanyIdStage,
    CreatedAtStage,
    EnvironmentIdStage,
    IdStage,
    UpdatedAtStage,
    _FinalStage {
        private PlanChangeResponseDataAction action;
        private PlanChangeResponseDataActorType actorType;
        private String companyId;
        private OffsetDateTime createdAt;
        private String environmentId;
        private String id;
        private OffsetDateTime updatedAt;
        private Optional<String> userName = Optional.empty();
        private Optional<String> userId = Optional.empty();
        private List<SubscriptionTraitUpdate> traitsUpdated = new ArrayList<SubscriptionTraitUpdate>();
        private Optional<PlanChangeResponseDataSubscriptionChangeAction> subscriptionChangeAction = Optional.empty();
        private Optional<String> requestId = Optional.empty();
        private Optional<PlanSnapshotView> previousBasePlan = Optional.empty();
        private Optional<CompanyResponseData> company = Optional.empty();
        private Optional<PlanChangeResponseDataBasePlanAction> basePlanAction = Optional.empty();
        private Optional<PlanSnapshotView> basePlan = Optional.empty();
        private Optional<ApiKeyRequestListResponseData> apiKeyRequest = Optional.empty();
        private Optional<ApiKeyResponseData> apiKey = Optional.empty();
        private List<PlanSnapshotView> addOnsRemoved = new ArrayList<PlanSnapshotView>();
        private List<PlanSnapshotView> addOnsAdded = new ArrayList<PlanSnapshotView>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PlanChangeResponseData other) {
            this.action(other.getAction());
            this.actorType(other.getActorType());
            this.addOnsAdded(other.getAddOnsAdded());
            this.addOnsRemoved(other.getAddOnsRemoved());
            this.apiKey(other.getApiKey());
            this.apiKeyRequest(other.getApiKeyRequest());
            this.basePlan(other.getBasePlan());
            this.basePlanAction(other.getBasePlanAction());
            this.company(other.getCompany());
            this.companyId(other.getCompanyId());
            this.createdAt(other.getCreatedAt());
            this.environmentId(other.getEnvironmentId());
            this.id(other.getId());
            this.previousBasePlan(other.getPreviousBasePlan());
            this.requestId(other.getRequestId());
            this.subscriptionChangeAction(other.getSubscriptionChangeAction());
            this.traitsUpdated(other.getTraitsUpdated());
            this.updatedAt(other.getUpdatedAt());
            this.userId(other.getUserId());
            this.userName(other.getUserName());
            return this;
        }

        @Override
        @JsonSetter(value="action")
        public ActorTypeStage action(@NotNull PlanChangeResponseDataAction action) {
            this.action = Objects.requireNonNull(action, "action must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="actor_type")
        public CompanyIdStage actorType(@NotNull PlanChangeResponseDataActorType actorType) {
            this.actorType = Objects.requireNonNull(actorType, "actorType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="company_id")
        public CreatedAtStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public UpdatedAtStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage userName(String userName) {
            this.userName = Optional.ofNullable(userName);
            return this;
        }

        @Override
        @JsonSetter(value="user_name", nulls=Nulls.SKIP)
        public _FinalStage userName(Optional<String> userName) {
            this.userName = userName;
            return this;
        }

        @Override
        public _FinalStage userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @Override
        @JsonSetter(value="user_id", nulls=Nulls.SKIP)
        public _FinalStage userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public _FinalStage addAllTraitsUpdated(List<SubscriptionTraitUpdate> traitsUpdated) {
            if (traitsUpdated != null) {
                this.traitsUpdated.addAll(traitsUpdated);
            }
            return this;
        }

        @Override
        public _FinalStage addTraitsUpdated(SubscriptionTraitUpdate traitsUpdated) {
            this.traitsUpdated.add(traitsUpdated);
            return this;
        }

        @Override
        @JsonSetter(value="traits_updated", nulls=Nulls.SKIP)
        public _FinalStage traitsUpdated(List<SubscriptionTraitUpdate> traitsUpdated) {
            this.traitsUpdated.clear();
            if (traitsUpdated != null) {
                this.traitsUpdated.addAll(traitsUpdated);
            }
            return this;
        }

        @Override
        public _FinalStage subscriptionChangeAction(PlanChangeResponseDataSubscriptionChangeAction subscriptionChangeAction) {
            this.subscriptionChangeAction = Optional.ofNullable(subscriptionChangeAction);
            return this;
        }

        @Override
        @JsonSetter(value="subscription_change_action", nulls=Nulls.SKIP)
        public _FinalStage subscriptionChangeAction(Optional<PlanChangeResponseDataSubscriptionChangeAction> subscriptionChangeAction) {
            this.subscriptionChangeAction = subscriptionChangeAction;
            return this;
        }

        @Override
        public _FinalStage requestId(String requestId) {
            this.requestId = Optional.ofNullable(requestId);
            return this;
        }

        @Override
        @JsonSetter(value="request_id", nulls=Nulls.SKIP)
        public _FinalStage requestId(Optional<String> requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public _FinalStage previousBasePlan(PlanSnapshotView previousBasePlan) {
            this.previousBasePlan = Optional.ofNullable(previousBasePlan);
            return this;
        }

        @Override
        @JsonSetter(value="previous_base_plan", nulls=Nulls.SKIP)
        public _FinalStage previousBasePlan(Optional<PlanSnapshotView> previousBasePlan) {
            this.previousBasePlan = previousBasePlan;
            return this;
        }

        @Override
        public _FinalStage company(CompanyResponseData company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @Override
        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public _FinalStage company(Optional<CompanyResponseData> company) {
            this.company = company;
            return this;
        }

        @Override
        public _FinalStage basePlanAction(PlanChangeResponseDataBasePlanAction basePlanAction) {
            this.basePlanAction = Optional.ofNullable(basePlanAction);
            return this;
        }

        @Override
        @JsonSetter(value="base_plan_action", nulls=Nulls.SKIP)
        public _FinalStage basePlanAction(Optional<PlanChangeResponseDataBasePlanAction> basePlanAction) {
            this.basePlanAction = basePlanAction;
            return this;
        }

        @Override
        public _FinalStage basePlan(PlanSnapshotView basePlan) {
            this.basePlan = Optional.ofNullable(basePlan);
            return this;
        }

        @Override
        @JsonSetter(value="base_plan", nulls=Nulls.SKIP)
        public _FinalStage basePlan(Optional<PlanSnapshotView> basePlan) {
            this.basePlan = basePlan;
            return this;
        }

        @Override
        public _FinalStage apiKeyRequest(ApiKeyRequestListResponseData apiKeyRequest) {
            this.apiKeyRequest = Optional.ofNullable(apiKeyRequest);
            return this;
        }

        @Override
        @JsonSetter(value="api_key_request", nulls=Nulls.SKIP)
        public _FinalStage apiKeyRequest(Optional<ApiKeyRequestListResponseData> apiKeyRequest) {
            this.apiKeyRequest = apiKeyRequest;
            return this;
        }

        @Override
        public _FinalStage apiKey(ApiKeyResponseData apiKey) {
            this.apiKey = Optional.ofNullable(apiKey);
            return this;
        }

        @Override
        @JsonSetter(value="api_key", nulls=Nulls.SKIP)
        public _FinalStage apiKey(Optional<ApiKeyResponseData> apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public _FinalStage addAllAddOnsRemoved(List<PlanSnapshotView> addOnsRemoved) {
            if (addOnsRemoved != null) {
                this.addOnsRemoved.addAll(addOnsRemoved);
            }
            return this;
        }

        @Override
        public _FinalStage addAddOnsRemoved(PlanSnapshotView addOnsRemoved) {
            this.addOnsRemoved.add(addOnsRemoved);
            return this;
        }

        @Override
        @JsonSetter(value="add_ons_removed", nulls=Nulls.SKIP)
        public _FinalStage addOnsRemoved(List<PlanSnapshotView> addOnsRemoved) {
            this.addOnsRemoved.clear();
            if (addOnsRemoved != null) {
                this.addOnsRemoved.addAll(addOnsRemoved);
            }
            return this;
        }

        @Override
        public _FinalStage addAllAddOnsAdded(List<PlanSnapshotView> addOnsAdded) {
            if (addOnsAdded != null) {
                this.addOnsAdded.addAll(addOnsAdded);
            }
            return this;
        }

        @Override
        public _FinalStage addAddOnsAdded(PlanSnapshotView addOnsAdded) {
            this.addOnsAdded.add(addOnsAdded);
            return this;
        }

        @Override
        @JsonSetter(value="add_ons_added", nulls=Nulls.SKIP)
        public _FinalStage addOnsAdded(List<PlanSnapshotView> addOnsAdded) {
            this.addOnsAdded.clear();
            if (addOnsAdded != null) {
                this.addOnsAdded.addAll(addOnsAdded);
            }
            return this;
        }

        @Override
        public PlanChangeResponseData build() {
            return new PlanChangeResponseData(this.action, this.actorType, this.addOnsAdded, this.addOnsRemoved, this.apiKey, this.apiKeyRequest, this.basePlan, this.basePlanAction, this.company, this.companyId, this.createdAt, this.environmentId, this.id, this.previousBasePlan, this.requestId, this.subscriptionChangeAction, this.traitsUpdated, this.updatedAt, this.userId, this.userName, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PlanChangeResponseData build();

        public _FinalStage addOnsAdded(List<PlanSnapshotView> var1);

        public _FinalStage addAddOnsAdded(PlanSnapshotView var1);

        public _FinalStage addAllAddOnsAdded(List<PlanSnapshotView> var1);

        public _FinalStage addOnsRemoved(List<PlanSnapshotView> var1);

        public _FinalStage addAddOnsRemoved(PlanSnapshotView var1);

        public _FinalStage addAllAddOnsRemoved(List<PlanSnapshotView> var1);

        public _FinalStage apiKey(Optional<ApiKeyResponseData> var1);

        public _FinalStage apiKey(ApiKeyResponseData var1);

        public _FinalStage apiKeyRequest(Optional<ApiKeyRequestListResponseData> var1);

        public _FinalStage apiKeyRequest(ApiKeyRequestListResponseData var1);

        public _FinalStage basePlan(Optional<PlanSnapshotView> var1);

        public _FinalStage basePlan(PlanSnapshotView var1);

        public _FinalStage basePlanAction(Optional<PlanChangeResponseDataBasePlanAction> var1);

        public _FinalStage basePlanAction(PlanChangeResponseDataBasePlanAction var1);

        public _FinalStage company(Optional<CompanyResponseData> var1);

        public _FinalStage company(CompanyResponseData var1);

        public _FinalStage previousBasePlan(Optional<PlanSnapshotView> var1);

        public _FinalStage previousBasePlan(PlanSnapshotView var1);

        public _FinalStage requestId(Optional<String> var1);

        public _FinalStage requestId(String var1);

        public _FinalStage subscriptionChangeAction(Optional<PlanChangeResponseDataSubscriptionChangeAction> var1);

        public _FinalStage subscriptionChangeAction(PlanChangeResponseDataSubscriptionChangeAction var1);

        public _FinalStage traitsUpdated(List<SubscriptionTraitUpdate> var1);

        public _FinalStage addTraitsUpdated(SubscriptionTraitUpdate var1);

        public _FinalStage addAllTraitsUpdated(List<SubscriptionTraitUpdate> var1);

        public _FinalStage userId(Optional<String> var1);

        public _FinalStage userId(String var1);

        public _FinalStage userName(Optional<String> var1);

        public _FinalStage userName(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface IdStage {
        public UpdatedAtStage id(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public IdStage environmentId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface CompanyIdStage {
        public CreatedAtStage companyId(@NotNull String var1);
    }

    public static interface ActorTypeStage {
        public CompanyIdStage actorType(@NotNull PlanChangeResponseDataActorType var1);
    }

    public static interface ActionStage {
        public ActorTypeStage action(@NotNull PlanChangeResponseDataAction var1);

        public Builder from(PlanChangeResponseData var1);
    }
}

