/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PlanCreditGrantView {
    private final OffsetDateTime createdAt;
    private final int creditAmount;
    private final String creditDescription;
    private final Optional<String> creditIcon;
    private final String creditId;
    private final String creditName;
    private final Optional<String> expiryType;
    private final Optional<String> expiryUnit;
    private final Optional<Integer> expiryUnitCount;
    private final String id;
    private final String planId;
    private final String planName;
    private final Optional<String> pluralName;
    private final String resetCadence;
    private final String resetStart;
    private final String resetType;
    private final Optional<String> singularName;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private PlanCreditGrantView(OffsetDateTime createdAt, int creditAmount, String creditDescription, Optional<String> creditIcon, String creditId, String creditName, Optional<String> expiryType, Optional<String> expiryUnit, Optional<Integer> expiryUnitCount, String id, String planId, String planName, Optional<String> pluralName, String resetCadence, String resetStart, String resetType, Optional<String> singularName, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.creditAmount = creditAmount;
        this.creditDescription = creditDescription;
        this.creditIcon = creditIcon;
        this.creditId = creditId;
        this.creditName = creditName;
        this.expiryType = expiryType;
        this.expiryUnit = expiryUnit;
        this.expiryUnitCount = expiryUnitCount;
        this.id = id;
        this.planId = planId;
        this.planName = planName;
        this.pluralName = pluralName;
        this.resetCadence = resetCadence;
        this.resetStart = resetStart;
        this.resetType = resetType;
        this.singularName = singularName;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="credit_amount")
    public int getCreditAmount() {
        return this.creditAmount;
    }

    @JsonProperty(value="credit_description")
    public String getCreditDescription() {
        return this.creditDescription;
    }

    @JsonProperty(value="credit_icon")
    public Optional<String> getCreditIcon() {
        return this.creditIcon;
    }

    @JsonProperty(value="credit_id")
    public String getCreditId() {
        return this.creditId;
    }

    @JsonProperty(value="credit_name")
    public String getCreditName() {
        return this.creditName;
    }

    @JsonProperty(value="expiry_type")
    public Optional<String> getExpiryType() {
        return this.expiryType;
    }

    @JsonProperty(value="expiry_unit")
    public Optional<String> getExpiryUnit() {
        return this.expiryUnit;
    }

    @JsonProperty(value="expiry_unit_count")
    public Optional<Integer> getExpiryUnitCount() {
        return this.expiryUnitCount;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="plan_id")
    public String getPlanId() {
        return this.planId;
    }

    @JsonProperty(value="plan_name")
    public String getPlanName() {
        return this.planName;
    }

    @JsonProperty(value="plural_name")
    public Optional<String> getPluralName() {
        return this.pluralName;
    }

    @JsonProperty(value="reset_cadence")
    public String getResetCadence() {
        return this.resetCadence;
    }

    @JsonProperty(value="reset_start")
    public String getResetStart() {
        return this.resetStart;
    }

    @JsonProperty(value="reset_type")
    public String getResetType() {
        return this.resetType;
    }

    @JsonProperty(value="singular_name")
    public Optional<String> getSingularName() {
        return this.singularName;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PlanCreditGrantView && this.equalTo((PlanCreditGrantView)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanCreditGrantView other) {
        return this.createdAt.equals(other.createdAt) && this.creditAmount == other.creditAmount && this.creditDescription.equals(other.creditDescription) && this.creditIcon.equals(other.creditIcon) && this.creditId.equals(other.creditId) && this.creditName.equals(other.creditName) && this.expiryType.equals(other.expiryType) && this.expiryUnit.equals(other.expiryUnit) && this.expiryUnitCount.equals(other.expiryUnitCount) && this.id.equals(other.id) && this.planId.equals(other.planId) && this.planName.equals(other.planName) && this.pluralName.equals(other.pluralName) && this.resetCadence.equals(other.resetCadence) && this.resetStart.equals(other.resetStart) && this.resetType.equals(other.resetType) && this.singularName.equals(other.singularName) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.creditAmount, this.creditDescription, this.creditIcon, this.creditId, this.creditName, this.expiryType, this.expiryUnit, this.expiryUnitCount, this.id, this.planId, this.planName, this.pluralName, this.resetCadence, this.resetStart, this.resetType, this.singularName, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    CreditAmountStage,
    CreditDescriptionStage,
    CreditIdStage,
    CreditNameStage,
    IdStage,
    PlanIdStage,
    PlanNameStage,
    ResetCadenceStage,
    ResetStartStage,
    ResetTypeStage,
    UpdatedAtStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private int creditAmount;
        private String creditDescription;
        private String creditId;
        private String creditName;
        private String id;
        private String planId;
        private String planName;
        private String resetCadence;
        private String resetStart;
        private String resetType;
        private OffsetDateTime updatedAt;
        private Optional<String> singularName = Optional.empty();
        private Optional<String> pluralName = Optional.empty();
        private Optional<Integer> expiryUnitCount = Optional.empty();
        private Optional<String> expiryUnit = Optional.empty();
        private Optional<String> expiryType = Optional.empty();
        private Optional<String> creditIcon = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PlanCreditGrantView other) {
            this.createdAt(other.getCreatedAt());
            this.creditAmount(other.getCreditAmount());
            this.creditDescription(other.getCreditDescription());
            this.creditIcon(other.getCreditIcon());
            this.creditId(other.getCreditId());
            this.creditName(other.getCreditName());
            this.expiryType(other.getExpiryType());
            this.expiryUnit(other.getExpiryUnit());
            this.expiryUnitCount(other.getExpiryUnitCount());
            this.id(other.getId());
            this.planId(other.getPlanId());
            this.planName(other.getPlanName());
            this.pluralName(other.getPluralName());
            this.resetCadence(other.getResetCadence());
            this.resetStart(other.getResetStart());
            this.resetType(other.getResetType());
            this.singularName(other.getSingularName());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public CreditAmountStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="credit_amount")
        public CreditDescriptionStage creditAmount(int creditAmount) {
            this.creditAmount = creditAmount;
            return this;
        }

        @Override
        @JsonSetter(value="credit_description")
        public CreditIdStage creditDescription(@NotNull String creditDescription) {
            this.creditDescription = Objects.requireNonNull(creditDescription, "creditDescription must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="credit_id")
        public CreditNameStage creditId(@NotNull String creditId) {
            this.creditId = Objects.requireNonNull(creditId, "creditId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="credit_name")
        public IdStage creditName(@NotNull String creditName) {
            this.creditName = Objects.requireNonNull(creditName, "creditName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public PlanIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="plan_id")
        public PlanNameStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="plan_name")
        public ResetCadenceStage planName(@NotNull String planName) {
            this.planName = Objects.requireNonNull(planName, "planName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="reset_cadence")
        public ResetStartStage resetCadence(@NotNull String resetCadence) {
            this.resetCadence = Objects.requireNonNull(resetCadence, "resetCadence must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="reset_start")
        public ResetTypeStage resetStart(@NotNull String resetStart) {
            this.resetStart = Objects.requireNonNull(resetStart, "resetStart must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="reset_type")
        public UpdatedAtStage resetType(@NotNull String resetType) {
            this.resetType = Objects.requireNonNull(resetType, "resetType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage singularName(String singularName) {
            this.singularName = Optional.ofNullable(singularName);
            return this;
        }

        @Override
        @JsonSetter(value="singular_name", nulls=Nulls.SKIP)
        public _FinalStage singularName(Optional<String> singularName) {
            this.singularName = singularName;
            return this;
        }

        @Override
        public _FinalStage pluralName(String pluralName) {
            this.pluralName = Optional.ofNullable(pluralName);
            return this;
        }

        @Override
        @JsonSetter(value="plural_name", nulls=Nulls.SKIP)
        public _FinalStage pluralName(Optional<String> pluralName) {
            this.pluralName = pluralName;
            return this;
        }

        @Override
        public _FinalStage expiryUnitCount(Integer expiryUnitCount) {
            this.expiryUnitCount = Optional.ofNullable(expiryUnitCount);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_unit_count", nulls=Nulls.SKIP)
        public _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount) {
            this.expiryUnitCount = expiryUnitCount;
            return this;
        }

        @Override
        public _FinalStage expiryUnit(String expiryUnit) {
            this.expiryUnit = Optional.ofNullable(expiryUnit);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_unit", nulls=Nulls.SKIP)
        public _FinalStage expiryUnit(Optional<String> expiryUnit) {
            this.expiryUnit = expiryUnit;
            return this;
        }

        @Override
        public _FinalStage expiryType(String expiryType) {
            this.expiryType = Optional.ofNullable(expiryType);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_type", nulls=Nulls.SKIP)
        public _FinalStage expiryType(Optional<String> expiryType) {
            this.expiryType = expiryType;
            return this;
        }

        @Override
        public _FinalStage creditIcon(String creditIcon) {
            this.creditIcon = Optional.ofNullable(creditIcon);
            return this;
        }

        @Override
        @JsonSetter(value="credit_icon", nulls=Nulls.SKIP)
        public _FinalStage creditIcon(Optional<String> creditIcon) {
            this.creditIcon = creditIcon;
            return this;
        }

        @Override
        public PlanCreditGrantView build() {
            return new PlanCreditGrantView(this.createdAt, this.creditAmount, this.creditDescription, this.creditIcon, this.creditId, this.creditName, this.expiryType, this.expiryUnit, this.expiryUnitCount, this.id, this.planId, this.planName, this.pluralName, this.resetCadence, this.resetStart, this.resetType, this.singularName, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PlanCreditGrantView build();

        public _FinalStage creditIcon(Optional<String> var1);

        public _FinalStage creditIcon(String var1);

        public _FinalStage expiryType(Optional<String> var1);

        public _FinalStage expiryType(String var1);

        public _FinalStage expiryUnit(Optional<String> var1);

        public _FinalStage expiryUnit(String var1);

        public _FinalStage expiryUnitCount(Optional<Integer> var1);

        public _FinalStage expiryUnitCount(Integer var1);

        public _FinalStage pluralName(Optional<String> var1);

        public _FinalStage pluralName(String var1);

        public _FinalStage singularName(Optional<String> var1);

        public _FinalStage singularName(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface ResetTypeStage {
        public UpdatedAtStage resetType(@NotNull String var1);
    }

    public static interface ResetStartStage {
        public ResetTypeStage resetStart(@NotNull String var1);
    }

    public static interface ResetCadenceStage {
        public ResetStartStage resetCadence(@NotNull String var1);
    }

    public static interface PlanNameStage {
        public ResetCadenceStage planName(@NotNull String var1);
    }

    public static interface PlanIdStage {
        public PlanNameStage planId(@NotNull String var1);
    }

    public static interface IdStage {
        public PlanIdStage id(@NotNull String var1);
    }

    public static interface CreditNameStage {
        public IdStage creditName(@NotNull String var1);
    }

    public static interface CreditIdStage {
        public CreditNameStage creditId(@NotNull String var1);
    }

    public static interface CreditDescriptionStage {
        public CreditIdStage creditDescription(@NotNull String var1);
    }

    public static interface CreditAmountStage {
        public CreditDescriptionStage creditAmount(int var1);
    }

    public static interface CreatedAtStage {
        public CreditAmountStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(PlanCreditGrantView var1);
    }
}

