/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingPriceResponseData;
import com.schematic.api.types.CheckoutSettingsResponseData;
import com.schematic.api.types.CustomPlanViewConfigResponseData;
import com.schematic.api.types.PlanGroupBundleOrder;
import com.schematic.api.types.PlanGroupPlanDetailResponseData;
import com.schematic.api.types.PlanGroupPlanEntitlementsOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PlanGroupDetailResponseData {
    private final List<PlanGroupPlanDetailResponseData> addOns;
    private final CheckoutSettingsResponseData checkoutSettings;
    private final Optional<CustomPlanViewConfigResponseData> customPlanConfig;
    private final Optional<String> customPlanId;
    private final Optional<PlanGroupPlanDetailResponseData> defaultPlan;
    private final Optional<String> defaultPlanId;
    private final Optional<PlanGroupPlanDetailResponseData> fallbackPlan;
    private final Optional<String> fallbackPlanId;
    private final String id;
    private final Optional<PlanGroupPlanDetailResponseData> initialPlan;
    private final Optional<String> initialPlanId;
    private final Optional<BillingPriceResponseData> initialPlanPrice;
    private final Optional<String> initialPlanPriceId;
    private final List<PlanGroupPlanEntitlementsOrder> orderedAddOnList;
    private final List<PlanGroupBundleOrder> orderedBundleList;
    private final List<PlanGroupPlanEntitlementsOrder> orderedPlanList;
    private final List<PlanGroupPlanDetailResponseData> plans;
    private final boolean preventDowngradesWhenOverLimit;
    private final boolean showCredits;
    private final boolean showPeriodToggle;
    private final boolean showZeroPriceAsFree;
    private final boolean syncCustomerBillingDetailsForTax;
    private final boolean taxCollectionEnabled;
    private final Optional<Integer> trialDays;
    private final Optional<PlanGroupPlanDetailResponseData> trialExpiryPlan;
    private final Optional<String> trialExpiryPlanId;
    private final Optional<BillingPriceResponseData> trialExpiryPlanPrice;
    private final Optional<String> trialExpiryPlanPriceId;
    private final Optional<Boolean> trialPaymentMethodRequired;
    private final Map<String, Object> additionalProperties;

    private PlanGroupDetailResponseData(List<PlanGroupPlanDetailResponseData> addOns, CheckoutSettingsResponseData checkoutSettings, Optional<CustomPlanViewConfigResponseData> customPlanConfig, Optional<String> customPlanId, Optional<PlanGroupPlanDetailResponseData> defaultPlan, Optional<String> defaultPlanId, Optional<PlanGroupPlanDetailResponseData> fallbackPlan, Optional<String> fallbackPlanId, String id, Optional<PlanGroupPlanDetailResponseData> initialPlan, Optional<String> initialPlanId, Optional<BillingPriceResponseData> initialPlanPrice, Optional<String> initialPlanPriceId, List<PlanGroupPlanEntitlementsOrder> orderedAddOnList, List<PlanGroupBundleOrder> orderedBundleList, List<PlanGroupPlanEntitlementsOrder> orderedPlanList, List<PlanGroupPlanDetailResponseData> plans, boolean preventDowngradesWhenOverLimit, boolean showCredits, boolean showPeriodToggle, boolean showZeroPriceAsFree, boolean syncCustomerBillingDetailsForTax, boolean taxCollectionEnabled, Optional<Integer> trialDays, Optional<PlanGroupPlanDetailResponseData> trialExpiryPlan, Optional<String> trialExpiryPlanId, Optional<BillingPriceResponseData> trialExpiryPlanPrice, Optional<String> trialExpiryPlanPriceId, Optional<Boolean> trialPaymentMethodRequired, Map<String, Object> additionalProperties) {
        this.addOns = addOns;
        this.checkoutSettings = checkoutSettings;
        this.customPlanConfig = customPlanConfig;
        this.customPlanId = customPlanId;
        this.defaultPlan = defaultPlan;
        this.defaultPlanId = defaultPlanId;
        this.fallbackPlan = fallbackPlan;
        this.fallbackPlanId = fallbackPlanId;
        this.id = id;
        this.initialPlan = initialPlan;
        this.initialPlanId = initialPlanId;
        this.initialPlanPrice = initialPlanPrice;
        this.initialPlanPriceId = initialPlanPriceId;
        this.orderedAddOnList = orderedAddOnList;
        this.orderedBundleList = orderedBundleList;
        this.orderedPlanList = orderedPlanList;
        this.plans = plans;
        this.preventDowngradesWhenOverLimit = preventDowngradesWhenOverLimit;
        this.showCredits = showCredits;
        this.showPeriodToggle = showPeriodToggle;
        this.showZeroPriceAsFree = showZeroPriceAsFree;
        this.syncCustomerBillingDetailsForTax = syncCustomerBillingDetailsForTax;
        this.taxCollectionEnabled = taxCollectionEnabled;
        this.trialDays = trialDays;
        this.trialExpiryPlan = trialExpiryPlan;
        this.trialExpiryPlanId = trialExpiryPlanId;
        this.trialExpiryPlanPrice = trialExpiryPlanPrice;
        this.trialExpiryPlanPriceId = trialExpiryPlanPriceId;
        this.trialPaymentMethodRequired = trialPaymentMethodRequired;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="add_ons")
    public List<PlanGroupPlanDetailResponseData> getAddOns() {
        return this.addOns;
    }

    @JsonProperty(value="checkout_settings")
    public CheckoutSettingsResponseData getCheckoutSettings() {
        return this.checkoutSettings;
    }

    @JsonProperty(value="custom_plan_config")
    public Optional<CustomPlanViewConfigResponseData> getCustomPlanConfig() {
        return this.customPlanConfig;
    }

    @JsonProperty(value="custom_plan_id")
    public Optional<String> getCustomPlanId() {
        return this.customPlanId;
    }

    @JsonProperty(value="default_plan")
    public Optional<PlanGroupPlanDetailResponseData> getDefaultPlan() {
        return this.defaultPlan;
    }

    @JsonProperty(value="default_plan_id")
    public Optional<String> getDefaultPlanId() {
        return this.defaultPlanId;
    }

    @JsonProperty(value="fallback_plan")
    public Optional<PlanGroupPlanDetailResponseData> getFallbackPlan() {
        return this.fallbackPlan;
    }

    @JsonProperty(value="fallback_plan_id")
    public Optional<String> getFallbackPlanId() {
        return this.fallbackPlanId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="initial_plan")
    public Optional<PlanGroupPlanDetailResponseData> getInitialPlan() {
        return this.initialPlan;
    }

    @JsonProperty(value="initial_plan_id")
    public Optional<String> getInitialPlanId() {
        return this.initialPlanId;
    }

    @JsonProperty(value="initial_plan_price")
    public Optional<BillingPriceResponseData> getInitialPlanPrice() {
        return this.initialPlanPrice;
    }

    @JsonProperty(value="initial_plan_price_id")
    public Optional<String> getInitialPlanPriceId() {
        return this.initialPlanPriceId;
    }

    @JsonProperty(value="ordered_add_on_list")
    public List<PlanGroupPlanEntitlementsOrder> getOrderedAddOnList() {
        return this.orderedAddOnList;
    }

    @JsonProperty(value="ordered_bundle_list")
    public List<PlanGroupBundleOrder> getOrderedBundleList() {
        return this.orderedBundleList;
    }

    @JsonProperty(value="ordered_plan_list")
    public List<PlanGroupPlanEntitlementsOrder> getOrderedPlanList() {
        return this.orderedPlanList;
    }

    @JsonProperty(value="plans")
    public List<PlanGroupPlanDetailResponseData> getPlans() {
        return this.plans;
    }

    @JsonProperty(value="prevent_downgrades_when_over_limit")
    public boolean getPreventDowngradesWhenOverLimit() {
        return this.preventDowngradesWhenOverLimit;
    }

    @JsonProperty(value="show_credits")
    public boolean getShowCredits() {
        return this.showCredits;
    }

    @JsonProperty(value="show_period_toggle")
    public boolean getShowPeriodToggle() {
        return this.showPeriodToggle;
    }

    @JsonProperty(value="show_zero_price_as_free")
    public boolean getShowZeroPriceAsFree() {
        return this.showZeroPriceAsFree;
    }

    @JsonProperty(value="sync_customer_billing_details_for_tax")
    public boolean getSyncCustomerBillingDetailsForTax() {
        return this.syncCustomerBillingDetailsForTax;
    }

    @JsonProperty(value="tax_collection_enabled")
    public boolean getTaxCollectionEnabled() {
        return this.taxCollectionEnabled;
    }

    @JsonProperty(value="trial_days")
    public Optional<Integer> getTrialDays() {
        return this.trialDays;
    }

    @JsonProperty(value="trial_expiry_plan")
    public Optional<PlanGroupPlanDetailResponseData> getTrialExpiryPlan() {
        return this.trialExpiryPlan;
    }

    @JsonProperty(value="trial_expiry_plan_id")
    public Optional<String> getTrialExpiryPlanId() {
        return this.trialExpiryPlanId;
    }

    @JsonProperty(value="trial_expiry_plan_price")
    public Optional<BillingPriceResponseData> getTrialExpiryPlanPrice() {
        return this.trialExpiryPlanPrice;
    }

    @JsonProperty(value="trial_expiry_plan_price_id")
    public Optional<String> getTrialExpiryPlanPriceId() {
        return this.trialExpiryPlanPriceId;
    }

    @JsonProperty(value="trial_payment_method_required")
    public Optional<Boolean> getTrialPaymentMethodRequired() {
        return this.trialPaymentMethodRequired;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PlanGroupDetailResponseData && this.equalTo((PlanGroupDetailResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanGroupDetailResponseData other) {
        return this.addOns.equals(other.addOns) && this.checkoutSettings.equals(other.checkoutSettings) && this.customPlanConfig.equals(other.customPlanConfig) && this.customPlanId.equals(other.customPlanId) && this.defaultPlan.equals(other.defaultPlan) && this.defaultPlanId.equals(other.defaultPlanId) && this.fallbackPlan.equals(other.fallbackPlan) && this.fallbackPlanId.equals(other.fallbackPlanId) && this.id.equals(other.id) && this.initialPlan.equals(other.initialPlan) && this.initialPlanId.equals(other.initialPlanId) && this.initialPlanPrice.equals(other.initialPlanPrice) && this.initialPlanPriceId.equals(other.initialPlanPriceId) && this.orderedAddOnList.equals(other.orderedAddOnList) && this.orderedBundleList.equals(other.orderedBundleList) && this.orderedPlanList.equals(other.orderedPlanList) && this.plans.equals(other.plans) && this.preventDowngradesWhenOverLimit == other.preventDowngradesWhenOverLimit && this.showCredits == other.showCredits && this.showPeriodToggle == other.showPeriodToggle && this.showZeroPriceAsFree == other.showZeroPriceAsFree && this.syncCustomerBillingDetailsForTax == other.syncCustomerBillingDetailsForTax && this.taxCollectionEnabled == other.taxCollectionEnabled && this.trialDays.equals(other.trialDays) && this.trialExpiryPlan.equals(other.trialExpiryPlan) && this.trialExpiryPlanId.equals(other.trialExpiryPlanId) && this.trialExpiryPlanPrice.equals(other.trialExpiryPlanPrice) && this.trialExpiryPlanPriceId.equals(other.trialExpiryPlanPriceId) && this.trialPaymentMethodRequired.equals(other.trialPaymentMethodRequired);
    }

    public int hashCode() {
        return Objects.hash(this.addOns, this.checkoutSettings, this.customPlanConfig, this.customPlanId, this.defaultPlan, this.defaultPlanId, this.fallbackPlan, this.fallbackPlanId, this.id, this.initialPlan, this.initialPlanId, this.initialPlanPrice, this.initialPlanPriceId, this.orderedAddOnList, this.orderedBundleList, this.orderedPlanList, this.plans, this.preventDowngradesWhenOverLimit, this.showCredits, this.showPeriodToggle, this.showZeroPriceAsFree, this.syncCustomerBillingDetailsForTax, this.taxCollectionEnabled, this.trialDays, this.trialExpiryPlan, this.trialExpiryPlanId, this.trialExpiryPlanPrice, this.trialExpiryPlanPriceId, this.trialPaymentMethodRequired);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CheckoutSettingsStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CheckoutSettingsStage,
    IdStage,
    PreventDowngradesWhenOverLimitStage,
    ShowCreditsStage,
    ShowPeriodToggleStage,
    ShowZeroPriceAsFreeStage,
    SyncCustomerBillingDetailsForTaxStage,
    TaxCollectionEnabledStage,
    _FinalStage {
        private CheckoutSettingsResponseData checkoutSettings;
        private String id;
        private boolean preventDowngradesWhenOverLimit;
        private boolean showCredits;
        private boolean showPeriodToggle;
        private boolean showZeroPriceAsFree;
        private boolean syncCustomerBillingDetailsForTax;
        private boolean taxCollectionEnabled;
        private Optional<Boolean> trialPaymentMethodRequired = Optional.empty();
        private Optional<String> trialExpiryPlanPriceId = Optional.empty();
        private Optional<BillingPriceResponseData> trialExpiryPlanPrice = Optional.empty();
        private Optional<String> trialExpiryPlanId = Optional.empty();
        private Optional<PlanGroupPlanDetailResponseData> trialExpiryPlan = Optional.empty();
        private Optional<Integer> trialDays = Optional.empty();
        private List<PlanGroupPlanDetailResponseData> plans = new ArrayList<PlanGroupPlanDetailResponseData>();
        private List<PlanGroupPlanEntitlementsOrder> orderedPlanList = new ArrayList<PlanGroupPlanEntitlementsOrder>();
        private List<PlanGroupBundleOrder> orderedBundleList = new ArrayList<PlanGroupBundleOrder>();
        private List<PlanGroupPlanEntitlementsOrder> orderedAddOnList = new ArrayList<PlanGroupPlanEntitlementsOrder>();
        private Optional<String> initialPlanPriceId = Optional.empty();
        private Optional<BillingPriceResponseData> initialPlanPrice = Optional.empty();
        private Optional<String> initialPlanId = Optional.empty();
        private Optional<PlanGroupPlanDetailResponseData> initialPlan = Optional.empty();
        private Optional<String> fallbackPlanId = Optional.empty();
        private Optional<PlanGroupPlanDetailResponseData> fallbackPlan = Optional.empty();
        private Optional<String> defaultPlanId = Optional.empty();
        private Optional<PlanGroupPlanDetailResponseData> defaultPlan = Optional.empty();
        private Optional<String> customPlanId = Optional.empty();
        private Optional<CustomPlanViewConfigResponseData> customPlanConfig = Optional.empty();
        private List<PlanGroupPlanDetailResponseData> addOns = new ArrayList<PlanGroupPlanDetailResponseData>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PlanGroupDetailResponseData other) {
            this.addOns(other.getAddOns());
            this.checkoutSettings(other.getCheckoutSettings());
            this.customPlanConfig(other.getCustomPlanConfig());
            this.customPlanId(other.getCustomPlanId());
            this.defaultPlan(other.getDefaultPlan());
            this.defaultPlanId(other.getDefaultPlanId());
            this.fallbackPlan(other.getFallbackPlan());
            this.fallbackPlanId(other.getFallbackPlanId());
            this.id(other.getId());
            this.initialPlan(other.getInitialPlan());
            this.initialPlanId(other.getInitialPlanId());
            this.initialPlanPrice(other.getInitialPlanPrice());
            this.initialPlanPriceId(other.getInitialPlanPriceId());
            this.orderedAddOnList(other.getOrderedAddOnList());
            this.orderedBundleList(other.getOrderedBundleList());
            this.orderedPlanList(other.getOrderedPlanList());
            this.plans(other.getPlans());
            this.preventDowngradesWhenOverLimit(other.getPreventDowngradesWhenOverLimit());
            this.showCredits(other.getShowCredits());
            this.showPeriodToggle(other.getShowPeriodToggle());
            this.showZeroPriceAsFree(other.getShowZeroPriceAsFree());
            this.syncCustomerBillingDetailsForTax(other.getSyncCustomerBillingDetailsForTax());
            this.taxCollectionEnabled(other.getTaxCollectionEnabled());
            this.trialDays(other.getTrialDays());
            this.trialExpiryPlan(other.getTrialExpiryPlan());
            this.trialExpiryPlanId(other.getTrialExpiryPlanId());
            this.trialExpiryPlanPrice(other.getTrialExpiryPlanPrice());
            this.trialExpiryPlanPriceId(other.getTrialExpiryPlanPriceId());
            this.trialPaymentMethodRequired(other.getTrialPaymentMethodRequired());
            return this;
        }

        @Override
        @JsonSetter(value="checkout_settings")
        public IdStage checkoutSettings(@NotNull CheckoutSettingsResponseData checkoutSettings) {
            this.checkoutSettings = Objects.requireNonNull(checkoutSettings, "checkoutSettings must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public PreventDowngradesWhenOverLimitStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="prevent_downgrades_when_over_limit")
        public ShowCreditsStage preventDowngradesWhenOverLimit(boolean preventDowngradesWhenOverLimit) {
            this.preventDowngradesWhenOverLimit = preventDowngradesWhenOverLimit;
            return this;
        }

        @Override
        @JsonSetter(value="show_credits")
        public ShowPeriodToggleStage showCredits(boolean showCredits) {
            this.showCredits = showCredits;
            return this;
        }

        @Override
        @JsonSetter(value="show_period_toggle")
        public ShowZeroPriceAsFreeStage showPeriodToggle(boolean showPeriodToggle) {
            this.showPeriodToggle = showPeriodToggle;
            return this;
        }

        @Override
        @JsonSetter(value="show_zero_price_as_free")
        public SyncCustomerBillingDetailsForTaxStage showZeroPriceAsFree(boolean showZeroPriceAsFree) {
            this.showZeroPriceAsFree = showZeroPriceAsFree;
            return this;
        }

        @Override
        @JsonSetter(value="sync_customer_billing_details_for_tax")
        public TaxCollectionEnabledStage syncCustomerBillingDetailsForTax(boolean syncCustomerBillingDetailsForTax) {
            this.syncCustomerBillingDetailsForTax = syncCustomerBillingDetailsForTax;
            return this;
        }

        @Override
        @JsonSetter(value="tax_collection_enabled")
        public _FinalStage taxCollectionEnabled(boolean taxCollectionEnabled) {
            this.taxCollectionEnabled = taxCollectionEnabled;
            return this;
        }

        @Override
        public _FinalStage trialPaymentMethodRequired(Boolean trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = Optional.ofNullable(trialPaymentMethodRequired);
            return this;
        }

        @Override
        @JsonSetter(value="trial_payment_method_required", nulls=Nulls.SKIP)
        public _FinalStage trialPaymentMethodRequired(Optional<Boolean> trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = trialPaymentMethodRequired;
            return this;
        }

        @Override
        public _FinalStage trialExpiryPlanPriceId(String trialExpiryPlanPriceId) {
            this.trialExpiryPlanPriceId = Optional.ofNullable(trialExpiryPlanPriceId);
            return this;
        }

        @Override
        @JsonSetter(value="trial_expiry_plan_price_id", nulls=Nulls.SKIP)
        public _FinalStage trialExpiryPlanPriceId(Optional<String> trialExpiryPlanPriceId) {
            this.trialExpiryPlanPriceId = trialExpiryPlanPriceId;
            return this;
        }

        @Override
        public _FinalStage trialExpiryPlanPrice(BillingPriceResponseData trialExpiryPlanPrice) {
            this.trialExpiryPlanPrice = Optional.ofNullable(trialExpiryPlanPrice);
            return this;
        }

        @Override
        @JsonSetter(value="trial_expiry_plan_price", nulls=Nulls.SKIP)
        public _FinalStage trialExpiryPlanPrice(Optional<BillingPriceResponseData> trialExpiryPlanPrice) {
            this.trialExpiryPlanPrice = trialExpiryPlanPrice;
            return this;
        }

        @Override
        public _FinalStage trialExpiryPlanId(String trialExpiryPlanId) {
            this.trialExpiryPlanId = Optional.ofNullable(trialExpiryPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="trial_expiry_plan_id", nulls=Nulls.SKIP)
        public _FinalStage trialExpiryPlanId(Optional<String> trialExpiryPlanId) {
            this.trialExpiryPlanId = trialExpiryPlanId;
            return this;
        }

        @Override
        public _FinalStage trialExpiryPlan(PlanGroupPlanDetailResponseData trialExpiryPlan) {
            this.trialExpiryPlan = Optional.ofNullable(trialExpiryPlan);
            return this;
        }

        @Override
        @JsonSetter(value="trial_expiry_plan", nulls=Nulls.SKIP)
        public _FinalStage trialExpiryPlan(Optional<PlanGroupPlanDetailResponseData> trialExpiryPlan) {
            this.trialExpiryPlan = trialExpiryPlan;
            return this;
        }

        @Override
        public _FinalStage trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @Override
        @JsonSetter(value="trial_days", nulls=Nulls.SKIP)
        public _FinalStage trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        @Override
        public _FinalStage addAllPlans(List<PlanGroupPlanDetailResponseData> plans) {
            if (plans != null) {
                this.plans.addAll(plans);
            }
            return this;
        }

        @Override
        public _FinalStage addPlans(PlanGroupPlanDetailResponseData plans) {
            this.plans.add(plans);
            return this;
        }

        @Override
        @JsonSetter(value="plans", nulls=Nulls.SKIP)
        public _FinalStage plans(List<PlanGroupPlanDetailResponseData> plans) {
            this.plans.clear();
            if (plans != null) {
                this.plans.addAll(plans);
            }
            return this;
        }

        @Override
        public _FinalStage addAllOrderedPlanList(List<PlanGroupPlanEntitlementsOrder> orderedPlanList) {
            if (orderedPlanList != null) {
                this.orderedPlanList.addAll(orderedPlanList);
            }
            return this;
        }

        @Override
        public _FinalStage addOrderedPlanList(PlanGroupPlanEntitlementsOrder orderedPlanList) {
            this.orderedPlanList.add(orderedPlanList);
            return this;
        }

        @Override
        @JsonSetter(value="ordered_plan_list", nulls=Nulls.SKIP)
        public _FinalStage orderedPlanList(List<PlanGroupPlanEntitlementsOrder> orderedPlanList) {
            this.orderedPlanList.clear();
            if (orderedPlanList != null) {
                this.orderedPlanList.addAll(orderedPlanList);
            }
            return this;
        }

        @Override
        public _FinalStage addAllOrderedBundleList(List<PlanGroupBundleOrder> orderedBundleList) {
            if (orderedBundleList != null) {
                this.orderedBundleList.addAll(orderedBundleList);
            }
            return this;
        }

        @Override
        public _FinalStage addOrderedBundleList(PlanGroupBundleOrder orderedBundleList) {
            this.orderedBundleList.add(orderedBundleList);
            return this;
        }

        @Override
        @JsonSetter(value="ordered_bundle_list", nulls=Nulls.SKIP)
        public _FinalStage orderedBundleList(List<PlanGroupBundleOrder> orderedBundleList) {
            this.orderedBundleList.clear();
            if (orderedBundleList != null) {
                this.orderedBundleList.addAll(orderedBundleList);
            }
            return this;
        }

        @Override
        public _FinalStage addAllOrderedAddOnList(List<PlanGroupPlanEntitlementsOrder> orderedAddOnList) {
            if (orderedAddOnList != null) {
                this.orderedAddOnList.addAll(orderedAddOnList);
            }
            return this;
        }

        @Override
        public _FinalStage addOrderedAddOnList(PlanGroupPlanEntitlementsOrder orderedAddOnList) {
            this.orderedAddOnList.add(orderedAddOnList);
            return this;
        }

        @Override
        @JsonSetter(value="ordered_add_on_list", nulls=Nulls.SKIP)
        public _FinalStage orderedAddOnList(List<PlanGroupPlanEntitlementsOrder> orderedAddOnList) {
            this.orderedAddOnList.clear();
            if (orderedAddOnList != null) {
                this.orderedAddOnList.addAll(orderedAddOnList);
            }
            return this;
        }

        @Override
        public _FinalStage initialPlanPriceId(String initialPlanPriceId) {
            this.initialPlanPriceId = Optional.ofNullable(initialPlanPriceId);
            return this;
        }

        @Override
        @JsonSetter(value="initial_plan_price_id", nulls=Nulls.SKIP)
        public _FinalStage initialPlanPriceId(Optional<String> initialPlanPriceId) {
            this.initialPlanPriceId = initialPlanPriceId;
            return this;
        }

        @Override
        public _FinalStage initialPlanPrice(BillingPriceResponseData initialPlanPrice) {
            this.initialPlanPrice = Optional.ofNullable(initialPlanPrice);
            return this;
        }

        @Override
        @JsonSetter(value="initial_plan_price", nulls=Nulls.SKIP)
        public _FinalStage initialPlanPrice(Optional<BillingPriceResponseData> initialPlanPrice) {
            this.initialPlanPrice = initialPlanPrice;
            return this;
        }

        @Override
        public _FinalStage initialPlanId(String initialPlanId) {
            this.initialPlanId = Optional.ofNullable(initialPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="initial_plan_id", nulls=Nulls.SKIP)
        public _FinalStage initialPlanId(Optional<String> initialPlanId) {
            this.initialPlanId = initialPlanId;
            return this;
        }

        @Override
        public _FinalStage initialPlan(PlanGroupPlanDetailResponseData initialPlan) {
            this.initialPlan = Optional.ofNullable(initialPlan);
            return this;
        }

        @Override
        @JsonSetter(value="initial_plan", nulls=Nulls.SKIP)
        public _FinalStage initialPlan(Optional<PlanGroupPlanDetailResponseData> initialPlan) {
            this.initialPlan = initialPlan;
            return this;
        }

        @Override
        public _FinalStage fallbackPlanId(String fallbackPlanId) {
            this.fallbackPlanId = Optional.ofNullable(fallbackPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="fallback_plan_id", nulls=Nulls.SKIP)
        public _FinalStage fallbackPlanId(Optional<String> fallbackPlanId) {
            this.fallbackPlanId = fallbackPlanId;
            return this;
        }

        @Override
        public _FinalStage fallbackPlan(PlanGroupPlanDetailResponseData fallbackPlan) {
            this.fallbackPlan = Optional.ofNullable(fallbackPlan);
            return this;
        }

        @Override
        @JsonSetter(value="fallback_plan", nulls=Nulls.SKIP)
        public _FinalStage fallbackPlan(Optional<PlanGroupPlanDetailResponseData> fallbackPlan) {
            this.fallbackPlan = fallbackPlan;
            return this;
        }

        @Override
        public _FinalStage defaultPlanId(String defaultPlanId) {
            this.defaultPlanId = Optional.ofNullable(defaultPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="default_plan_id", nulls=Nulls.SKIP)
        public _FinalStage defaultPlanId(Optional<String> defaultPlanId) {
            this.defaultPlanId = defaultPlanId;
            return this;
        }

        @Override
        public _FinalStage defaultPlan(PlanGroupPlanDetailResponseData defaultPlan) {
            this.defaultPlan = Optional.ofNullable(defaultPlan);
            return this;
        }

        @Override
        @JsonSetter(value="default_plan", nulls=Nulls.SKIP)
        public _FinalStage defaultPlan(Optional<PlanGroupPlanDetailResponseData> defaultPlan) {
            this.defaultPlan = defaultPlan;
            return this;
        }

        @Override
        public _FinalStage customPlanId(String customPlanId) {
            this.customPlanId = Optional.ofNullable(customPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="custom_plan_id", nulls=Nulls.SKIP)
        public _FinalStage customPlanId(Optional<String> customPlanId) {
            this.customPlanId = customPlanId;
            return this;
        }

        @Override
        public _FinalStage customPlanConfig(CustomPlanViewConfigResponseData customPlanConfig) {
            this.customPlanConfig = Optional.ofNullable(customPlanConfig);
            return this;
        }

        @Override
        @JsonSetter(value="custom_plan_config", nulls=Nulls.SKIP)
        public _FinalStage customPlanConfig(Optional<CustomPlanViewConfigResponseData> customPlanConfig) {
            this.customPlanConfig = customPlanConfig;
            return this;
        }

        @Override
        public _FinalStage addAllAddOns(List<PlanGroupPlanDetailResponseData> addOns) {
            if (addOns != null) {
                this.addOns.addAll(addOns);
            }
            return this;
        }

        @Override
        public _FinalStage addAddOns(PlanGroupPlanDetailResponseData addOns) {
            this.addOns.add(addOns);
            return this;
        }

        @Override
        @JsonSetter(value="add_ons", nulls=Nulls.SKIP)
        public _FinalStage addOns(List<PlanGroupPlanDetailResponseData> addOns) {
            this.addOns.clear();
            if (addOns != null) {
                this.addOns.addAll(addOns);
            }
            return this;
        }

        @Override
        public PlanGroupDetailResponseData build() {
            return new PlanGroupDetailResponseData(this.addOns, this.checkoutSettings, this.customPlanConfig, this.customPlanId, this.defaultPlan, this.defaultPlanId, this.fallbackPlan, this.fallbackPlanId, this.id, this.initialPlan, this.initialPlanId, this.initialPlanPrice, this.initialPlanPriceId, this.orderedAddOnList, this.orderedBundleList, this.orderedPlanList, this.plans, this.preventDowngradesWhenOverLimit, this.showCredits, this.showPeriodToggle, this.showZeroPriceAsFree, this.syncCustomerBillingDetailsForTax, this.taxCollectionEnabled, this.trialDays, this.trialExpiryPlan, this.trialExpiryPlanId, this.trialExpiryPlanPrice, this.trialExpiryPlanPriceId, this.trialPaymentMethodRequired, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PlanGroupDetailResponseData build();

        public _FinalStage addOns(List<PlanGroupPlanDetailResponseData> var1);

        public _FinalStage addAddOns(PlanGroupPlanDetailResponseData var1);

        public _FinalStage addAllAddOns(List<PlanGroupPlanDetailResponseData> var1);

        public _FinalStage customPlanConfig(Optional<CustomPlanViewConfigResponseData> var1);

        public _FinalStage customPlanConfig(CustomPlanViewConfigResponseData var1);

        public _FinalStage customPlanId(Optional<String> var1);

        public _FinalStage customPlanId(String var1);

        public _FinalStage defaultPlan(Optional<PlanGroupPlanDetailResponseData> var1);

        public _FinalStage defaultPlan(PlanGroupPlanDetailResponseData var1);

        public _FinalStage defaultPlanId(Optional<String> var1);

        public _FinalStage defaultPlanId(String var1);

        public _FinalStage fallbackPlan(Optional<PlanGroupPlanDetailResponseData> var1);

        public _FinalStage fallbackPlan(PlanGroupPlanDetailResponseData var1);

        public _FinalStage fallbackPlanId(Optional<String> var1);

        public _FinalStage fallbackPlanId(String var1);

        public _FinalStage initialPlan(Optional<PlanGroupPlanDetailResponseData> var1);

        public _FinalStage initialPlan(PlanGroupPlanDetailResponseData var1);

        public _FinalStage initialPlanId(Optional<String> var1);

        public _FinalStage initialPlanId(String var1);

        public _FinalStage initialPlanPrice(Optional<BillingPriceResponseData> var1);

        public _FinalStage initialPlanPrice(BillingPriceResponseData var1);

        public _FinalStage initialPlanPriceId(Optional<String> var1);

        public _FinalStage initialPlanPriceId(String var1);

        public _FinalStage orderedAddOnList(List<PlanGroupPlanEntitlementsOrder> var1);

        public _FinalStage addOrderedAddOnList(PlanGroupPlanEntitlementsOrder var1);

        public _FinalStage addAllOrderedAddOnList(List<PlanGroupPlanEntitlementsOrder> var1);

        public _FinalStage orderedBundleList(List<PlanGroupBundleOrder> var1);

        public _FinalStage addOrderedBundleList(PlanGroupBundleOrder var1);

        public _FinalStage addAllOrderedBundleList(List<PlanGroupBundleOrder> var1);

        public _FinalStage orderedPlanList(List<PlanGroupPlanEntitlementsOrder> var1);

        public _FinalStage addOrderedPlanList(PlanGroupPlanEntitlementsOrder var1);

        public _FinalStage addAllOrderedPlanList(List<PlanGroupPlanEntitlementsOrder> var1);

        public _FinalStage plans(List<PlanGroupPlanDetailResponseData> var1);

        public _FinalStage addPlans(PlanGroupPlanDetailResponseData var1);

        public _FinalStage addAllPlans(List<PlanGroupPlanDetailResponseData> var1);

        public _FinalStage trialDays(Optional<Integer> var1);

        public _FinalStage trialDays(Integer var1);

        public _FinalStage trialExpiryPlan(Optional<PlanGroupPlanDetailResponseData> var1);

        public _FinalStage trialExpiryPlan(PlanGroupPlanDetailResponseData var1);

        public _FinalStage trialExpiryPlanId(Optional<String> var1);

        public _FinalStage trialExpiryPlanId(String var1);

        public _FinalStage trialExpiryPlanPrice(Optional<BillingPriceResponseData> var1);

        public _FinalStage trialExpiryPlanPrice(BillingPriceResponseData var1);

        public _FinalStage trialExpiryPlanPriceId(Optional<String> var1);

        public _FinalStage trialExpiryPlanPriceId(String var1);

        public _FinalStage trialPaymentMethodRequired(Optional<Boolean> var1);

        public _FinalStage trialPaymentMethodRequired(Boolean var1);
    }

    public static interface TaxCollectionEnabledStage {
        public _FinalStage taxCollectionEnabled(boolean var1);
    }

    public static interface SyncCustomerBillingDetailsForTaxStage {
        public TaxCollectionEnabledStage syncCustomerBillingDetailsForTax(boolean var1);
    }

    public static interface ShowZeroPriceAsFreeStage {
        public SyncCustomerBillingDetailsForTaxStage showZeroPriceAsFree(boolean var1);
    }

    public static interface ShowPeriodToggleStage {
        public ShowZeroPriceAsFreeStage showPeriodToggle(boolean var1);
    }

    public static interface ShowCreditsStage {
        public ShowPeriodToggleStage showCredits(boolean var1);
    }

    public static interface PreventDowngradesWhenOverLimitStage {
        public ShowCreditsStage preventDowngradesWhenOverLimit(boolean var1);
    }

    public static interface IdStage {
        public PreventDowngradesWhenOverLimitStage id(@NotNull String var1);
    }

    public static interface CheckoutSettingsStage {
        public IdStage checkoutSettings(@NotNull CheckoutSettingsResponseData var1);

        public Builder from(PlanGroupDetailResponseData var1);
    }
}

