/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingPlanCreditGrantResponseData;
import com.schematic.api.types.BillingPriceResponseData;
import com.schematic.api.types.BillingProductDetailResponseData;
import com.schematic.api.types.CustomPlanViewConfigResponseData;
import com.schematic.api.types.FeatureDetailResponseData;
import com.schematic.api.types.PlanEntitlementResponseData;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PlanGroupPlanDetailResponseData {
    private final Optional<String> audienceType;
    private final Optional<BillingProductDetailResponseData> billingProduct;
    private final String chargeType;
    private final int companyCount;
    private final List<String> compatiblePlanIds;
    private final String controlledBy;
    private final OffsetDateTime createdAt;
    private final Optional<CustomPlanViewConfigResponseData> customPlanConfig;
    private final String description;
    private final List<PlanEntitlementResponseData> entitlements;
    private final List<FeatureDetailResponseData> features;
    private final String icon;
    private final String id;
    private final Optional<List<BillingPlanCreditGrantResponseData>> includedCreditGrants;
    private final boolean isCustom;
    private final boolean isDefault;
    private final boolean isFree;
    private final boolean isTrialable;
    private final Optional<BillingPriceResponseData> monthlyPrice;
    private final String name;
    private final Optional<BillingPriceResponseData> oneTimePrice;
    private final String planType;
    private final Optional<Integer> trialDays;
    private final OffsetDateTime updatedAt;
    private final Optional<BillingPriceResponseData> yearlyPrice;
    private final Map<String, Object> additionalProperties;

    private PlanGroupPlanDetailResponseData(Optional<String> audienceType, Optional<BillingProductDetailResponseData> billingProduct, String chargeType, int companyCount, List<String> compatiblePlanIds, String controlledBy, OffsetDateTime createdAt, Optional<CustomPlanViewConfigResponseData> customPlanConfig, String description, List<PlanEntitlementResponseData> entitlements, List<FeatureDetailResponseData> features, String icon, String id, Optional<List<BillingPlanCreditGrantResponseData>> includedCreditGrants, boolean isCustom, boolean isDefault, boolean isFree, boolean isTrialable, Optional<BillingPriceResponseData> monthlyPrice, String name, Optional<BillingPriceResponseData> oneTimePrice, String planType, Optional<Integer> trialDays, OffsetDateTime updatedAt, Optional<BillingPriceResponseData> yearlyPrice, Map<String, Object> additionalProperties) {
        this.audienceType = audienceType;
        this.billingProduct = billingProduct;
        this.chargeType = chargeType;
        this.companyCount = companyCount;
        this.compatiblePlanIds = compatiblePlanIds;
        this.controlledBy = controlledBy;
        this.createdAt = createdAt;
        this.customPlanConfig = customPlanConfig;
        this.description = description;
        this.entitlements = entitlements;
        this.features = features;
        this.icon = icon;
        this.id = id;
        this.includedCreditGrants = includedCreditGrants;
        this.isCustom = isCustom;
        this.isDefault = isDefault;
        this.isFree = isFree;
        this.isTrialable = isTrialable;
        this.monthlyPrice = monthlyPrice;
        this.name = name;
        this.oneTimePrice = oneTimePrice;
        this.planType = planType;
        this.trialDays = trialDays;
        this.updatedAt = updatedAt;
        this.yearlyPrice = yearlyPrice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="audience_type")
    public Optional<String> getAudienceType() {
        return this.audienceType;
    }

    @JsonProperty(value="billing_product")
    public Optional<BillingProductDetailResponseData> getBillingProduct() {
        return this.billingProduct;
    }

    @JsonProperty(value="charge_type")
    public String getChargeType() {
        return this.chargeType;
    }

    @JsonProperty(value="company_count")
    public int getCompanyCount() {
        return this.companyCount;
    }

    @JsonProperty(value="compatible_plan_ids")
    public List<String> getCompatiblePlanIds() {
        return this.compatiblePlanIds;
    }

    @JsonProperty(value="controlled_by")
    public String getControlledBy() {
        return this.controlledBy;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="custom_plan_config")
    public Optional<CustomPlanViewConfigResponseData> getCustomPlanConfig() {
        return this.customPlanConfig;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="entitlements")
    public List<PlanEntitlementResponseData> getEntitlements() {
        return this.entitlements;
    }

    @JsonProperty(value="features")
    public List<FeatureDetailResponseData> getFeatures() {
        return this.features;
    }

    @JsonProperty(value="icon")
    public String getIcon() {
        return this.icon;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="included_credit_grants")
    public Optional<List<BillingPlanCreditGrantResponseData>> getIncludedCreditGrants() {
        return this.includedCreditGrants;
    }

    @JsonProperty(value="is_custom")
    public boolean getIsCustom() {
        return this.isCustom;
    }

    @JsonProperty(value="is_default")
    public boolean getIsDefault() {
        return this.isDefault;
    }

    @JsonProperty(value="is_free")
    public boolean getIsFree() {
        return this.isFree;
    }

    @JsonProperty(value="is_trialable")
    public boolean getIsTrialable() {
        return this.isTrialable;
    }

    @JsonProperty(value="monthly_price")
    public Optional<BillingPriceResponseData> getMonthlyPrice() {
        return this.monthlyPrice;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="one_time_price")
    public Optional<BillingPriceResponseData> getOneTimePrice() {
        return this.oneTimePrice;
    }

    @JsonProperty(value="plan_type")
    public String getPlanType() {
        return this.planType;
    }

    @JsonProperty(value="trial_days")
    public Optional<Integer> getTrialDays() {
        return this.trialDays;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="yearly_price")
    public Optional<BillingPriceResponseData> getYearlyPrice() {
        return this.yearlyPrice;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PlanGroupPlanDetailResponseData && this.equalTo((PlanGroupPlanDetailResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanGroupPlanDetailResponseData other) {
        return this.audienceType.equals(other.audienceType) && this.billingProduct.equals(other.billingProduct) && this.chargeType.equals(other.chargeType) && this.companyCount == other.companyCount && this.compatiblePlanIds.equals(other.compatiblePlanIds) && this.controlledBy.equals(other.controlledBy) && this.createdAt.equals(other.createdAt) && this.customPlanConfig.equals(other.customPlanConfig) && this.description.equals(other.description) && this.entitlements.equals(other.entitlements) && this.features.equals(other.features) && this.icon.equals(other.icon) && this.id.equals(other.id) && this.includedCreditGrants.equals(other.includedCreditGrants) && this.isCustom == other.isCustom && this.isDefault == other.isDefault && this.isFree == other.isFree && this.isTrialable == other.isTrialable && this.monthlyPrice.equals(other.monthlyPrice) && this.name.equals(other.name) && this.oneTimePrice.equals(other.oneTimePrice) && this.planType.equals(other.planType) && this.trialDays.equals(other.trialDays) && this.updatedAt.equals(other.updatedAt) && this.yearlyPrice.equals(other.yearlyPrice);
    }

    public int hashCode() {
        return Objects.hash(this.audienceType, this.billingProduct, this.chargeType, this.companyCount, this.compatiblePlanIds, this.controlledBy, this.createdAt, this.customPlanConfig, this.description, this.entitlements, this.features, this.icon, this.id, this.includedCreditGrants, this.isCustom, this.isDefault, this.isFree, this.isTrialable, this.monthlyPrice, this.name, this.oneTimePrice, this.planType, this.trialDays, this.updatedAt, this.yearlyPrice);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ChargeTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ChargeTypeStage,
    CompanyCountStage,
    ControlledByStage,
    CreatedAtStage,
    DescriptionStage,
    IconStage,
    IdStage,
    IsCustomStage,
    IsDefaultStage,
    IsFreeStage,
    IsTrialableStage,
    NameStage,
    PlanTypeStage,
    UpdatedAtStage,
    _FinalStage {
        private String chargeType;
        private int companyCount;
        private String controlledBy;
        private OffsetDateTime createdAt;
        private String description;
        private String icon;
        private String id;
        private boolean isCustom;
        private boolean isDefault;
        private boolean isFree;
        private boolean isTrialable;
        private String name;
        private String planType;
        private OffsetDateTime updatedAt;
        private Optional<BillingPriceResponseData> yearlyPrice = Optional.empty();
        private Optional<Integer> trialDays = Optional.empty();
        private Optional<BillingPriceResponseData> oneTimePrice = Optional.empty();
        private Optional<BillingPriceResponseData> monthlyPrice = Optional.empty();
        private Optional<List<BillingPlanCreditGrantResponseData>> includedCreditGrants = Optional.empty();
        private List<FeatureDetailResponseData> features = new ArrayList<FeatureDetailResponseData>();
        private List<PlanEntitlementResponseData> entitlements = new ArrayList<PlanEntitlementResponseData>();
        private Optional<CustomPlanViewConfigResponseData> customPlanConfig = Optional.empty();
        private List<String> compatiblePlanIds = new ArrayList<String>();
        private Optional<BillingProductDetailResponseData> billingProduct = Optional.empty();
        private Optional<String> audienceType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PlanGroupPlanDetailResponseData other) {
            this.audienceType(other.getAudienceType());
            this.billingProduct(other.getBillingProduct());
            this.chargeType(other.getChargeType());
            this.companyCount(other.getCompanyCount());
            this.compatiblePlanIds(other.getCompatiblePlanIds());
            this.controlledBy(other.getControlledBy());
            this.createdAt(other.getCreatedAt());
            this.customPlanConfig(other.getCustomPlanConfig());
            this.description(other.getDescription());
            this.entitlements(other.getEntitlements());
            this.features(other.getFeatures());
            this.icon(other.getIcon());
            this.id(other.getId());
            this.includedCreditGrants(other.getIncludedCreditGrants());
            this.isCustom(other.getIsCustom());
            this.isDefault(other.getIsDefault());
            this.isFree(other.getIsFree());
            this.isTrialable(other.getIsTrialable());
            this.monthlyPrice(other.getMonthlyPrice());
            this.name(other.getName());
            this.oneTimePrice(other.getOneTimePrice());
            this.planType(other.getPlanType());
            this.trialDays(other.getTrialDays());
            this.updatedAt(other.getUpdatedAt());
            this.yearlyPrice(other.getYearlyPrice());
            return this;
        }

        @Override
        @JsonSetter(value="charge_type")
        public CompanyCountStage chargeType(@NotNull String chargeType) {
            this.chargeType = Objects.requireNonNull(chargeType, "chargeType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="company_count")
        public ControlledByStage companyCount(int companyCount) {
            this.companyCount = companyCount;
            return this;
        }

        @Override
        @JsonSetter(value="controlled_by")
        public CreatedAtStage controlledBy(@NotNull String controlledBy) {
            this.controlledBy = Objects.requireNonNull(controlledBy, "controlledBy must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public DescriptionStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public IconStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="icon")
        public IdStage icon(@NotNull String icon) {
            this.icon = Objects.requireNonNull(icon, "icon must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public IsCustomStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="is_custom")
        public IsDefaultStage isCustom(boolean isCustom) {
            this.isCustom = isCustom;
            return this;
        }

        @Override
        @JsonSetter(value="is_default")
        public IsFreeStage isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        @Override
        @JsonSetter(value="is_free")
        public IsTrialableStage isFree(boolean isFree) {
            this.isFree = isFree;
            return this;
        }

        @Override
        @JsonSetter(value="is_trialable")
        public NameStage isTrialable(boolean isTrialable) {
            this.isTrialable = isTrialable;
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PlanTypeStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="plan_type")
        public UpdatedAtStage planType(@NotNull String planType) {
            this.planType = Objects.requireNonNull(planType, "planType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage yearlyPrice(BillingPriceResponseData yearlyPrice) {
            this.yearlyPrice = Optional.ofNullable(yearlyPrice);
            return this;
        }

        @Override
        @JsonSetter(value="yearly_price", nulls=Nulls.SKIP)
        public _FinalStage yearlyPrice(Optional<BillingPriceResponseData> yearlyPrice) {
            this.yearlyPrice = yearlyPrice;
            return this;
        }

        @Override
        public _FinalStage trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @Override
        @JsonSetter(value="trial_days", nulls=Nulls.SKIP)
        public _FinalStage trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        @Override
        public _FinalStage oneTimePrice(BillingPriceResponseData oneTimePrice) {
            this.oneTimePrice = Optional.ofNullable(oneTimePrice);
            return this;
        }

        @Override
        @JsonSetter(value="one_time_price", nulls=Nulls.SKIP)
        public _FinalStage oneTimePrice(Optional<BillingPriceResponseData> oneTimePrice) {
            this.oneTimePrice = oneTimePrice;
            return this;
        }

        @Override
        public _FinalStage monthlyPrice(BillingPriceResponseData monthlyPrice) {
            this.monthlyPrice = Optional.ofNullable(monthlyPrice);
            return this;
        }

        @Override
        @JsonSetter(value="monthly_price", nulls=Nulls.SKIP)
        public _FinalStage monthlyPrice(Optional<BillingPriceResponseData> monthlyPrice) {
            this.monthlyPrice = monthlyPrice;
            return this;
        }

        @Override
        public _FinalStage includedCreditGrants(List<BillingPlanCreditGrantResponseData> includedCreditGrants) {
            this.includedCreditGrants = Optional.ofNullable(includedCreditGrants);
            return this;
        }

        @Override
        @JsonSetter(value="included_credit_grants", nulls=Nulls.SKIP)
        public _FinalStage includedCreditGrants(Optional<List<BillingPlanCreditGrantResponseData>> includedCreditGrants) {
            this.includedCreditGrants = includedCreditGrants;
            return this;
        }

        @Override
        public _FinalStage addAllFeatures(List<FeatureDetailResponseData> features) {
            if (features != null) {
                this.features.addAll(features);
            }
            return this;
        }

        @Override
        public _FinalStage addFeatures(FeatureDetailResponseData features) {
            this.features.add(features);
            return this;
        }

        @Override
        @JsonSetter(value="features", nulls=Nulls.SKIP)
        public _FinalStage features(List<FeatureDetailResponseData> features) {
            this.features.clear();
            if (features != null) {
                this.features.addAll(features);
            }
            return this;
        }

        @Override
        public _FinalStage addAllEntitlements(List<PlanEntitlementResponseData> entitlements) {
            if (entitlements != null) {
                this.entitlements.addAll(entitlements);
            }
            return this;
        }

        @Override
        public _FinalStage addEntitlements(PlanEntitlementResponseData entitlements) {
            this.entitlements.add(entitlements);
            return this;
        }

        @Override
        @JsonSetter(value="entitlements", nulls=Nulls.SKIP)
        public _FinalStage entitlements(List<PlanEntitlementResponseData> entitlements) {
            this.entitlements.clear();
            if (entitlements != null) {
                this.entitlements.addAll(entitlements);
            }
            return this;
        }

        @Override
        public _FinalStage customPlanConfig(CustomPlanViewConfigResponseData customPlanConfig) {
            this.customPlanConfig = Optional.ofNullable(customPlanConfig);
            return this;
        }

        @Override
        @JsonSetter(value="custom_plan_config", nulls=Nulls.SKIP)
        public _FinalStage customPlanConfig(Optional<CustomPlanViewConfigResponseData> customPlanConfig) {
            this.customPlanConfig = customPlanConfig;
            return this;
        }

        @Override
        public _FinalStage addAllCompatiblePlanIds(List<String> compatiblePlanIds) {
            if (compatiblePlanIds != null) {
                this.compatiblePlanIds.addAll(compatiblePlanIds);
            }
            return this;
        }

        @Override
        public _FinalStage addCompatiblePlanIds(String compatiblePlanIds) {
            this.compatiblePlanIds.add(compatiblePlanIds);
            return this;
        }

        @Override
        @JsonSetter(value="compatible_plan_ids", nulls=Nulls.SKIP)
        public _FinalStage compatiblePlanIds(List<String> compatiblePlanIds) {
            this.compatiblePlanIds.clear();
            if (compatiblePlanIds != null) {
                this.compatiblePlanIds.addAll(compatiblePlanIds);
            }
            return this;
        }

        @Override
        public _FinalStage billingProduct(BillingProductDetailResponseData billingProduct) {
            this.billingProduct = Optional.ofNullable(billingProduct);
            return this;
        }

        @Override
        @JsonSetter(value="billing_product", nulls=Nulls.SKIP)
        public _FinalStage billingProduct(Optional<BillingProductDetailResponseData> billingProduct) {
            this.billingProduct = billingProduct;
            return this;
        }

        @Override
        public _FinalStage audienceType(String audienceType) {
            this.audienceType = Optional.ofNullable(audienceType);
            return this;
        }

        @Override
        @JsonSetter(value="audience_type", nulls=Nulls.SKIP)
        public _FinalStage audienceType(Optional<String> audienceType) {
            this.audienceType = audienceType;
            return this;
        }

        @Override
        public PlanGroupPlanDetailResponseData build() {
            return new PlanGroupPlanDetailResponseData(this.audienceType, this.billingProduct, this.chargeType, this.companyCount, this.compatiblePlanIds, this.controlledBy, this.createdAt, this.customPlanConfig, this.description, this.entitlements, this.features, this.icon, this.id, this.includedCreditGrants, this.isCustom, this.isDefault, this.isFree, this.isTrialable, this.monthlyPrice, this.name, this.oneTimePrice, this.planType, this.trialDays, this.updatedAt, this.yearlyPrice, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PlanGroupPlanDetailResponseData build();

        public _FinalStage audienceType(Optional<String> var1);

        public _FinalStage audienceType(String var1);

        public _FinalStage billingProduct(Optional<BillingProductDetailResponseData> var1);

        public _FinalStage billingProduct(BillingProductDetailResponseData var1);

        public _FinalStage compatiblePlanIds(List<String> var1);

        public _FinalStage addCompatiblePlanIds(String var1);

        public _FinalStage addAllCompatiblePlanIds(List<String> var1);

        public _FinalStage customPlanConfig(Optional<CustomPlanViewConfigResponseData> var1);

        public _FinalStage customPlanConfig(CustomPlanViewConfigResponseData var1);

        public _FinalStage entitlements(List<PlanEntitlementResponseData> var1);

        public _FinalStage addEntitlements(PlanEntitlementResponseData var1);

        public _FinalStage addAllEntitlements(List<PlanEntitlementResponseData> var1);

        public _FinalStage features(List<FeatureDetailResponseData> var1);

        public _FinalStage addFeatures(FeatureDetailResponseData var1);

        public _FinalStage addAllFeatures(List<FeatureDetailResponseData> var1);

        public _FinalStage includedCreditGrants(Optional<List<BillingPlanCreditGrantResponseData>> var1);

        public _FinalStage includedCreditGrants(List<BillingPlanCreditGrantResponseData> var1);

        public _FinalStage monthlyPrice(Optional<BillingPriceResponseData> var1);

        public _FinalStage monthlyPrice(BillingPriceResponseData var1);

        public _FinalStage oneTimePrice(Optional<BillingPriceResponseData> var1);

        public _FinalStage oneTimePrice(BillingPriceResponseData var1);

        public _FinalStage trialDays(Optional<Integer> var1);

        public _FinalStage trialDays(Integer var1);

        public _FinalStage yearlyPrice(Optional<BillingPriceResponseData> var1);

        public _FinalStage yearlyPrice(BillingPriceResponseData var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface PlanTypeStage {
        public UpdatedAtStage planType(@NotNull String var1);
    }

    public static interface NameStage {
        public PlanTypeStage name(@NotNull String var1);
    }

    public static interface IsTrialableStage {
        public NameStage isTrialable(boolean var1);
    }

    public static interface IsFreeStage {
        public IsTrialableStage isFree(boolean var1);
    }

    public static interface IsDefaultStage {
        public IsFreeStage isDefault(boolean var1);
    }

    public static interface IsCustomStage {
        public IsDefaultStage isCustom(boolean var1);
    }

    public static interface IdStage {
        public IsCustomStage id(@NotNull String var1);
    }

    public static interface IconStage {
        public IdStage icon(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public IconStage description(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public DescriptionStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface ControlledByStage {
        public CreatedAtStage controlledBy(@NotNull String var1);
    }

    public static interface CompanyCountStage {
        public ControlledByStage companyCount(int var1);
    }

    public static interface ChargeTypeStage {
        public CompanyCountStage chargeType(@NotNull String var1);

        public Builder from(PlanGroupPlanDetailResponseData var1);
    }
}

