/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.PlanEntitlementsOrder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PlanGroupPlanEntitlementsOrder {
    private final Optional<List<PlanEntitlementsOrder>> entitlements;
    private final String planId;
    private final Map<String, Object> additionalProperties;

    private PlanGroupPlanEntitlementsOrder(Optional<List<PlanEntitlementsOrder>> entitlements, String planId, Map<String, Object> additionalProperties) {
        this.entitlements = entitlements;
        this.planId = planId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="entitlements")
    public Optional<List<PlanEntitlementsOrder>> getEntitlements() {
        return this.entitlements;
    }

    @JsonProperty(value="plan_id")
    public String getPlanId() {
        return this.planId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PlanGroupPlanEntitlementsOrder && this.equalTo((PlanGroupPlanEntitlementsOrder)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanGroupPlanEntitlementsOrder other) {
        return this.entitlements.equals(other.entitlements) && this.planId.equals(other.planId);
    }

    public int hashCode() {
        return Objects.hash(this.entitlements, this.planId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PlanIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PlanIdStage,
    _FinalStage {
        private String planId;
        private Optional<List<PlanEntitlementsOrder>> entitlements = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PlanGroupPlanEntitlementsOrder other) {
            this.entitlements(other.getEntitlements());
            this.planId(other.getPlanId());
            return this;
        }

        @Override
        @JsonSetter(value="plan_id")
        public _FinalStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @Override
        public _FinalStage entitlements(List<PlanEntitlementsOrder> entitlements) {
            this.entitlements = Optional.ofNullable(entitlements);
            return this;
        }

        @Override
        @JsonSetter(value="entitlements", nulls=Nulls.SKIP)
        public _FinalStage entitlements(Optional<List<PlanEntitlementsOrder>> entitlements) {
            this.entitlements = entitlements;
            return this;
        }

        @Override
        public PlanGroupPlanEntitlementsOrder build() {
            return new PlanGroupPlanEntitlementsOrder(this.entitlements, this.planId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PlanGroupPlanEntitlementsOrder build();

        public _FinalStage entitlements(Optional<List<PlanEntitlementsOrder>> var1);

        public _FinalStage entitlements(List<PlanEntitlementsOrder> var1);
    }

    public static interface PlanIdStage {
        public _FinalStage planId(@NotNull String var1);

        public Builder from(PlanGroupPlanEntitlementsOrder var1);
    }
}

