/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.CheckoutSettingsResponseData;
import com.schematic.api.types.CompatiblePlansResponseData;
import com.schematic.api.types.OrderedPlansInGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PlanGroupResponseData {
    private final List<CompatiblePlansResponseData> addOnCompatibilities;
    private final List<String> addOnIds;
    private final CheckoutSettingsResponseData checkoutSettings;
    private final Optional<String> defaultPlanId;
    private final Optional<String> fallbackPlanId;
    private final String id;
    private final Optional<String> initialPlanId;
    private final Optional<String> initialPlanPriceId;
    private final List<OrderedPlansInGroup> orderedAddOnIds;
    private final List<OrderedPlansInGroup> planIds;
    private final boolean preventDowngradesWhenOverLimit;
    private final boolean showCredits;
    private final boolean showPeriodToggle;
    private final boolean showZeroPriceAsFree;
    private final boolean syncCustomerBillingDetailsForTax;
    private final boolean taxCollectionEnabled;
    private final Optional<Integer> trialDays;
    private final Optional<String> trialExpiryPlanId;
    private final Optional<String> trialExpiryPlanPriceId;
    private final Optional<Boolean> trialPaymentMethodRequired;
    private final Map<String, Object> additionalProperties;

    private PlanGroupResponseData(List<CompatiblePlansResponseData> addOnCompatibilities, List<String> addOnIds, CheckoutSettingsResponseData checkoutSettings, Optional<String> defaultPlanId, Optional<String> fallbackPlanId, String id, Optional<String> initialPlanId, Optional<String> initialPlanPriceId, List<OrderedPlansInGroup> orderedAddOnIds, List<OrderedPlansInGroup> planIds, boolean preventDowngradesWhenOverLimit, boolean showCredits, boolean showPeriodToggle, boolean showZeroPriceAsFree, boolean syncCustomerBillingDetailsForTax, boolean taxCollectionEnabled, Optional<Integer> trialDays, Optional<String> trialExpiryPlanId, Optional<String> trialExpiryPlanPriceId, Optional<Boolean> trialPaymentMethodRequired, Map<String, Object> additionalProperties) {
        this.addOnCompatibilities = addOnCompatibilities;
        this.addOnIds = addOnIds;
        this.checkoutSettings = checkoutSettings;
        this.defaultPlanId = defaultPlanId;
        this.fallbackPlanId = fallbackPlanId;
        this.id = id;
        this.initialPlanId = initialPlanId;
        this.initialPlanPriceId = initialPlanPriceId;
        this.orderedAddOnIds = orderedAddOnIds;
        this.planIds = planIds;
        this.preventDowngradesWhenOverLimit = preventDowngradesWhenOverLimit;
        this.showCredits = showCredits;
        this.showPeriodToggle = showPeriodToggle;
        this.showZeroPriceAsFree = showZeroPriceAsFree;
        this.syncCustomerBillingDetailsForTax = syncCustomerBillingDetailsForTax;
        this.taxCollectionEnabled = taxCollectionEnabled;
        this.trialDays = trialDays;
        this.trialExpiryPlanId = trialExpiryPlanId;
        this.trialExpiryPlanPriceId = trialExpiryPlanPriceId;
        this.trialPaymentMethodRequired = trialPaymentMethodRequired;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="add_on_compatibilities")
    public List<CompatiblePlansResponseData> getAddOnCompatibilities() {
        return this.addOnCompatibilities;
    }

    @JsonProperty(value="add_on_ids")
    public List<String> getAddOnIds() {
        return this.addOnIds;
    }

    @JsonProperty(value="checkout_settings")
    public CheckoutSettingsResponseData getCheckoutSettings() {
        return this.checkoutSettings;
    }

    @JsonProperty(value="default_plan_id")
    public Optional<String> getDefaultPlanId() {
        return this.defaultPlanId;
    }

    @JsonProperty(value="fallback_plan_id")
    public Optional<String> getFallbackPlanId() {
        return this.fallbackPlanId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="initial_plan_id")
    public Optional<String> getInitialPlanId() {
        return this.initialPlanId;
    }

    @JsonProperty(value="initial_plan_price_id")
    public Optional<String> getInitialPlanPriceId() {
        return this.initialPlanPriceId;
    }

    @JsonProperty(value="ordered_add_on_ids")
    public List<OrderedPlansInGroup> getOrderedAddOnIds() {
        return this.orderedAddOnIds;
    }

    @JsonProperty(value="plan_ids")
    public List<OrderedPlansInGroup> getPlanIds() {
        return this.planIds;
    }

    @JsonProperty(value="prevent_downgrades_when_over_limit")
    public boolean getPreventDowngradesWhenOverLimit() {
        return this.preventDowngradesWhenOverLimit;
    }

    @JsonProperty(value="show_credits")
    public boolean getShowCredits() {
        return this.showCredits;
    }

    @JsonProperty(value="show_period_toggle")
    public boolean getShowPeriodToggle() {
        return this.showPeriodToggle;
    }

    @JsonProperty(value="show_zero_price_as_free")
    public boolean getShowZeroPriceAsFree() {
        return this.showZeroPriceAsFree;
    }

    @JsonProperty(value="sync_customer_billing_details_for_tax")
    public boolean getSyncCustomerBillingDetailsForTax() {
        return this.syncCustomerBillingDetailsForTax;
    }

    @JsonProperty(value="tax_collection_enabled")
    public boolean getTaxCollectionEnabled() {
        return this.taxCollectionEnabled;
    }

    @JsonProperty(value="trial_days")
    public Optional<Integer> getTrialDays() {
        return this.trialDays;
    }

    @JsonProperty(value="trial_expiry_plan_id")
    public Optional<String> getTrialExpiryPlanId() {
        return this.trialExpiryPlanId;
    }

    @JsonProperty(value="trial_expiry_plan_price_id")
    public Optional<String> getTrialExpiryPlanPriceId() {
        return this.trialExpiryPlanPriceId;
    }

    @JsonProperty(value="trial_payment_method_required")
    public Optional<Boolean> getTrialPaymentMethodRequired() {
        return this.trialPaymentMethodRequired;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PlanGroupResponseData && this.equalTo((PlanGroupResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanGroupResponseData other) {
        return this.addOnCompatibilities.equals(other.addOnCompatibilities) && this.addOnIds.equals(other.addOnIds) && this.checkoutSettings.equals(other.checkoutSettings) && this.defaultPlanId.equals(other.defaultPlanId) && this.fallbackPlanId.equals(other.fallbackPlanId) && this.id.equals(other.id) && this.initialPlanId.equals(other.initialPlanId) && this.initialPlanPriceId.equals(other.initialPlanPriceId) && this.orderedAddOnIds.equals(other.orderedAddOnIds) && this.planIds.equals(other.planIds) && this.preventDowngradesWhenOverLimit == other.preventDowngradesWhenOverLimit && this.showCredits == other.showCredits && this.showPeriodToggle == other.showPeriodToggle && this.showZeroPriceAsFree == other.showZeroPriceAsFree && this.syncCustomerBillingDetailsForTax == other.syncCustomerBillingDetailsForTax && this.taxCollectionEnabled == other.taxCollectionEnabled && this.trialDays.equals(other.trialDays) && this.trialExpiryPlanId.equals(other.trialExpiryPlanId) && this.trialExpiryPlanPriceId.equals(other.trialExpiryPlanPriceId) && this.trialPaymentMethodRequired.equals(other.trialPaymentMethodRequired);
    }

    public int hashCode() {
        return Objects.hash(this.addOnCompatibilities, this.addOnIds, this.checkoutSettings, this.defaultPlanId, this.fallbackPlanId, this.id, this.initialPlanId, this.initialPlanPriceId, this.orderedAddOnIds, this.planIds, this.preventDowngradesWhenOverLimit, this.showCredits, this.showPeriodToggle, this.showZeroPriceAsFree, this.syncCustomerBillingDetailsForTax, this.taxCollectionEnabled, this.trialDays, this.trialExpiryPlanId, this.trialExpiryPlanPriceId, this.trialPaymentMethodRequired);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CheckoutSettingsStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CheckoutSettingsStage,
    IdStage,
    PreventDowngradesWhenOverLimitStage,
    ShowCreditsStage,
    ShowPeriodToggleStage,
    ShowZeroPriceAsFreeStage,
    SyncCustomerBillingDetailsForTaxStage,
    TaxCollectionEnabledStage,
    _FinalStage {
        private CheckoutSettingsResponseData checkoutSettings;
        private String id;
        private boolean preventDowngradesWhenOverLimit;
        private boolean showCredits;
        private boolean showPeriodToggle;
        private boolean showZeroPriceAsFree;
        private boolean syncCustomerBillingDetailsForTax;
        private boolean taxCollectionEnabled;
        private Optional<Boolean> trialPaymentMethodRequired = Optional.empty();
        private Optional<String> trialExpiryPlanPriceId = Optional.empty();
        private Optional<String> trialExpiryPlanId = Optional.empty();
        private Optional<Integer> trialDays = Optional.empty();
        private List<OrderedPlansInGroup> planIds = new ArrayList<OrderedPlansInGroup>();
        private List<OrderedPlansInGroup> orderedAddOnIds = new ArrayList<OrderedPlansInGroup>();
        private Optional<String> initialPlanPriceId = Optional.empty();
        private Optional<String> initialPlanId = Optional.empty();
        private Optional<String> fallbackPlanId = Optional.empty();
        private Optional<String> defaultPlanId = Optional.empty();
        private List<String> addOnIds = new ArrayList<String>();
        private List<CompatiblePlansResponseData> addOnCompatibilities = new ArrayList<CompatiblePlansResponseData>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PlanGroupResponseData other) {
            this.addOnCompatibilities(other.getAddOnCompatibilities());
            this.addOnIds(other.getAddOnIds());
            this.checkoutSettings(other.getCheckoutSettings());
            this.defaultPlanId(other.getDefaultPlanId());
            this.fallbackPlanId(other.getFallbackPlanId());
            this.id(other.getId());
            this.initialPlanId(other.getInitialPlanId());
            this.initialPlanPriceId(other.getInitialPlanPriceId());
            this.orderedAddOnIds(other.getOrderedAddOnIds());
            this.planIds(other.getPlanIds());
            this.preventDowngradesWhenOverLimit(other.getPreventDowngradesWhenOverLimit());
            this.showCredits(other.getShowCredits());
            this.showPeriodToggle(other.getShowPeriodToggle());
            this.showZeroPriceAsFree(other.getShowZeroPriceAsFree());
            this.syncCustomerBillingDetailsForTax(other.getSyncCustomerBillingDetailsForTax());
            this.taxCollectionEnabled(other.getTaxCollectionEnabled());
            this.trialDays(other.getTrialDays());
            this.trialExpiryPlanId(other.getTrialExpiryPlanId());
            this.trialExpiryPlanPriceId(other.getTrialExpiryPlanPriceId());
            this.trialPaymentMethodRequired(other.getTrialPaymentMethodRequired());
            return this;
        }

        @Override
        @JsonSetter(value="checkout_settings")
        public IdStage checkoutSettings(@NotNull CheckoutSettingsResponseData checkoutSettings) {
            this.checkoutSettings = Objects.requireNonNull(checkoutSettings, "checkoutSettings must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public PreventDowngradesWhenOverLimitStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="prevent_downgrades_when_over_limit")
        public ShowCreditsStage preventDowngradesWhenOverLimit(boolean preventDowngradesWhenOverLimit) {
            this.preventDowngradesWhenOverLimit = preventDowngradesWhenOverLimit;
            return this;
        }

        @Override
        @JsonSetter(value="show_credits")
        public ShowPeriodToggleStage showCredits(boolean showCredits) {
            this.showCredits = showCredits;
            return this;
        }

        @Override
        @JsonSetter(value="show_period_toggle")
        public ShowZeroPriceAsFreeStage showPeriodToggle(boolean showPeriodToggle) {
            this.showPeriodToggle = showPeriodToggle;
            return this;
        }

        @Override
        @JsonSetter(value="show_zero_price_as_free")
        public SyncCustomerBillingDetailsForTaxStage showZeroPriceAsFree(boolean showZeroPriceAsFree) {
            this.showZeroPriceAsFree = showZeroPriceAsFree;
            return this;
        }

        @Override
        @JsonSetter(value="sync_customer_billing_details_for_tax")
        public TaxCollectionEnabledStage syncCustomerBillingDetailsForTax(boolean syncCustomerBillingDetailsForTax) {
            this.syncCustomerBillingDetailsForTax = syncCustomerBillingDetailsForTax;
            return this;
        }

        @Override
        @JsonSetter(value="tax_collection_enabled")
        public _FinalStage taxCollectionEnabled(boolean taxCollectionEnabled) {
            this.taxCollectionEnabled = taxCollectionEnabled;
            return this;
        }

        @Override
        public _FinalStage trialPaymentMethodRequired(Boolean trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = Optional.ofNullable(trialPaymentMethodRequired);
            return this;
        }

        @Override
        @JsonSetter(value="trial_payment_method_required", nulls=Nulls.SKIP)
        public _FinalStage trialPaymentMethodRequired(Optional<Boolean> trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = trialPaymentMethodRequired;
            return this;
        }

        @Override
        public _FinalStage trialExpiryPlanPriceId(String trialExpiryPlanPriceId) {
            this.trialExpiryPlanPriceId = Optional.ofNullable(trialExpiryPlanPriceId);
            return this;
        }

        @Override
        @JsonSetter(value="trial_expiry_plan_price_id", nulls=Nulls.SKIP)
        public _FinalStage trialExpiryPlanPriceId(Optional<String> trialExpiryPlanPriceId) {
            this.trialExpiryPlanPriceId = trialExpiryPlanPriceId;
            return this;
        }

        @Override
        public _FinalStage trialExpiryPlanId(String trialExpiryPlanId) {
            this.trialExpiryPlanId = Optional.ofNullable(trialExpiryPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="trial_expiry_plan_id", nulls=Nulls.SKIP)
        public _FinalStage trialExpiryPlanId(Optional<String> trialExpiryPlanId) {
            this.trialExpiryPlanId = trialExpiryPlanId;
            return this;
        }

        @Override
        public _FinalStage trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @Override
        @JsonSetter(value="trial_days", nulls=Nulls.SKIP)
        public _FinalStage trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        @Override
        public _FinalStage addAllPlanIds(List<OrderedPlansInGroup> planIds) {
            if (planIds != null) {
                this.planIds.addAll(planIds);
            }
            return this;
        }

        @Override
        public _FinalStage addPlanIds(OrderedPlansInGroup planIds) {
            this.planIds.add(planIds);
            return this;
        }

        @Override
        @JsonSetter(value="plan_ids", nulls=Nulls.SKIP)
        public _FinalStage planIds(List<OrderedPlansInGroup> planIds) {
            this.planIds.clear();
            if (planIds != null) {
                this.planIds.addAll(planIds);
            }
            return this;
        }

        @Override
        public _FinalStage addAllOrderedAddOnIds(List<OrderedPlansInGroup> orderedAddOnIds) {
            if (orderedAddOnIds != null) {
                this.orderedAddOnIds.addAll(orderedAddOnIds);
            }
            return this;
        }

        @Override
        public _FinalStage addOrderedAddOnIds(OrderedPlansInGroup orderedAddOnIds) {
            this.orderedAddOnIds.add(orderedAddOnIds);
            return this;
        }

        @Override
        @JsonSetter(value="ordered_add_on_ids", nulls=Nulls.SKIP)
        public _FinalStage orderedAddOnIds(List<OrderedPlansInGroup> orderedAddOnIds) {
            this.orderedAddOnIds.clear();
            if (orderedAddOnIds != null) {
                this.orderedAddOnIds.addAll(orderedAddOnIds);
            }
            return this;
        }

        @Override
        public _FinalStage initialPlanPriceId(String initialPlanPriceId) {
            this.initialPlanPriceId = Optional.ofNullable(initialPlanPriceId);
            return this;
        }

        @Override
        @JsonSetter(value="initial_plan_price_id", nulls=Nulls.SKIP)
        public _FinalStage initialPlanPriceId(Optional<String> initialPlanPriceId) {
            this.initialPlanPriceId = initialPlanPriceId;
            return this;
        }

        @Override
        public _FinalStage initialPlanId(String initialPlanId) {
            this.initialPlanId = Optional.ofNullable(initialPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="initial_plan_id", nulls=Nulls.SKIP)
        public _FinalStage initialPlanId(Optional<String> initialPlanId) {
            this.initialPlanId = initialPlanId;
            return this;
        }

        @Override
        public _FinalStage fallbackPlanId(String fallbackPlanId) {
            this.fallbackPlanId = Optional.ofNullable(fallbackPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="fallback_plan_id", nulls=Nulls.SKIP)
        public _FinalStage fallbackPlanId(Optional<String> fallbackPlanId) {
            this.fallbackPlanId = fallbackPlanId;
            return this;
        }

        @Override
        public _FinalStage defaultPlanId(String defaultPlanId) {
            this.defaultPlanId = Optional.ofNullable(defaultPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="default_plan_id", nulls=Nulls.SKIP)
        public _FinalStage defaultPlanId(Optional<String> defaultPlanId) {
            this.defaultPlanId = defaultPlanId;
            return this;
        }

        @Override
        public _FinalStage addAllAddOnIds(List<String> addOnIds) {
            if (addOnIds != null) {
                this.addOnIds.addAll(addOnIds);
            }
            return this;
        }

        @Override
        public _FinalStage addAddOnIds(String addOnIds) {
            this.addOnIds.add(addOnIds);
            return this;
        }

        @Override
        @JsonSetter(value="add_on_ids", nulls=Nulls.SKIP)
        public _FinalStage addOnIds(List<String> addOnIds) {
            this.addOnIds.clear();
            if (addOnIds != null) {
                this.addOnIds.addAll(addOnIds);
            }
            return this;
        }

        @Override
        public _FinalStage addAllAddOnCompatibilities(List<CompatiblePlansResponseData> addOnCompatibilities) {
            if (addOnCompatibilities != null) {
                this.addOnCompatibilities.addAll(addOnCompatibilities);
            }
            return this;
        }

        @Override
        public _FinalStage addAddOnCompatibilities(CompatiblePlansResponseData addOnCompatibilities) {
            this.addOnCompatibilities.add(addOnCompatibilities);
            return this;
        }

        @Override
        @JsonSetter(value="add_on_compatibilities", nulls=Nulls.SKIP)
        public _FinalStage addOnCompatibilities(List<CompatiblePlansResponseData> addOnCompatibilities) {
            this.addOnCompatibilities.clear();
            if (addOnCompatibilities != null) {
                this.addOnCompatibilities.addAll(addOnCompatibilities);
            }
            return this;
        }

        @Override
        public PlanGroupResponseData build() {
            return new PlanGroupResponseData(this.addOnCompatibilities, this.addOnIds, this.checkoutSettings, this.defaultPlanId, this.fallbackPlanId, this.id, this.initialPlanId, this.initialPlanPriceId, this.orderedAddOnIds, this.planIds, this.preventDowngradesWhenOverLimit, this.showCredits, this.showPeriodToggle, this.showZeroPriceAsFree, this.syncCustomerBillingDetailsForTax, this.taxCollectionEnabled, this.trialDays, this.trialExpiryPlanId, this.trialExpiryPlanPriceId, this.trialPaymentMethodRequired, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PlanGroupResponseData build();

        public _FinalStage addOnCompatibilities(List<CompatiblePlansResponseData> var1);

        public _FinalStage addAddOnCompatibilities(CompatiblePlansResponseData var1);

        public _FinalStage addAllAddOnCompatibilities(List<CompatiblePlansResponseData> var1);

        public _FinalStage addOnIds(List<String> var1);

        public _FinalStage addAddOnIds(String var1);

        public _FinalStage addAllAddOnIds(List<String> var1);

        public _FinalStage defaultPlanId(Optional<String> var1);

        public _FinalStage defaultPlanId(String var1);

        public _FinalStage fallbackPlanId(Optional<String> var1);

        public _FinalStage fallbackPlanId(String var1);

        public _FinalStage initialPlanId(Optional<String> var1);

        public _FinalStage initialPlanId(String var1);

        public _FinalStage initialPlanPriceId(Optional<String> var1);

        public _FinalStage initialPlanPriceId(String var1);

        public _FinalStage orderedAddOnIds(List<OrderedPlansInGroup> var1);

        public _FinalStage addOrderedAddOnIds(OrderedPlansInGroup var1);

        public _FinalStage addAllOrderedAddOnIds(List<OrderedPlansInGroup> var1);

        public _FinalStage planIds(List<OrderedPlansInGroup> var1);

        public _FinalStage addPlanIds(OrderedPlansInGroup var1);

        public _FinalStage addAllPlanIds(List<OrderedPlansInGroup> var1);

        public _FinalStage trialDays(Optional<Integer> var1);

        public _FinalStage trialDays(Integer var1);

        public _FinalStage trialExpiryPlanId(Optional<String> var1);

        public _FinalStage trialExpiryPlanId(String var1);

        public _FinalStage trialExpiryPlanPriceId(Optional<String> var1);

        public _FinalStage trialExpiryPlanPriceId(String var1);

        public _FinalStage trialPaymentMethodRequired(Optional<Boolean> var1);

        public _FinalStage trialPaymentMethodRequired(Boolean var1);
    }

    public static interface TaxCollectionEnabledStage {
        public _FinalStage taxCollectionEnabled(boolean var1);
    }

    public static interface SyncCustomerBillingDetailsForTaxStage {
        public TaxCollectionEnabledStage syncCustomerBillingDetailsForTax(boolean var1);
    }

    public static interface ShowZeroPriceAsFreeStage {
        public SyncCustomerBillingDetailsForTaxStage showZeroPriceAsFree(boolean var1);
    }

    public static interface ShowPeriodToggleStage {
        public ShowZeroPriceAsFreeStage showPeriodToggle(boolean var1);
    }

    public static interface ShowCreditsStage {
        public ShowPeriodToggleStage showCredits(boolean var1);
    }

    public static interface PreventDowngradesWhenOverLimitStage {
        public ShowCreditsStage preventDowngradesWhenOverLimit(boolean var1);
    }

    public static interface IdStage {
        public PreventDowngradesWhenOverLimitStage id(@NotNull String var1);
    }

    public static interface CheckoutSettingsStage {
        public IdStage checkoutSettings(@NotNull CheckoutSettingsResponseData var1);

        public Builder from(PlanGroupResponseData var1);
    }
}

