/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PlanIssueResponseData {
    private final String code;
    private final String description;
    private final Optional<String> detail;
    private final Optional<String> id;
    private final Map<String, Object> additionalProperties;

    private PlanIssueResponseData(String code, String description, Optional<String> detail, Optional<String> id, Map<String, Object> additionalProperties) {
        this.code = code;
        this.description = description;
        this.detail = detail;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="detail")
    public Optional<String> getDetail() {
        return this.detail;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PlanIssueResponseData && this.equalTo((PlanIssueResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanIssueResponseData other) {
        return this.code.equals(other.code) && this.description.equals(other.description) && this.detail.equals(other.detail) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.description, this.detail, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CodeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CodeStage,
    DescriptionStage,
    _FinalStage {
        private String code;
        private String description;
        private Optional<String> id = Optional.empty();
        private Optional<String> detail = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PlanIssueResponseData other) {
            this.code(other.getCode());
            this.description(other.getDescription());
            this.detail(other.getDetail());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="code")
        public DescriptionStage code(@NotNull String code) {
            this.code = Objects.requireNonNull(code, "code must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public _FinalStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public _FinalStage detail(String detail) {
            this.detail = Optional.ofNullable(detail);
            return this;
        }

        @Override
        @JsonSetter(value="detail", nulls=Nulls.SKIP)
        public _FinalStage detail(Optional<String> detail) {
            this.detail = detail;
            return this;
        }

        @Override
        public PlanIssueResponseData build() {
            return new PlanIssueResponseData(this.code, this.description, this.detail, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PlanIssueResponseData build();

        public _FinalStage detail(Optional<String> var1);

        public _FinalStage detail(String var1);

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);
    }

    public static interface DescriptionStage {
        public _FinalStage description(@NotNull String var1);
    }

    public static interface CodeStage {
        public DescriptionStage code(@NotNull String var1);

        public Builder from(PlanIssueResponseData var1);
    }
}

