/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PlanSelection {
    private final String planId;
    private final Optional<String> priceId;
    private final Map<String, Object> additionalProperties;

    private PlanSelection(String planId, Optional<String> priceId, Map<String, Object> additionalProperties) {
        this.planId = planId;
        this.priceId = priceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="plan_id")
    public String getPlanId() {
        return this.planId;
    }

    @JsonProperty(value="price_id")
    public Optional<String> getPriceId() {
        return this.priceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PlanSelection && this.equalTo((PlanSelection)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanSelection other) {
        return this.planId.equals(other.planId) && this.priceId.equals(other.priceId);
    }

    public int hashCode() {
        return Objects.hash(this.planId, this.priceId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PlanIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PlanIdStage,
    _FinalStage {
        private String planId;
        private Optional<String> priceId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PlanSelection other) {
            this.planId(other.getPlanId());
            this.priceId(other.getPriceId());
            return this;
        }

        @Override
        @JsonSetter(value="plan_id")
        public _FinalStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @Override
        public _FinalStage priceId(String priceId) {
            this.priceId = Optional.ofNullable(priceId);
            return this;
        }

        @Override
        @JsonSetter(value="price_id", nulls=Nulls.SKIP)
        public _FinalStage priceId(Optional<String> priceId) {
            this.priceId = priceId;
            return this;
        }

        @Override
        public PlanSelection build() {
            return new PlanSelection(this.planId, this.priceId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PlanSelection build();

        public _FinalStage priceId(Optional<String> var1);

        public _FinalStage priceId(String var1);
    }

    public static interface PlanIdStage {
        public _FinalStage planId(@NotNull String var1);

        public Builder from(PlanSelection var1);
    }
}

