/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PlanSnapshotView {
    private final boolean deleted;
    private final String description;
    private final String icon;
    private final String id;
    private final String name;
    private final Map<String, Object> additionalProperties;

    private PlanSnapshotView(boolean deleted, String description, String icon, String id, String name, Map<String, Object> additionalProperties) {
        this.deleted = deleted;
        this.description = description;
        this.icon = icon;
        this.id = id;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="deleted")
    public boolean getDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="icon")
    public String getIcon() {
        return this.icon;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PlanSnapshotView && this.equalTo((PlanSnapshotView)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanSnapshotView other) {
        return this.deleted == other.deleted && this.description.equals(other.description) && this.icon.equals(other.icon) && this.id.equals(other.id) && this.name.equals(other.name);
    }

    public int hashCode() {
        return Objects.hash(this.deleted, this.description, this.icon, this.id, this.name);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeletedStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DeletedStage,
    DescriptionStage,
    IconStage,
    IdStage,
    NameStage,
    _FinalStage {
        private boolean deleted;
        private String description;
        private String icon;
        private String id;
        private String name;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PlanSnapshotView other) {
            this.deleted(other.getDeleted());
            this.description(other.getDescription());
            this.icon(other.getIcon());
            this.id(other.getId());
            this.name(other.getName());
            return this;
        }

        @Override
        @JsonSetter(value="deleted")
        public DescriptionStage deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public IconStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="icon")
        public IdStage icon(@NotNull String icon) {
            this.icon = Objects.requireNonNull(icon, "icon must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public PlanSnapshotView build() {
            return new PlanSnapshotView(this.deleted, this.description, this.icon, this.id, this.name, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PlanSnapshotView build();
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface IconStage {
        public IdStage icon(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public IconStage description(@NotNull String var1);
    }

    public static interface DeletedStage {
        public DescriptionStage deleted(boolean var1);

        public Builder from(PlanSnapshotView var1);
    }
}

