/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PlanTraitResponseData {
    private final String accountId;
    private final OffsetDateTime createdAt;
    private final String environmentId;
    private final String id;
    private final String planId;
    private final String planType;
    private final String traitId;
    private final String traitValue;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private PlanTraitResponseData(String accountId, OffsetDateTime createdAt, String environmentId, String id, String planId, String planType, String traitId, String traitValue, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.createdAt = createdAt;
        this.environmentId = environmentId;
        this.id = id;
        this.planId = planId;
        this.planType = planType;
        this.traitId = traitId;
        this.traitValue = traitValue;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="account_id")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="plan_id")
    public String getPlanId() {
        return this.planId;
    }

    @JsonProperty(value="plan_type")
    public String getPlanType() {
        return this.planType;
    }

    @JsonProperty(value="trait_id")
    public String getTraitId() {
        return this.traitId;
    }

    @JsonProperty(value="trait_value")
    public String getTraitValue() {
        return this.traitValue;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PlanTraitResponseData && this.equalTo((PlanTraitResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanTraitResponseData other) {
        return this.accountId.equals(other.accountId) && this.createdAt.equals(other.createdAt) && this.environmentId.equals(other.environmentId) && this.id.equals(other.id) && this.planId.equals(other.planId) && this.planType.equals(other.planType) && this.traitId.equals(other.traitId) && this.traitValue.equals(other.traitValue) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.createdAt, this.environmentId, this.id, this.planId, this.planType, this.traitId, this.traitValue, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccountIdStage,
    CreatedAtStage,
    EnvironmentIdStage,
    IdStage,
    PlanIdStage,
    PlanTypeStage,
    TraitIdStage,
    TraitValueStage,
    UpdatedAtStage,
    _FinalStage {
        private String accountId;
        private OffsetDateTime createdAt;
        private String environmentId;
        private String id;
        private String planId;
        private String planType;
        private String traitId;
        private String traitValue;
        private OffsetDateTime updatedAt;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PlanTraitResponseData other) {
            this.accountId(other.getAccountId());
            this.createdAt(other.getCreatedAt());
            this.environmentId(other.getEnvironmentId());
            this.id(other.getId());
            this.planId(other.getPlanId());
            this.planType(other.getPlanType());
            this.traitId(other.getTraitId());
            this.traitValue(other.getTraitValue());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="account_id")
        public CreatedAtStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public PlanIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="plan_id")
        public PlanTypeStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="plan_type")
        public TraitIdStage planType(@NotNull String planType) {
            this.planType = Objects.requireNonNull(planType, "planType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="trait_id")
        public TraitValueStage traitId(@NotNull String traitId) {
            this.traitId = Objects.requireNonNull(traitId, "traitId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="trait_value")
        public UpdatedAtStage traitValue(@NotNull String traitValue) {
            this.traitValue = Objects.requireNonNull(traitValue, "traitValue must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public PlanTraitResponseData build() {
            return new PlanTraitResponseData(this.accountId, this.createdAt, this.environmentId, this.id, this.planId, this.planType, this.traitId, this.traitValue, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PlanTraitResponseData build();
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface TraitValueStage {
        public UpdatedAtStage traitValue(@NotNull String var1);
    }

    public static interface TraitIdStage {
        public TraitValueStage traitId(@NotNull String var1);
    }

    public static interface PlanTypeStage {
        public TraitIdStage planType(@NotNull String var1);
    }

    public static interface PlanIdStage {
        public PlanTypeStage planId(@NotNull String var1);
    }

    public static interface IdStage {
        public PlanIdStage id(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public IdStage environmentId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface AccountIdStage {
        public CreatedAtStage accountId(@NotNull String var1);

        public Builder from(PlanTraitResponseData var1);
    }
}

