/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.PreviewSubscriptionUpcomingInvoiceLineItems;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PreviewSubscriptionFinanceResponseData {
    private final int amountOff;
    private final int dueNow;
    private final int newCharges;
    private final double percentOff;
    private final OffsetDateTime periodStart;
    private final boolean promoCodeApplied;
    private final int proration;
    private final Optional<Integer> taxAmount;
    private final Optional<String> taxDisplayName;
    private final boolean taxRequireBillingDetails;
    private final Optional<OffsetDateTime> trialEnd;
    private final List<PreviewSubscriptionUpcomingInvoiceLineItems> upcomingInvoiceLineItems;
    private final Map<String, Object> additionalProperties;

    private PreviewSubscriptionFinanceResponseData(int amountOff, int dueNow, int newCharges, double percentOff, OffsetDateTime periodStart, boolean promoCodeApplied, int proration, Optional<Integer> taxAmount, Optional<String> taxDisplayName, boolean taxRequireBillingDetails, Optional<OffsetDateTime> trialEnd, List<PreviewSubscriptionUpcomingInvoiceLineItems> upcomingInvoiceLineItems, Map<String, Object> additionalProperties) {
        this.amountOff = amountOff;
        this.dueNow = dueNow;
        this.newCharges = newCharges;
        this.percentOff = percentOff;
        this.periodStart = periodStart;
        this.promoCodeApplied = promoCodeApplied;
        this.proration = proration;
        this.taxAmount = taxAmount;
        this.taxDisplayName = taxDisplayName;
        this.taxRequireBillingDetails = taxRequireBillingDetails;
        this.trialEnd = trialEnd;
        this.upcomingInvoiceLineItems = upcomingInvoiceLineItems;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="amount_off")
    public int getAmountOff() {
        return this.amountOff;
    }

    @JsonProperty(value="due_now")
    public int getDueNow() {
        return this.dueNow;
    }

    @JsonProperty(value="new_charges")
    public int getNewCharges() {
        return this.newCharges;
    }

    @JsonProperty(value="percent_off")
    public double getPercentOff() {
        return this.percentOff;
    }

    @JsonProperty(value="period_start")
    public OffsetDateTime getPeriodStart() {
        return this.periodStart;
    }

    @JsonProperty(value="promo_code_applied")
    public boolean getPromoCodeApplied() {
        return this.promoCodeApplied;
    }

    @JsonProperty(value="proration")
    public int getProration() {
        return this.proration;
    }

    @JsonProperty(value="tax_amount")
    public Optional<Integer> getTaxAmount() {
        return this.taxAmount;
    }

    @JsonProperty(value="tax_display_name")
    public Optional<String> getTaxDisplayName() {
        return this.taxDisplayName;
    }

    @JsonProperty(value="tax_require_billing_details")
    public boolean getTaxRequireBillingDetails() {
        return this.taxRequireBillingDetails;
    }

    @JsonProperty(value="trial_end")
    public Optional<OffsetDateTime> getTrialEnd() {
        return this.trialEnd;
    }

    @JsonProperty(value="upcoming_invoice_line_items")
    public List<PreviewSubscriptionUpcomingInvoiceLineItems> getUpcomingInvoiceLineItems() {
        return this.upcomingInvoiceLineItems;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PreviewSubscriptionFinanceResponseData && this.equalTo((PreviewSubscriptionFinanceResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PreviewSubscriptionFinanceResponseData other) {
        return this.amountOff == other.amountOff && this.dueNow == other.dueNow && this.newCharges == other.newCharges && this.percentOff == other.percentOff && this.periodStart.equals(other.periodStart) && this.promoCodeApplied == other.promoCodeApplied && this.proration == other.proration && this.taxAmount.equals(other.taxAmount) && this.taxDisplayName.equals(other.taxDisplayName) && this.taxRequireBillingDetails == other.taxRequireBillingDetails && this.trialEnd.equals(other.trialEnd) && this.upcomingInvoiceLineItems.equals(other.upcomingInvoiceLineItems);
    }

    public int hashCode() {
        return Objects.hash(this.amountOff, this.dueNow, this.newCharges, this.percentOff, this.periodStart, this.promoCodeApplied, this.proration, this.taxAmount, this.taxDisplayName, this.taxRequireBillingDetails, this.trialEnd, this.upcomingInvoiceLineItems);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AmountOffStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AmountOffStage,
    DueNowStage,
    NewChargesStage,
    PercentOffStage,
    PeriodStartStage,
    PromoCodeAppliedStage,
    ProrationStage,
    TaxRequireBillingDetailsStage,
    _FinalStage {
        private int amountOff;
        private int dueNow;
        private int newCharges;
        private double percentOff;
        private OffsetDateTime periodStart;
        private boolean promoCodeApplied;
        private int proration;
        private boolean taxRequireBillingDetails;
        private List<PreviewSubscriptionUpcomingInvoiceLineItems> upcomingInvoiceLineItems = new ArrayList<PreviewSubscriptionUpcomingInvoiceLineItems>();
        private Optional<OffsetDateTime> trialEnd = Optional.empty();
        private Optional<String> taxDisplayName = Optional.empty();
        private Optional<Integer> taxAmount = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PreviewSubscriptionFinanceResponseData other) {
            this.amountOff(other.getAmountOff());
            this.dueNow(other.getDueNow());
            this.newCharges(other.getNewCharges());
            this.percentOff(other.getPercentOff());
            this.periodStart(other.getPeriodStart());
            this.promoCodeApplied(other.getPromoCodeApplied());
            this.proration(other.getProration());
            this.taxAmount(other.getTaxAmount());
            this.taxDisplayName(other.getTaxDisplayName());
            this.taxRequireBillingDetails(other.getTaxRequireBillingDetails());
            this.trialEnd(other.getTrialEnd());
            this.upcomingInvoiceLineItems(other.getUpcomingInvoiceLineItems());
            return this;
        }

        @Override
        @JsonSetter(value="amount_off")
        public DueNowStage amountOff(int amountOff) {
            this.amountOff = amountOff;
            return this;
        }

        @Override
        @JsonSetter(value="due_now")
        public NewChargesStage dueNow(int dueNow) {
            this.dueNow = dueNow;
            return this;
        }

        @Override
        @JsonSetter(value="new_charges")
        public PercentOffStage newCharges(int newCharges) {
            this.newCharges = newCharges;
            return this;
        }

        @Override
        @JsonSetter(value="percent_off")
        public PeriodStartStage percentOff(double percentOff) {
            this.percentOff = percentOff;
            return this;
        }

        @Override
        @JsonSetter(value="period_start")
        public PromoCodeAppliedStage periodStart(@NotNull OffsetDateTime periodStart) {
            this.periodStart = Objects.requireNonNull(periodStart, "periodStart must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="promo_code_applied")
        public ProrationStage promoCodeApplied(boolean promoCodeApplied) {
            this.promoCodeApplied = promoCodeApplied;
            return this;
        }

        @Override
        @JsonSetter(value="proration")
        public TaxRequireBillingDetailsStage proration(int proration) {
            this.proration = proration;
            return this;
        }

        @Override
        @JsonSetter(value="tax_require_billing_details")
        public _FinalStage taxRequireBillingDetails(boolean taxRequireBillingDetails) {
            this.taxRequireBillingDetails = taxRequireBillingDetails;
            return this;
        }

        @Override
        public _FinalStage addAllUpcomingInvoiceLineItems(List<PreviewSubscriptionUpcomingInvoiceLineItems> upcomingInvoiceLineItems) {
            if (upcomingInvoiceLineItems != null) {
                this.upcomingInvoiceLineItems.addAll(upcomingInvoiceLineItems);
            }
            return this;
        }

        @Override
        public _FinalStage addUpcomingInvoiceLineItems(PreviewSubscriptionUpcomingInvoiceLineItems upcomingInvoiceLineItems) {
            this.upcomingInvoiceLineItems.add(upcomingInvoiceLineItems);
            return this;
        }

        @Override
        @JsonSetter(value="upcoming_invoice_line_items", nulls=Nulls.SKIP)
        public _FinalStage upcomingInvoiceLineItems(List<PreviewSubscriptionUpcomingInvoiceLineItems> upcomingInvoiceLineItems) {
            this.upcomingInvoiceLineItems.clear();
            if (upcomingInvoiceLineItems != null) {
                this.upcomingInvoiceLineItems.addAll(upcomingInvoiceLineItems);
            }
            return this;
        }

        @Override
        public _FinalStage trialEnd(OffsetDateTime trialEnd) {
            this.trialEnd = Optional.ofNullable(trialEnd);
            return this;
        }

        @Override
        @JsonSetter(value="trial_end", nulls=Nulls.SKIP)
        public _FinalStage trialEnd(Optional<OffsetDateTime> trialEnd) {
            this.trialEnd = trialEnd;
            return this;
        }

        @Override
        public _FinalStage taxDisplayName(String taxDisplayName) {
            this.taxDisplayName = Optional.ofNullable(taxDisplayName);
            return this;
        }

        @Override
        @JsonSetter(value="tax_display_name", nulls=Nulls.SKIP)
        public _FinalStage taxDisplayName(Optional<String> taxDisplayName) {
            this.taxDisplayName = taxDisplayName;
            return this;
        }

        @Override
        public _FinalStage taxAmount(Integer taxAmount) {
            this.taxAmount = Optional.ofNullable(taxAmount);
            return this;
        }

        @Override
        @JsonSetter(value="tax_amount", nulls=Nulls.SKIP)
        public _FinalStage taxAmount(Optional<Integer> taxAmount) {
            this.taxAmount = taxAmount;
            return this;
        }

        @Override
        public PreviewSubscriptionFinanceResponseData build() {
            return new PreviewSubscriptionFinanceResponseData(this.amountOff, this.dueNow, this.newCharges, this.percentOff, this.periodStart, this.promoCodeApplied, this.proration, this.taxAmount, this.taxDisplayName, this.taxRequireBillingDetails, this.trialEnd, this.upcomingInvoiceLineItems, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PreviewSubscriptionFinanceResponseData build();

        public _FinalStage taxAmount(Optional<Integer> var1);

        public _FinalStage taxAmount(Integer var1);

        public _FinalStage taxDisplayName(Optional<String> var1);

        public _FinalStage taxDisplayName(String var1);

        public _FinalStage trialEnd(Optional<OffsetDateTime> var1);

        public _FinalStage trialEnd(OffsetDateTime var1);

        public _FinalStage upcomingInvoiceLineItems(List<PreviewSubscriptionUpcomingInvoiceLineItems> var1);

        public _FinalStage addUpcomingInvoiceLineItems(PreviewSubscriptionUpcomingInvoiceLineItems var1);

        public _FinalStage addAllUpcomingInvoiceLineItems(List<PreviewSubscriptionUpcomingInvoiceLineItems> var1);
    }

    public static interface TaxRequireBillingDetailsStage {
        public _FinalStage taxRequireBillingDetails(boolean var1);
    }

    public static interface ProrationStage {
        public TaxRequireBillingDetailsStage proration(int var1);
    }

    public static interface PromoCodeAppliedStage {
        public ProrationStage promoCodeApplied(boolean var1);
    }

    public static interface PeriodStartStage {
        public PromoCodeAppliedStage periodStart(@NotNull OffsetDateTime var1);
    }

    public static interface PercentOffStage {
        public PeriodStartStage percentOff(double var1);
    }

    public static interface NewChargesStage {
        public PercentOffStage newCharges(int var1);
    }

    public static interface DueNowStage {
        public NewChargesStage dueNow(int var1);
    }

    public static interface AmountOffStage {
        public DueNowStage amountOff(int var1);

        public Builder from(PreviewSubscriptionFinanceResponseData var1);
    }
}

