/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PreviewSubscriptionUpcomingInvoiceLineItems {
    private final int amount;
    private final String description;
    private final String priceId;
    private final boolean proration;
    private final int quantity;
    private final Map<String, Object> additionalProperties;

    private PreviewSubscriptionUpcomingInvoiceLineItems(int amount, String description, String priceId, boolean proration, int quantity, Map<String, Object> additionalProperties) {
        this.amount = amount;
        this.description = description;
        this.priceId = priceId;
        this.proration = proration;
        this.quantity = quantity;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="amount")
    public int getAmount() {
        return this.amount;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="price_id")
    public String getPriceId() {
        return this.priceId;
    }

    @JsonProperty(value="proration")
    public boolean getProration() {
        return this.proration;
    }

    @JsonProperty(value="quantity")
    public int getQuantity() {
        return this.quantity;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PreviewSubscriptionUpcomingInvoiceLineItems && this.equalTo((PreviewSubscriptionUpcomingInvoiceLineItems)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PreviewSubscriptionUpcomingInvoiceLineItems other) {
        return this.amount == other.amount && this.description.equals(other.description) && this.priceId.equals(other.priceId) && this.proration == other.proration && this.quantity == other.quantity;
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.description, this.priceId, this.proration, this.quantity);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AmountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AmountStage,
    DescriptionStage,
    PriceIdStage,
    ProrationStage,
    QuantityStage,
    _FinalStage {
        private int amount;
        private String description;
        private String priceId;
        private boolean proration;
        private int quantity;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PreviewSubscriptionUpcomingInvoiceLineItems other) {
            this.amount(other.getAmount());
            this.description(other.getDescription());
            this.priceId(other.getPriceId());
            this.proration(other.getProration());
            this.quantity(other.getQuantity());
            return this;
        }

        @Override
        @JsonSetter(value="amount")
        public DescriptionStage amount(int amount) {
            this.amount = amount;
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public PriceIdStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="price_id")
        public ProrationStage priceId(@NotNull String priceId) {
            this.priceId = Objects.requireNonNull(priceId, "priceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="proration")
        public QuantityStage proration(boolean proration) {
            this.proration = proration;
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public _FinalStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        public PreviewSubscriptionUpcomingInvoiceLineItems build() {
            return new PreviewSubscriptionUpcomingInvoiceLineItems(this.amount, this.description, this.priceId, this.proration, this.quantity, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PreviewSubscriptionUpcomingInvoiceLineItems build();
    }

    public static interface QuantityStage {
        public _FinalStage quantity(int var1);
    }

    public static interface ProrationStage {
        public QuantityStage proration(boolean var1);
    }

    public static interface PriceIdStage {
        public ProrationStage priceId(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public PriceIdStage description(@NotNull String var1);
    }

    public static interface AmountStage {
        public DescriptionStage amount(int var1);

        public Builder from(PreviewSubscriptionUpcomingInvoiceLineItems var1);
    }
}

