/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.Condition;
import com.schematic.api.types.ConditionGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Rule {
    private final String accountId;
    private final List<ConditionGroup> conditionGroups;
    private final List<Condition> conditions;
    private final String environmentId;
    private final Optional<String> flagId;
    private final String id;
    private final String name;
    private final int priority;
    private final String ruleType;
    private final boolean value;
    private final Map<String, Object> additionalProperties;

    private Rule(String accountId, List<ConditionGroup> conditionGroups, List<Condition> conditions, String environmentId, Optional<String> flagId, String id, String name, int priority, String ruleType, boolean value, Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.conditionGroups = conditionGroups;
        this.conditions = conditions;
        this.environmentId = environmentId;
        this.flagId = flagId;
        this.id = id;
        this.name = name;
        this.priority = priority;
        this.ruleType = ruleType;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="account_id")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="condition_groups")
    public List<ConditionGroup> getConditionGroups() {
        return this.conditionGroups;
    }

    @JsonProperty(value="conditions")
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="flag_id")
    public Optional<String> getFlagId() {
        return this.flagId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="priority")
    public int getPriority() {
        return this.priority;
    }

    @JsonProperty(value="rule_type")
    public String getRuleType() {
        return this.ruleType;
    }

    @JsonProperty(value="value")
    public boolean getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Rule && this.equalTo((Rule)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Rule other) {
        return this.accountId.equals(other.accountId) && this.conditionGroups.equals(other.conditionGroups) && this.conditions.equals(other.conditions) && this.environmentId.equals(other.environmentId) && this.flagId.equals(other.flagId) && this.id.equals(other.id) && this.name.equals(other.name) && this.priority == other.priority && this.ruleType.equals(other.ruleType) && this.value == other.value;
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.conditionGroups, this.conditions, this.environmentId, this.flagId, this.id, this.name, this.priority, this.ruleType, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccountIdStage,
    EnvironmentIdStage,
    IdStage,
    NameStage,
    PriorityStage,
    RuleTypeStage,
    ValueStage,
    _FinalStage {
        private String accountId;
        private String environmentId;
        private String id;
        private String name;
        private int priority;
        private String ruleType;
        private boolean value;
        private Optional<String> flagId = Optional.empty();
        private List<Condition> conditions = new ArrayList<Condition>();
        private List<ConditionGroup> conditionGroups = new ArrayList<ConditionGroup>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Rule other) {
            this.accountId(other.getAccountId());
            this.conditionGroups(other.getConditionGroups());
            this.conditions(other.getConditions());
            this.environmentId(other.getEnvironmentId());
            this.flagId(other.getFlagId());
            this.id(other.getId());
            this.name(other.getName());
            this.priority(other.getPriority());
            this.ruleType(other.getRuleType());
            this.value(other.getValue());
            return this;
        }

        @Override
        @JsonSetter(value="account_id")
        public EnvironmentIdStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PriorityStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="priority")
        public RuleTypeStage priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        @JsonSetter(value="rule_type")
        public ValueStage ruleType(@NotNull String ruleType) {
            this.ruleType = Objects.requireNonNull(ruleType, "ruleType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(boolean value) {
            this.value = value;
            return this;
        }

        @Override
        public _FinalStage flagId(String flagId) {
            this.flagId = Optional.ofNullable(flagId);
            return this;
        }

        @Override
        @JsonSetter(value="flag_id", nulls=Nulls.SKIP)
        public _FinalStage flagId(Optional<String> flagId) {
            this.flagId = flagId;
            return this;
        }

        @Override
        public _FinalStage addAllConditions(List<Condition> conditions) {
            if (conditions != null) {
                this.conditions.addAll(conditions);
            }
            return this;
        }

        @Override
        public _FinalStage addConditions(Condition conditions) {
            this.conditions.add(conditions);
            return this;
        }

        @Override
        @JsonSetter(value="conditions", nulls=Nulls.SKIP)
        public _FinalStage conditions(List<Condition> conditions) {
            this.conditions.clear();
            if (conditions != null) {
                this.conditions.addAll(conditions);
            }
            return this;
        }

        @Override
        public _FinalStage addAllConditionGroups(List<ConditionGroup> conditionGroups) {
            if (conditionGroups != null) {
                this.conditionGroups.addAll(conditionGroups);
            }
            return this;
        }

        @Override
        public _FinalStage addConditionGroups(ConditionGroup conditionGroups) {
            this.conditionGroups.add(conditionGroups);
            return this;
        }

        @Override
        @JsonSetter(value="condition_groups", nulls=Nulls.SKIP)
        public _FinalStage conditionGroups(List<ConditionGroup> conditionGroups) {
            this.conditionGroups.clear();
            if (conditionGroups != null) {
                this.conditionGroups.addAll(conditionGroups);
            }
            return this;
        }

        @Override
        public Rule build() {
            return new Rule(this.accountId, this.conditionGroups, this.conditions, this.environmentId, this.flagId, this.id, this.name, this.priority, this.ruleType, this.value, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Rule build();

        public _FinalStage conditionGroups(List<ConditionGroup> var1);

        public _FinalStage addConditionGroups(ConditionGroup var1);

        public _FinalStage addAllConditionGroups(List<ConditionGroup> var1);

        public _FinalStage conditions(List<Condition> var1);

        public _FinalStage addConditions(Condition var1);

        public _FinalStage addAllConditions(List<Condition> var1);

        public _FinalStage flagId(Optional<String> var1);

        public _FinalStage flagId(String var1);
    }

    public static interface ValueStage {
        public _FinalStage value(boolean var1);
    }

    public static interface RuleTypeStage {
        public ValueStage ruleType(@NotNull String var1);
    }

    public static interface PriorityStage {
        public RuleTypeStage priority(int var1);
    }

    public static interface NameStage {
        public PriorityStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public IdStage environmentId(@NotNull String var1);
    }

    public static interface AccountIdStage {
        public EnvironmentIdStage accountId(@NotNull String var1);

        public Builder from(Rule var1);
    }
}

