/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RuleConditionGroupResponseData {
    private final OffsetDateTime createdAt;
    private final String environmentId;
    private final Optional<String> flagId;
    private final String id;
    private final String ruleId;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private RuleConditionGroupResponseData(OffsetDateTime createdAt, String environmentId, Optional<String> flagId, String id, String ruleId, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.environmentId = environmentId;
        this.flagId = flagId;
        this.id = id;
        this.ruleId = ruleId;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="flag_id")
    public Optional<String> getFlagId() {
        return this.flagId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="rule_id")
    public String getRuleId() {
        return this.ruleId;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RuleConditionGroupResponseData && this.equalTo((RuleConditionGroupResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RuleConditionGroupResponseData other) {
        return this.createdAt.equals(other.createdAt) && this.environmentId.equals(other.environmentId) && this.flagId.equals(other.flagId) && this.id.equals(other.id) && this.ruleId.equals(other.ruleId) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.environmentId, this.flagId, this.id, this.ruleId, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    EnvironmentIdStage,
    IdStage,
    RuleIdStage,
    UpdatedAtStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String environmentId;
        private String id;
        private String ruleId;
        private OffsetDateTime updatedAt;
        private Optional<String> flagId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(RuleConditionGroupResponseData other) {
            this.createdAt(other.getCreatedAt());
            this.environmentId(other.getEnvironmentId());
            this.flagId(other.getFlagId());
            this.id(other.getId());
            this.ruleId(other.getRuleId());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public RuleIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="rule_id")
        public UpdatedAtStage ruleId(@NotNull String ruleId) {
            this.ruleId = Objects.requireNonNull(ruleId, "ruleId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage flagId(String flagId) {
            this.flagId = Optional.ofNullable(flagId);
            return this;
        }

        @Override
        @JsonSetter(value="flag_id", nulls=Nulls.SKIP)
        public _FinalStage flagId(Optional<String> flagId) {
            this.flagId = flagId;
            return this;
        }

        @Override
        public RuleConditionGroupResponseData build() {
            return new RuleConditionGroupResponseData(this.createdAt, this.environmentId, this.flagId, this.id, this.ruleId, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public RuleConditionGroupResponseData build();

        public _FinalStage flagId(Optional<String> var1);

        public _FinalStage flagId(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface RuleIdStage {
        public UpdatedAtStage ruleId(@NotNull String var1);
    }

    public static interface IdStage {
        public RuleIdStage id(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public IdStage environmentId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(RuleConditionGroupResponseData var1);
    }
}

