/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SegmentStatusResp {
    private final boolean connected;
    private final String environmentId;
    private final Optional<OffsetDateTime> lastEventAt;
    private final Map<String, Object> additionalProperties;

    private SegmentStatusResp(boolean connected, String environmentId, Optional<OffsetDateTime> lastEventAt, Map<String, Object> additionalProperties) {
        this.connected = connected;
        this.environmentId = environmentId;
        this.lastEventAt = lastEventAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="connected")
    public boolean getConnected() {
        return this.connected;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="last_event_at")
    public Optional<OffsetDateTime> getLastEventAt() {
        return this.lastEventAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SegmentStatusResp && this.equalTo((SegmentStatusResp)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SegmentStatusResp other) {
        return this.connected == other.connected && this.environmentId.equals(other.environmentId) && this.lastEventAt.equals(other.lastEventAt);
    }

    public int hashCode() {
        return Objects.hash(this.connected, this.environmentId, this.lastEventAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConnectedStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ConnectedStage,
    EnvironmentIdStage,
    _FinalStage {
        private boolean connected;
        private String environmentId;
        private Optional<OffsetDateTime> lastEventAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SegmentStatusResp other) {
            this.connected(other.getConnected());
            this.environmentId(other.getEnvironmentId());
            this.lastEventAt(other.getLastEventAt());
            return this;
        }

        @Override
        @JsonSetter(value="connected")
        public EnvironmentIdStage connected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public _FinalStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        public _FinalStage lastEventAt(OffsetDateTime lastEventAt) {
            this.lastEventAt = Optional.ofNullable(lastEventAt);
            return this;
        }

        @Override
        @JsonSetter(value="last_event_at", nulls=Nulls.SKIP)
        public _FinalStage lastEventAt(Optional<OffsetDateTime> lastEventAt) {
            this.lastEventAt = lastEventAt;
            return this;
        }

        @Override
        public SegmentStatusResp build() {
            return new SegmentStatusResp(this.connected, this.environmentId, this.lastEventAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SegmentStatusResp build();

        public _FinalStage lastEventAt(Optional<OffsetDateTime> var1);

        public _FinalStage lastEventAt(OffsetDateTime var1);
    }

    public static interface EnvironmentIdStage {
        public _FinalStage environmentId(@NotNull String var1);
    }

    public static interface ConnectedStage {
        public EnvironmentIdStage connected(boolean var1);

        public Builder from(SegmentStatusResp var1);
    }
}

