/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class StripeEmbedInfo {
    private final Optional<String> accountId;
    private final Optional<String> publishableKey;
    private final String schematicPublishableKey;
    private final Optional<String> setupIntentClientSecret;
    private final Map<String, Object> additionalProperties;

    private StripeEmbedInfo(Optional<String> accountId, Optional<String> publishableKey, String schematicPublishableKey, Optional<String> setupIntentClientSecret, Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.publishableKey = publishableKey;
        this.schematicPublishableKey = schematicPublishableKey;
        this.setupIntentClientSecret = setupIntentClientSecret;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="account_id")
    public Optional<String> getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="publishable_key")
    public Optional<String> getPublishableKey() {
        return this.publishableKey;
    }

    @JsonProperty(value="schematic_publishable_key")
    public String getSchematicPublishableKey() {
        return this.schematicPublishableKey;
    }

    @JsonProperty(value="setup_intent_client_secret")
    public Optional<String> getSetupIntentClientSecret() {
        return this.setupIntentClientSecret;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StripeEmbedInfo && this.equalTo((StripeEmbedInfo)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StripeEmbedInfo other) {
        return this.accountId.equals(other.accountId) && this.publishableKey.equals(other.publishableKey) && this.schematicPublishableKey.equals(other.schematicPublishableKey) && this.setupIntentClientSecret.equals(other.setupIntentClientSecret);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.publishableKey, this.schematicPublishableKey, this.setupIntentClientSecret);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchematicPublishableKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SchematicPublishableKeyStage,
    _FinalStage {
        private String schematicPublishableKey;
        private Optional<String> setupIntentClientSecret = Optional.empty();
        private Optional<String> publishableKey = Optional.empty();
        private Optional<String> accountId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(StripeEmbedInfo other) {
            this.accountId(other.getAccountId());
            this.publishableKey(other.getPublishableKey());
            this.schematicPublishableKey(other.getSchematicPublishableKey());
            this.setupIntentClientSecret(other.getSetupIntentClientSecret());
            return this;
        }

        @Override
        @JsonSetter(value="schematic_publishable_key")
        public _FinalStage schematicPublishableKey(@NotNull String schematicPublishableKey) {
            this.schematicPublishableKey = Objects.requireNonNull(schematicPublishableKey, "schematicPublishableKey must not be null");
            return this;
        }

        @Override
        public _FinalStage setupIntentClientSecret(String setupIntentClientSecret) {
            this.setupIntentClientSecret = Optional.ofNullable(setupIntentClientSecret);
            return this;
        }

        @Override
        @JsonSetter(value="setup_intent_client_secret", nulls=Nulls.SKIP)
        public _FinalStage setupIntentClientSecret(Optional<String> setupIntentClientSecret) {
            this.setupIntentClientSecret = setupIntentClientSecret;
            return this;
        }

        @Override
        public _FinalStage publishableKey(String publishableKey) {
            this.publishableKey = Optional.ofNullable(publishableKey);
            return this;
        }

        @Override
        @JsonSetter(value="publishable_key", nulls=Nulls.SKIP)
        public _FinalStage publishableKey(Optional<String> publishableKey) {
            this.publishableKey = publishableKey;
            return this;
        }

        @Override
        public _FinalStage accountId(String accountId) {
            this.accountId = Optional.ofNullable(accountId);
            return this;
        }

        @Override
        @JsonSetter(value="account_id", nulls=Nulls.SKIP)
        public _FinalStage accountId(Optional<String> accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public StripeEmbedInfo build() {
            return new StripeEmbedInfo(this.accountId, this.publishableKey, this.schematicPublishableKey, this.setupIntentClientSecret, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public StripeEmbedInfo build();

        public _FinalStage accountId(Optional<String> var1);

        public _FinalStage accountId(String var1);

        public _FinalStage publishableKey(Optional<String> var1);

        public _FinalStage publishableKey(String var1);

        public _FinalStage setupIntentClientSecret(Optional<String> var1);

        public _FinalStage setupIntentClientSecret(String var1);
    }

    public static interface SchematicPublishableKeyStage {
        public _FinalStage schematicPublishableKey(@NotNull String var1);

        public Builder from(StripeEmbedInfo var1);
    }
}

