/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SubscriptionTraitUpdate {
    private final String featureId;
    private final List<String> hierarchy;
    private final String reason;
    private final String traitId;
    private final String traitName;
    private final String traitType;
    private final String value;
    private final Map<String, Object> additionalProperties;

    private SubscriptionTraitUpdate(String featureId, List<String> hierarchy, String reason, String traitId, String traitName, String traitType, String value, Map<String, Object> additionalProperties) {
        this.featureId = featureId;
        this.hierarchy = hierarchy;
        this.reason = reason;
        this.traitId = traitId;
        this.traitName = traitName;
        this.traitType = traitType;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="feature_id")
    public String getFeatureId() {
        return this.featureId;
    }

    @JsonProperty(value="hierarchy")
    public List<String> getHierarchy() {
        return this.hierarchy;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="trait_id")
    public String getTraitId() {
        return this.traitId;
    }

    @JsonProperty(value="trait_name")
    public String getTraitName() {
        return this.traitName;
    }

    @JsonProperty(value="trait_type")
    public String getTraitType() {
        return this.traitType;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SubscriptionTraitUpdate && this.equalTo((SubscriptionTraitUpdate)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubscriptionTraitUpdate other) {
        return this.featureId.equals(other.featureId) && this.hierarchy.equals(other.hierarchy) && this.reason.equals(other.reason) && this.traitId.equals(other.traitId) && this.traitName.equals(other.traitName) && this.traitType.equals(other.traitType) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.featureId, this.hierarchy, this.reason, this.traitId, this.traitName, this.traitType, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static FeatureIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements FeatureIdStage,
    ReasonStage,
    TraitIdStage,
    TraitNameStage,
    TraitTypeStage,
    ValueStage,
    _FinalStage {
        private String featureId;
        private String reason;
        private String traitId;
        private String traitName;
        private String traitType;
        private String value;
        private List<String> hierarchy = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SubscriptionTraitUpdate other) {
            this.featureId(other.getFeatureId());
            this.hierarchy(other.getHierarchy());
            this.reason(other.getReason());
            this.traitId(other.getTraitId());
            this.traitName(other.getTraitName());
            this.traitType(other.getTraitType());
            this.value(other.getValue());
            return this;
        }

        @Override
        @JsonSetter(value="feature_id")
        public ReasonStage featureId(@NotNull String featureId) {
            this.featureId = Objects.requireNonNull(featureId, "featureId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="reason")
        public TraitIdStage reason(@NotNull String reason) {
            this.reason = Objects.requireNonNull(reason, "reason must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="trait_id")
        public TraitNameStage traitId(@NotNull String traitId) {
            this.traitId = Objects.requireNonNull(traitId, "traitId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="trait_name")
        public TraitTypeStage traitName(@NotNull String traitName) {
            this.traitName = Objects.requireNonNull(traitName, "traitName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="trait_type")
        public ValueStage traitType(@NotNull String traitType) {
            this.traitType = Objects.requireNonNull(traitType, "traitType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(@NotNull String value) {
            this.value = Objects.requireNonNull(value, "value must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllHierarchy(List<String> hierarchy) {
            if (hierarchy != null) {
                this.hierarchy.addAll(hierarchy);
            }
            return this;
        }

        @Override
        public _FinalStage addHierarchy(String hierarchy) {
            this.hierarchy.add(hierarchy);
            return this;
        }

        @Override
        @JsonSetter(value="hierarchy", nulls=Nulls.SKIP)
        public _FinalStage hierarchy(List<String> hierarchy) {
            this.hierarchy.clear();
            if (hierarchy != null) {
                this.hierarchy.addAll(hierarchy);
            }
            return this;
        }

        @Override
        public SubscriptionTraitUpdate build() {
            return new SubscriptionTraitUpdate(this.featureId, this.hierarchy, this.reason, this.traitId, this.traitName, this.traitType, this.value, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SubscriptionTraitUpdate build();

        public _FinalStage hierarchy(List<String> var1);

        public _FinalStage addHierarchy(String var1);

        public _FinalStage addAllHierarchy(List<String> var1);
    }

    public static interface ValueStage {
        public _FinalStage value(@NotNull String var1);
    }

    public static interface TraitTypeStage {
        public ValueStage traitType(@NotNull String var1);
    }

    public static interface TraitNameStage {
        public TraitTypeStage traitName(@NotNull String var1);
    }

    public static interface TraitIdStage {
        public TraitNameStage traitId(@NotNull String var1);
    }

    public static interface ReasonStage {
        public TraitIdStage reason(@NotNull String var1);
    }

    public static interface FeatureIdStage {
        public ReasonStage featureId(@NotNull String var1);

        public Builder from(SubscriptionTraitUpdate var1);
    }
}

