/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TraitDefinition {
    private final String comparableType;
    private final String entityType;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private TraitDefinition(String comparableType, String entityType, String id, Map<String, Object> additionalProperties) {
        this.comparableType = comparableType;
        this.entityType = entityType;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="comparable_type")
    public String getComparableType() {
        return this.comparableType;
    }

    @JsonProperty(value="entity_type")
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TraitDefinition && this.equalTo((TraitDefinition)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TraitDefinition other) {
        return this.comparableType.equals(other.comparableType) && this.entityType.equals(other.entityType) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.comparableType, this.entityType, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ComparableTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ComparableTypeStage,
    EntityTypeStage,
    IdStage,
    _FinalStage {
        private String comparableType;
        private String entityType;
        private String id;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TraitDefinition other) {
            this.comparableType(other.getComparableType());
            this.entityType(other.getEntityType());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="comparable_type")
        public EntityTypeStage comparableType(@NotNull String comparableType) {
            this.comparableType = Objects.requireNonNull(comparableType, "comparableType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="entity_type")
        public IdStage entityType(@NotNull String entityType) {
            this.entityType = Objects.requireNonNull(entityType, "entityType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public TraitDefinition build() {
            return new TraitDefinition(this.comparableType, this.entityType, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TraitDefinition build();
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface EntityTypeStage {
        public IdStage entityType(@NotNull String var1);
    }

    public static interface ComparableTypeStage {
        public EntityTypeStage comparableType(@NotNull String var1);

        public Builder from(TraitDefinition var1);
    }
}

