/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateAddOnRequestBody {
    private final String addOnId;
    private final String priceId;
    private final Map<String, Object> additionalProperties;

    private UpdateAddOnRequestBody(String addOnId, String priceId, Map<String, Object> additionalProperties) {
        this.addOnId = addOnId;
        this.priceId = priceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="add_on_id")
    public String getAddOnId() {
        return this.addOnId;
    }

    @JsonProperty(value="price_id")
    public String getPriceId() {
        return this.priceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateAddOnRequestBody && this.equalTo((UpdateAddOnRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateAddOnRequestBody other) {
        return this.addOnId.equals(other.addOnId) && this.priceId.equals(other.priceId);
    }

    public int hashCode() {
        return Objects.hash(this.addOnId, this.priceId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AddOnIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AddOnIdStage,
    PriceIdStage,
    _FinalStage {
        private String addOnId;
        private String priceId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateAddOnRequestBody other) {
            this.addOnId(other.getAddOnId());
            this.priceId(other.getPriceId());
            return this;
        }

        @Override
        @JsonSetter(value="add_on_id")
        public PriceIdStage addOnId(@NotNull String addOnId) {
            this.addOnId = Objects.requireNonNull(addOnId, "addOnId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="price_id")
        public _FinalStage priceId(@NotNull String priceId) {
            this.priceId = Objects.requireNonNull(priceId, "priceId must not be null");
            return this;
        }

        @Override
        public UpdateAddOnRequestBody build() {
            return new UpdateAddOnRequestBody(this.addOnId, this.priceId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateAddOnRequestBody build();
    }

    public static interface PriceIdStage {
        public _FinalStage priceId(@NotNull String var1);
    }

    public static interface AddOnIdStage {
        public PriceIdStage addOnId(@NotNull String var1);

        public Builder from(UpdateAddOnRequestBody var1);
    }
}

