/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateCreditBundleRequestBody {
    private final String bundleId;
    private final int quantity;
    private final Map<String, Object> additionalProperties;

    private UpdateCreditBundleRequestBody(String bundleId, int quantity, Map<String, Object> additionalProperties) {
        this.bundleId = bundleId;
        this.quantity = quantity;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="bundle_id")
    public String getBundleId() {
        return this.bundleId;
    }

    @JsonProperty(value="quantity")
    public int getQuantity() {
        return this.quantity;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateCreditBundleRequestBody && this.equalTo((UpdateCreditBundleRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateCreditBundleRequestBody other) {
        return this.bundleId.equals(other.bundleId) && this.quantity == other.quantity;
    }

    public int hashCode() {
        return Objects.hash(this.bundleId, this.quantity);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BundleIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BundleIdStage,
    QuantityStage,
    _FinalStage {
        private String bundleId;
        private int quantity;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateCreditBundleRequestBody other) {
            this.bundleId(other.getBundleId());
            this.quantity(other.getQuantity());
            return this;
        }

        @Override
        @JsonSetter(value="bundle_id")
        public QuantityStage bundleId(@NotNull String bundleId) {
            this.bundleId = Objects.requireNonNull(bundleId, "bundleId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public _FinalStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        public UpdateCreditBundleRequestBody build() {
            return new UpdateCreditBundleRequestBody(this.bundleId, this.quantity, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateCreditBundleRequestBody build();
    }

    public static interface QuantityStage {
        public _FinalStage quantity(int var1);
    }

    public static interface BundleIdStage {
        public QuantityStage bundleId(@NotNull String var1);

        public Builder from(UpdateCreditBundleRequestBody var1);
    }
}

