/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.CreateOrUpdateConditionGroupRequestBody;
import com.schematic.api.types.CreateOrUpdateConditionRequestBody;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateRuleRequestBody {
    private final List<CreateOrUpdateConditionGroupRequestBody> conditionGroups;
    private final List<CreateOrUpdateConditionRequestBody> conditions;
    private final String name;
    private final int priority;
    private final boolean value;
    private final Map<String, Object> additionalProperties;

    private UpdateRuleRequestBody(List<CreateOrUpdateConditionGroupRequestBody> conditionGroups, List<CreateOrUpdateConditionRequestBody> conditions, String name, int priority, boolean value, Map<String, Object> additionalProperties) {
        this.conditionGroups = conditionGroups;
        this.conditions = conditions;
        this.name = name;
        this.priority = priority;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="condition_groups")
    public List<CreateOrUpdateConditionGroupRequestBody> getConditionGroups() {
        return this.conditionGroups;
    }

    @JsonProperty(value="conditions")
    public List<CreateOrUpdateConditionRequestBody> getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="priority")
    public int getPriority() {
        return this.priority;
    }

    @JsonProperty(value="value")
    public boolean getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateRuleRequestBody && this.equalTo((UpdateRuleRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateRuleRequestBody other) {
        return this.conditionGroups.equals(other.conditionGroups) && this.conditions.equals(other.conditions) && this.name.equals(other.name) && this.priority == other.priority && this.value == other.value;
    }

    public int hashCode() {
        return Objects.hash(this.conditionGroups, this.conditions, this.name, this.priority, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    PriorityStage,
    ValueStage,
    _FinalStage {
        private String name;
        private int priority;
        private boolean value;
        private List<CreateOrUpdateConditionRequestBody> conditions = new ArrayList<CreateOrUpdateConditionRequestBody>();
        private List<CreateOrUpdateConditionGroupRequestBody> conditionGroups = new ArrayList<CreateOrUpdateConditionGroupRequestBody>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateRuleRequestBody other) {
            this.conditionGroups(other.getConditionGroups());
            this.conditions(other.getConditions());
            this.name(other.getName());
            this.priority(other.getPriority());
            this.value(other.getValue());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PriorityStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="priority")
        public ValueStage priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(boolean value) {
            this.value = value;
            return this;
        }

        @Override
        public _FinalStage addAllConditions(List<CreateOrUpdateConditionRequestBody> conditions) {
            if (conditions != null) {
                this.conditions.addAll(conditions);
            }
            return this;
        }

        @Override
        public _FinalStage addConditions(CreateOrUpdateConditionRequestBody conditions) {
            this.conditions.add(conditions);
            return this;
        }

        @Override
        @JsonSetter(value="conditions", nulls=Nulls.SKIP)
        public _FinalStage conditions(List<CreateOrUpdateConditionRequestBody> conditions) {
            this.conditions.clear();
            if (conditions != null) {
                this.conditions.addAll(conditions);
            }
            return this;
        }

        @Override
        public _FinalStage addAllConditionGroups(List<CreateOrUpdateConditionGroupRequestBody> conditionGroups) {
            if (conditionGroups != null) {
                this.conditionGroups.addAll(conditionGroups);
            }
            return this;
        }

        @Override
        public _FinalStage addConditionGroups(CreateOrUpdateConditionGroupRequestBody conditionGroups) {
            this.conditionGroups.add(conditionGroups);
            return this;
        }

        @Override
        @JsonSetter(value="condition_groups", nulls=Nulls.SKIP)
        public _FinalStage conditionGroups(List<CreateOrUpdateConditionGroupRequestBody> conditionGroups) {
            this.conditionGroups.clear();
            if (conditionGroups != null) {
                this.conditionGroups.addAll(conditionGroups);
            }
            return this;
        }

        @Override
        public UpdateRuleRequestBody build() {
            return new UpdateRuleRequestBody(this.conditionGroups, this.conditions, this.name, this.priority, this.value, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateRuleRequestBody build();

        public _FinalStage conditionGroups(List<CreateOrUpdateConditionGroupRequestBody> var1);

        public _FinalStage addConditionGroups(CreateOrUpdateConditionGroupRequestBody var1);

        public _FinalStage addAllConditionGroups(List<CreateOrUpdateConditionGroupRequestBody> var1);

        public _FinalStage conditions(List<CreateOrUpdateConditionRequestBody> var1);

        public _FinalStage addConditions(CreateOrUpdateConditionRequestBody var1);

        public _FinalStage addAllConditions(List<CreateOrUpdateConditionRequestBody> var1);
    }

    public static interface ValueStage {
        public _FinalStage value(boolean var1);
    }

    public static interface PriorityStage {
        public ValueStage priority(int var1);
    }

    public static interface NameStage {
        public PriorityStage name(@NotNull String var1);

        public Builder from(UpdateRuleRequestBody var1);
    }
}

