/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpsertTraitRequestBody {
    private final Optional<Integer> incr;
    private final Map<String, String> keys;
    private final Optional<String> set;
    private final String trait;
    private final Optional<Boolean> updateOnly;
    private final Map<String, Object> additionalProperties;

    private UpsertTraitRequestBody(Optional<Integer> incr, Map<String, String> keys, Optional<String> set, String trait, Optional<Boolean> updateOnly, Map<String, Object> additionalProperties) {
        this.incr = incr;
        this.keys = keys;
        this.set = set;
        this.trait = trait;
        this.updateOnly = updateOnly;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="incr")
    public Optional<Integer> getIncr() {
        return this.incr;
    }

    @JsonProperty(value="keys")
    public Map<String, String> getKeys() {
        return this.keys;
    }

    @JsonProperty(value="set")
    public Optional<String> getSet() {
        return this.set;
    }

    @JsonProperty(value="trait")
    public String getTrait() {
        return this.trait;
    }

    @JsonProperty(value="update_only")
    public Optional<Boolean> getUpdateOnly() {
        return this.updateOnly;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpsertTraitRequestBody && this.equalTo((UpsertTraitRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpsertTraitRequestBody other) {
        return this.incr.equals(other.incr) && this.keys.equals(other.keys) && this.set.equals(other.set) && this.trait.equals(other.trait) && this.updateOnly.equals(other.updateOnly);
    }

    public int hashCode() {
        return Objects.hash(this.incr, this.keys, this.set, this.trait, this.updateOnly);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TraitStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TraitStage,
    _FinalStage {
        private String trait;
        private Optional<Boolean> updateOnly = Optional.empty();
        private Optional<String> set = Optional.empty();
        private Map<String, String> keys = new LinkedHashMap<String, String>();
        private Optional<Integer> incr = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpsertTraitRequestBody other) {
            this.incr(other.getIncr());
            this.keys(other.getKeys());
            this.set(other.getSet());
            this.trait(other.getTrait());
            this.updateOnly(other.getUpdateOnly());
            return this;
        }

        @Override
        @JsonSetter(value="trait")
        public _FinalStage trait(@NotNull String trait) {
            this.trait = Objects.requireNonNull(trait, "trait must not be null");
            return this;
        }

        @Override
        public _FinalStage updateOnly(Boolean updateOnly) {
            this.updateOnly = Optional.ofNullable(updateOnly);
            return this;
        }

        @Override
        @JsonSetter(value="update_only", nulls=Nulls.SKIP)
        public _FinalStage updateOnly(Optional<Boolean> updateOnly) {
            this.updateOnly = updateOnly;
            return this;
        }

        @Override
        public _FinalStage set(String set) {
            this.set = Optional.ofNullable(set);
            return this;
        }

        @Override
        @JsonSetter(value="set", nulls=Nulls.SKIP)
        public _FinalStage set(Optional<String> set) {
            this.set = set;
            return this;
        }

        @Override
        public _FinalStage keys(String key, String value) {
            this.keys.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllKeys(Map<String, String> keys) {
            if (keys != null) {
                this.keys.putAll(keys);
            }
            return this;
        }

        @Override
        @JsonSetter(value="keys", nulls=Nulls.SKIP)
        public _FinalStage keys(Map<String, String> keys) {
            this.keys.clear();
            if (keys != null) {
                this.keys.putAll(keys);
            }
            return this;
        }

        @Override
        public _FinalStage incr(Integer incr) {
            this.incr = Optional.ofNullable(incr);
            return this;
        }

        @Override
        @JsonSetter(value="incr", nulls=Nulls.SKIP)
        public _FinalStage incr(Optional<Integer> incr) {
            this.incr = incr;
            return this;
        }

        @Override
        public UpsertTraitRequestBody build() {
            return new UpsertTraitRequestBody(this.incr, this.keys, this.set, this.trait, this.updateOnly, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpsertTraitRequestBody build();

        public _FinalStage incr(Optional<Integer> var1);

        public _FinalStage incr(Integer var1);

        public _FinalStage keys(Map<String, String> var1);

        public _FinalStage putAllKeys(Map<String, String> var1);

        public _FinalStage keys(String var1, String var2);

        public _FinalStage set(Optional<String> var1);

        public _FinalStage set(String var1);

        public _FinalStage updateOnly(Optional<Boolean> var1);

        public _FinalStage updateOnly(Boolean var1);
    }

    public static interface TraitStage {
        public _FinalStage trait(@NotNull String var1);

        public Builder from(UpsertTraitRequestBody var1);
    }
}

