/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingPriceView;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UsageBasedEntitlementResponseData {
    private final Optional<Integer> billingThreshold;
    private final Optional<Double> consumptionRate;
    private final String featureId;
    private final Optional<BillingPriceView> meteredPrice;
    private final Optional<String> metricPeriod;
    private final Optional<String> metricPeriodMonthReset;
    private final Optional<BillingPriceView> monthlyUsageBasedPrice;
    private final Optional<String> priceBehavior;
    private final Optional<Boolean> valueBool;
    private final Optional<Integer> valueNumeric;
    private final String valueType;
    private final Optional<BillingPriceView> yearlyUsageBasedPrice;
    private final Map<String, Object> additionalProperties;

    private UsageBasedEntitlementResponseData(Optional<Integer> billingThreshold, Optional<Double> consumptionRate, String featureId, Optional<BillingPriceView> meteredPrice, Optional<String> metricPeriod, Optional<String> metricPeriodMonthReset, Optional<BillingPriceView> monthlyUsageBasedPrice, Optional<String> priceBehavior, Optional<Boolean> valueBool, Optional<Integer> valueNumeric, String valueType, Optional<BillingPriceView> yearlyUsageBasedPrice, Map<String, Object> additionalProperties) {
        this.billingThreshold = billingThreshold;
        this.consumptionRate = consumptionRate;
        this.featureId = featureId;
        this.meteredPrice = meteredPrice;
        this.metricPeriod = metricPeriod;
        this.metricPeriodMonthReset = metricPeriodMonthReset;
        this.monthlyUsageBasedPrice = monthlyUsageBasedPrice;
        this.priceBehavior = priceBehavior;
        this.valueBool = valueBool;
        this.valueNumeric = valueNumeric;
        this.valueType = valueType;
        this.yearlyUsageBasedPrice = yearlyUsageBasedPrice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="billing_threshold")
    public Optional<Integer> getBillingThreshold() {
        return this.billingThreshold;
    }

    @JsonProperty(value="consumption_rate")
    public Optional<Double> getConsumptionRate() {
        return this.consumptionRate;
    }

    @JsonProperty(value="feature_id")
    public String getFeatureId() {
        return this.featureId;
    }

    @JsonProperty(value="metered_price")
    public Optional<BillingPriceView> getMeteredPrice() {
        return this.meteredPrice;
    }

    @JsonProperty(value="metric_period")
    public Optional<String> getMetricPeriod() {
        return this.metricPeriod;
    }

    @JsonProperty(value="metric_period_month_reset")
    public Optional<String> getMetricPeriodMonthReset() {
        return this.metricPeriodMonthReset;
    }

    @JsonProperty(value="monthly_usage_based_price")
    public Optional<BillingPriceView> getMonthlyUsageBasedPrice() {
        return this.monthlyUsageBasedPrice;
    }

    @JsonProperty(value="price_behavior")
    public Optional<String> getPriceBehavior() {
        return this.priceBehavior;
    }

    @JsonProperty(value="value_bool")
    public Optional<Boolean> getValueBool() {
        return this.valueBool;
    }

    @JsonProperty(value="value_numeric")
    public Optional<Integer> getValueNumeric() {
        return this.valueNumeric;
    }

    @JsonProperty(value="value_type")
    public String getValueType() {
        return this.valueType;
    }

    @JsonProperty(value="yearly_usage_based_price")
    public Optional<BillingPriceView> getYearlyUsageBasedPrice() {
        return this.yearlyUsageBasedPrice;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UsageBasedEntitlementResponseData && this.equalTo((UsageBasedEntitlementResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UsageBasedEntitlementResponseData other) {
        return this.billingThreshold.equals(other.billingThreshold) && this.consumptionRate.equals(other.consumptionRate) && this.featureId.equals(other.featureId) && this.meteredPrice.equals(other.meteredPrice) && this.metricPeriod.equals(other.metricPeriod) && this.metricPeriodMonthReset.equals(other.metricPeriodMonthReset) && this.monthlyUsageBasedPrice.equals(other.monthlyUsageBasedPrice) && this.priceBehavior.equals(other.priceBehavior) && this.valueBool.equals(other.valueBool) && this.valueNumeric.equals(other.valueNumeric) && this.valueType.equals(other.valueType) && this.yearlyUsageBasedPrice.equals(other.yearlyUsageBasedPrice);
    }

    public int hashCode() {
        return Objects.hash(this.billingThreshold, this.consumptionRate, this.featureId, this.meteredPrice, this.metricPeriod, this.metricPeriodMonthReset, this.monthlyUsageBasedPrice, this.priceBehavior, this.valueBool, this.valueNumeric, this.valueType, this.yearlyUsageBasedPrice);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static FeatureIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements FeatureIdStage,
    ValueTypeStage,
    _FinalStage {
        private String featureId;
        private String valueType;
        private Optional<BillingPriceView> yearlyUsageBasedPrice = Optional.empty();
        private Optional<Integer> valueNumeric = Optional.empty();
        private Optional<Boolean> valueBool = Optional.empty();
        private Optional<String> priceBehavior = Optional.empty();
        private Optional<BillingPriceView> monthlyUsageBasedPrice = Optional.empty();
        private Optional<String> metricPeriodMonthReset = Optional.empty();
        private Optional<String> metricPeriod = Optional.empty();
        private Optional<BillingPriceView> meteredPrice = Optional.empty();
        private Optional<Double> consumptionRate = Optional.empty();
        private Optional<Integer> billingThreshold = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UsageBasedEntitlementResponseData other) {
            this.billingThreshold(other.getBillingThreshold());
            this.consumptionRate(other.getConsumptionRate());
            this.featureId(other.getFeatureId());
            this.meteredPrice(other.getMeteredPrice());
            this.metricPeriod(other.getMetricPeriod());
            this.metricPeriodMonthReset(other.getMetricPeriodMonthReset());
            this.monthlyUsageBasedPrice(other.getMonthlyUsageBasedPrice());
            this.priceBehavior(other.getPriceBehavior());
            this.valueBool(other.getValueBool());
            this.valueNumeric(other.getValueNumeric());
            this.valueType(other.getValueType());
            this.yearlyUsageBasedPrice(other.getYearlyUsageBasedPrice());
            return this;
        }

        @Override
        @JsonSetter(value="feature_id")
        public ValueTypeStage featureId(@NotNull String featureId) {
            this.featureId = Objects.requireNonNull(featureId, "featureId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="value_type")
        public _FinalStage valueType(@NotNull String valueType) {
            this.valueType = Objects.requireNonNull(valueType, "valueType must not be null");
            return this;
        }

        @Override
        public _FinalStage yearlyUsageBasedPrice(BillingPriceView yearlyUsageBasedPrice) {
            this.yearlyUsageBasedPrice = Optional.ofNullable(yearlyUsageBasedPrice);
            return this;
        }

        @Override
        @JsonSetter(value="yearly_usage_based_price", nulls=Nulls.SKIP)
        public _FinalStage yearlyUsageBasedPrice(Optional<BillingPriceView> yearlyUsageBasedPrice) {
            this.yearlyUsageBasedPrice = yearlyUsageBasedPrice;
            return this;
        }

        @Override
        public _FinalStage valueNumeric(Integer valueNumeric) {
            this.valueNumeric = Optional.ofNullable(valueNumeric);
            return this;
        }

        @Override
        @JsonSetter(value="value_numeric", nulls=Nulls.SKIP)
        public _FinalStage valueNumeric(Optional<Integer> valueNumeric) {
            this.valueNumeric = valueNumeric;
            return this;
        }

        @Override
        public _FinalStage valueBool(Boolean valueBool) {
            this.valueBool = Optional.ofNullable(valueBool);
            return this;
        }

        @Override
        @JsonSetter(value="value_bool", nulls=Nulls.SKIP)
        public _FinalStage valueBool(Optional<Boolean> valueBool) {
            this.valueBool = valueBool;
            return this;
        }

        @Override
        public _FinalStage priceBehavior(String priceBehavior) {
            this.priceBehavior = Optional.ofNullable(priceBehavior);
            return this;
        }

        @Override
        @JsonSetter(value="price_behavior", nulls=Nulls.SKIP)
        public _FinalStage priceBehavior(Optional<String> priceBehavior) {
            this.priceBehavior = priceBehavior;
            return this;
        }

        @Override
        public _FinalStage monthlyUsageBasedPrice(BillingPriceView monthlyUsageBasedPrice) {
            this.monthlyUsageBasedPrice = Optional.ofNullable(monthlyUsageBasedPrice);
            return this;
        }

        @Override
        @JsonSetter(value="monthly_usage_based_price", nulls=Nulls.SKIP)
        public _FinalStage monthlyUsageBasedPrice(Optional<BillingPriceView> monthlyUsageBasedPrice) {
            this.monthlyUsageBasedPrice = monthlyUsageBasedPrice;
            return this;
        }

        @Override
        public _FinalStage metricPeriodMonthReset(String metricPeriodMonthReset) {
            this.metricPeriodMonthReset = Optional.ofNullable(metricPeriodMonthReset);
            return this;
        }

        @Override
        @JsonSetter(value="metric_period_month_reset", nulls=Nulls.SKIP)
        public _FinalStage metricPeriodMonthReset(Optional<String> metricPeriodMonthReset) {
            this.metricPeriodMonthReset = metricPeriodMonthReset;
            return this;
        }

        @Override
        public _FinalStage metricPeriod(String metricPeriod) {
            this.metricPeriod = Optional.ofNullable(metricPeriod);
            return this;
        }

        @Override
        @JsonSetter(value="metric_period", nulls=Nulls.SKIP)
        public _FinalStage metricPeriod(Optional<String> metricPeriod) {
            this.metricPeriod = metricPeriod;
            return this;
        }

        @Override
        public _FinalStage meteredPrice(BillingPriceView meteredPrice) {
            this.meteredPrice = Optional.ofNullable(meteredPrice);
            return this;
        }

        @Override
        @JsonSetter(value="metered_price", nulls=Nulls.SKIP)
        public _FinalStage meteredPrice(Optional<BillingPriceView> meteredPrice) {
            this.meteredPrice = meteredPrice;
            return this;
        }

        @Override
        public _FinalStage consumptionRate(Double consumptionRate) {
            this.consumptionRate = Optional.ofNullable(consumptionRate);
            return this;
        }

        @Override
        @JsonSetter(value="consumption_rate", nulls=Nulls.SKIP)
        public _FinalStage consumptionRate(Optional<Double> consumptionRate) {
            this.consumptionRate = consumptionRate;
            return this;
        }

        @Override
        public _FinalStage billingThreshold(Integer billingThreshold) {
            this.billingThreshold = Optional.ofNullable(billingThreshold);
            return this;
        }

        @Override
        @JsonSetter(value="billing_threshold", nulls=Nulls.SKIP)
        public _FinalStage billingThreshold(Optional<Integer> billingThreshold) {
            this.billingThreshold = billingThreshold;
            return this;
        }

        @Override
        public UsageBasedEntitlementResponseData build() {
            return new UsageBasedEntitlementResponseData(this.billingThreshold, this.consumptionRate, this.featureId, this.meteredPrice, this.metricPeriod, this.metricPeriodMonthReset, this.monthlyUsageBasedPrice, this.priceBehavior, this.valueBool, this.valueNumeric, this.valueType, this.yearlyUsageBasedPrice, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UsageBasedEntitlementResponseData build();

        public _FinalStage billingThreshold(Optional<Integer> var1);

        public _FinalStage billingThreshold(Integer var1);

        public _FinalStage consumptionRate(Optional<Double> var1);

        public _FinalStage consumptionRate(Double var1);

        public _FinalStage meteredPrice(Optional<BillingPriceView> var1);

        public _FinalStage meteredPrice(BillingPriceView var1);

        public _FinalStage metricPeriod(Optional<String> var1);

        public _FinalStage metricPeriod(String var1);

        public _FinalStage metricPeriodMonthReset(Optional<String> var1);

        public _FinalStage metricPeriodMonthReset(String var1);

        public _FinalStage monthlyUsageBasedPrice(Optional<BillingPriceView> var1);

        public _FinalStage monthlyUsageBasedPrice(BillingPriceView var1);

        public _FinalStage priceBehavior(Optional<String> var1);

        public _FinalStage priceBehavior(String var1);

        public _FinalStage valueBool(Optional<Boolean> var1);

        public _FinalStage valueBool(Boolean var1);

        public _FinalStage valueNumeric(Optional<Integer> var1);

        public _FinalStage valueNumeric(Integer var1);

        public _FinalStage yearlyUsageBasedPrice(Optional<BillingPriceView> var1);

        public _FinalStage yearlyUsageBasedPrice(BillingPriceView var1);
    }

    public static interface ValueTypeStage {
        public _FinalStage valueType(@NotNull String var1);
    }

    public static interface FeatureIdStage {
        public ValueTypeStage featureId(@NotNull String var1);

        public Builder from(UsageBasedEntitlementResponseData var1);
    }
}

