/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.CreditTriggerConfig;
import com.schematic.api.types.EntitlementTriggerConfig;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class WebhookResponseData {
    private final OffsetDateTime createdAt;
    private final Optional<List<CreditTriggerConfig>> creditTriggerConfigs;
    private final Optional<List<EntitlementTriggerConfig>> entitlementTriggerConfigs;
    private final String id;
    private final String name;
    private final List<String> requestTypes;
    private final String secret;
    private final String status;
    private final OffsetDateTime updatedAt;
    private final String url;
    private final Map<String, Object> additionalProperties;

    private WebhookResponseData(OffsetDateTime createdAt, Optional<List<CreditTriggerConfig>> creditTriggerConfigs, Optional<List<EntitlementTriggerConfig>> entitlementTriggerConfigs, String id, String name, List<String> requestTypes, String secret, String status, OffsetDateTime updatedAt, String url, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.creditTriggerConfigs = creditTriggerConfigs;
        this.entitlementTriggerConfigs = entitlementTriggerConfigs;
        this.id = id;
        this.name = name;
        this.requestTypes = requestTypes;
        this.secret = secret;
        this.status = status;
        this.updatedAt = updatedAt;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="credit_trigger_configs")
    public Optional<List<CreditTriggerConfig>> getCreditTriggerConfigs() {
        return this.creditTriggerConfigs;
    }

    @JsonProperty(value="entitlement_trigger_configs")
    public Optional<List<EntitlementTriggerConfig>> getEntitlementTriggerConfigs() {
        return this.entitlementTriggerConfigs;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="request_types")
    public List<String> getRequestTypes() {
        return this.requestTypes;
    }

    @JsonProperty(value="secret")
    public String getSecret() {
        return this.secret;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WebhookResponseData && this.equalTo((WebhookResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WebhookResponseData other) {
        return this.createdAt.equals(other.createdAt) && this.creditTriggerConfigs.equals(other.creditTriggerConfigs) && this.entitlementTriggerConfigs.equals(other.entitlementTriggerConfigs) && this.id.equals(other.id) && this.name.equals(other.name) && this.requestTypes.equals(other.requestTypes) && this.secret.equals(other.secret) && this.status.equals(other.status) && this.updatedAt.equals(other.updatedAt) && this.url.equals(other.url);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.creditTriggerConfigs, this.entitlementTriggerConfigs, this.id, this.name, this.requestTypes, this.secret, this.status, this.updatedAt, this.url);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    IdStage,
    NameStage,
    SecretStage,
    StatusStage,
    UpdatedAtStage,
    UrlStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String id;
        private String name;
        private String secret;
        private String status;
        private OffsetDateTime updatedAt;
        private String url;
        private List<String> requestTypes = new ArrayList<String>();
        private Optional<List<EntitlementTriggerConfig>> entitlementTriggerConfigs = Optional.empty();
        private Optional<List<CreditTriggerConfig>> creditTriggerConfigs = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(WebhookResponseData other) {
            this.createdAt(other.getCreatedAt());
            this.creditTriggerConfigs(other.getCreditTriggerConfigs());
            this.entitlementTriggerConfigs(other.getEntitlementTriggerConfigs());
            this.id(other.getId());
            this.name(other.getName());
            this.requestTypes(other.getRequestTypes());
            this.secret(other.getSecret());
            this.status(other.getStatus());
            this.updatedAt(other.getUpdatedAt());
            this.url(other.getUrl());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public IdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public SecretStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="secret")
        public StatusStage secret(@NotNull String secret) {
            this.secret = Objects.requireNonNull(secret, "secret must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public UpdatedAtStage status(@NotNull String status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public UrlStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllRequestTypes(List<String> requestTypes) {
            if (requestTypes != null) {
                this.requestTypes.addAll(requestTypes);
            }
            return this;
        }

        @Override
        public _FinalStage addRequestTypes(String requestTypes) {
            this.requestTypes.add(requestTypes);
            return this;
        }

        @Override
        @JsonSetter(value="request_types", nulls=Nulls.SKIP)
        public _FinalStage requestTypes(List<String> requestTypes) {
            this.requestTypes.clear();
            if (requestTypes != null) {
                this.requestTypes.addAll(requestTypes);
            }
            return this;
        }

        @Override
        public _FinalStage entitlementTriggerConfigs(List<EntitlementTriggerConfig> entitlementTriggerConfigs) {
            this.entitlementTriggerConfigs = Optional.ofNullable(entitlementTriggerConfigs);
            return this;
        }

        @Override
        @JsonSetter(value="entitlement_trigger_configs", nulls=Nulls.SKIP)
        public _FinalStage entitlementTriggerConfigs(Optional<List<EntitlementTriggerConfig>> entitlementTriggerConfigs) {
            this.entitlementTriggerConfigs = entitlementTriggerConfigs;
            return this;
        }

        @Override
        public _FinalStage creditTriggerConfigs(List<CreditTriggerConfig> creditTriggerConfigs) {
            this.creditTriggerConfigs = Optional.ofNullable(creditTriggerConfigs);
            return this;
        }

        @Override
        @JsonSetter(value="credit_trigger_configs", nulls=Nulls.SKIP)
        public _FinalStage creditTriggerConfigs(Optional<List<CreditTriggerConfig>> creditTriggerConfigs) {
            this.creditTriggerConfigs = creditTriggerConfigs;
            return this;
        }

        @Override
        public WebhookResponseData build() {
            return new WebhookResponseData(this.createdAt, this.creditTriggerConfigs, this.entitlementTriggerConfigs, this.id, this.name, this.requestTypes, this.secret, this.status, this.updatedAt, this.url, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public WebhookResponseData build();

        public _FinalStage creditTriggerConfigs(Optional<List<CreditTriggerConfig>> var1);

        public _FinalStage creditTriggerConfigs(List<CreditTriggerConfig> var1);

        public _FinalStage entitlementTriggerConfigs(Optional<List<EntitlementTriggerConfig>> var1);

        public _FinalStage entitlementTriggerConfigs(List<EntitlementTriggerConfig> var1);

        public _FinalStage requestTypes(List<String> var1);

        public _FinalStage addRequestTypes(String var1);

        public _FinalStage addAllRequestTypes(List<String> var1);
    }

    public static interface UrlStage {
        public _FinalStage url(@NotNull String var1);
    }

    public static interface UpdatedAtStage {
        public UrlStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface StatusStage {
        public UpdatedAtStage status(@NotNull String var1);
    }

    public static interface SecretStage {
        public StatusStage secret(@NotNull String var1);
    }

    public static interface NameStage {
        public SecretStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public IdStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(WebhookResponseData var1);
    }
}

