/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.webhook;

import com.schematic.webhook.WebhookSignatureException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class WebhookVerifier {
    public static final String WEBHOOK_SIGNATURE_HEADER = "X-Schematic-Webhook-Signature";
    public static final String WEBHOOK_TIMESTAMP_HEADER = "X-Schematic-Webhook-Timestamp";
    private static final String HMAC_SHA256 = "HmacSHA256";

    public static void verifyWebhookSignature(String body, Map<String, String> headers, String secret) throws WebhookSignatureException {
        String signature = headers.get(WEBHOOK_SIGNATURE_HEADER);
        String timestamp = headers.get(WEBHOOK_TIMESTAMP_HEADER);
        WebhookVerifier.verifySignature(body, signature, timestamp, secret);
    }

    public static void verifySignature(String body, String signature, String timestamp, String secret) throws WebhookSignatureException {
        if (signature == null || signature.isEmpty()) {
            throw new WebhookSignatureException("Missing webhook signature");
        }
        if (timestamp == null || timestamp.isEmpty()) {
            throw new WebhookSignatureException("Missing webhook timestamp");
        }
        String expectedSignature = WebhookVerifier.computeHexSignature(body, timestamp, secret);
        if (!WebhookVerifier.constantTimeEquals(WebhookVerifier.hexToBytes(expectedSignature), WebhookVerifier.hexToBytes(signature))) {
            throw new WebhookSignatureException("Invalid signature");
        }
    }

    public static String computeHexSignature(String body, String timestamp, String secret) throws WebhookSignatureException {
        byte[] signature = WebhookVerifier.computeSignature(body, timestamp, secret);
        return WebhookVerifier.bytesToHex(signature);
    }

    public static byte[] computeSignature(String body, String timestamp, String secret) throws WebhookSignatureException {
        try {
            String message = body + "+" + timestamp;
            byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec keySpec = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), HMAC_SHA256);
            Mac mac = Mac.getInstance(HMAC_SHA256);
            mac.init(keySpec);
            return mac.doFinal(messageBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new WebhookSignatureException("Error computing signature", e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }

    private static byte[] hexToBytes(String hex) throws WebhookSignatureException {
        try {
            int len = hex.length();
            byte[] data = new byte[len / 2];
            for (int i = 0; i < len; i += 2) {
                data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
            }
            return data;
        }
        catch (Exception e) {
            throw new WebhookSignatureException("Invalid signature format", e);
        }
    }

    private static boolean constantTimeEquals(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < a.length; ++i) {
            result |= a[i] ^ b[i];
        }
        return result == 0;
    }
}

