/*
 * Decompiled with CFR 0.152.
 */
package com.securionpay;

import com.securionpay.connection.Connection;
import com.securionpay.connection.HttpClientConnection;
import com.securionpay.connection.Response;
import com.securionpay.exception.SecurionPayException;
import com.securionpay.request.BlacklistRuleListRequest;
import com.securionpay.request.BlacklistRuleRequest;
import com.securionpay.request.CaptureRequest;
import com.securionpay.request.CardListRequest;
import com.securionpay.request.CardRequest;
import com.securionpay.request.CardUpdateRequest;
import com.securionpay.request.ChargeListRequest;
import com.securionpay.request.ChargeRequest;
import com.securionpay.request.ChargeUpdateRequest;
import com.securionpay.request.CustomerListRequest;
import com.securionpay.request.CustomerRequest;
import com.securionpay.request.CustomerUpdateRequest;
import com.securionpay.request.EventListRequest;
import com.securionpay.request.PlanListRequest;
import com.securionpay.request.PlanRequest;
import com.securionpay.request.PlanUpdateRequest;
import com.securionpay.request.RefundRequest;
import com.securionpay.request.SubscriptionCancelRequest;
import com.securionpay.request.SubscriptionListRequest;
import com.securionpay.request.SubscriptionRequest;
import com.securionpay.request.SubscriptionUpdateRequest;
import com.securionpay.request.TokenRequest;
import com.securionpay.response.BlacklistRule;
import com.securionpay.response.Card;
import com.securionpay.response.Charge;
import com.securionpay.response.Customer;
import com.securionpay.response.DeleteResponse;
import com.securionpay.response.ErrorResponse;
import com.securionpay.response.Event;
import com.securionpay.response.ListResponse;
import com.securionpay.response.Plan;
import com.securionpay.response.Subscription;
import com.securionpay.response.Token;
import com.securionpay.util.ObjectSerializer;
import com.securionpay.util.SecurionPayUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class SecurionPayGateway
implements Closeable {
    public static final String DEFAULT_ENDPOINT = "https://api.securionpay.com/";
    private static final String CHARGES_PATH = "/charges";
    private static final String TOKENS_PATH = "/tokens";
    private static final String CUSTOMERS_PATH = "/customers";
    private static final String CARDS_PATH = "/customers/%s/cards";
    private static final String PLANS_PATH = "/plans";
    private static final String SUBSCRIPTIONS_PATH = "/customers/%s/subscriptions";
    private static final String EVENTS_PATH = "/events";
    private static final String BLACKLIST_RULE_PATH = "/blacklist";
    private final ObjectSerializer objectSerializer = ObjectSerializer.INSTANCE;
    private Connection connection;
    private String privateKey;
    private String endpoint = "https://api.securionpay.com/";

    public SecurionPayGateway() {
        this(null);
    }

    public SecurionPayGateway(String privateKey) {
        this(privateKey, new HttpClientConnection());
    }

    public SecurionPayGateway(String privateKey, Connection connection) {
        this.privateKey = privateKey;
        this.connection = connection;
    }

    public Charge createCharge(ChargeRequest request) {
        return this.post(CHARGES_PATH, request, Charge.class);
    }

    public Charge captureCharge(CaptureRequest request) {
        return this.post("/charges/" + request.getChargeId() + "/capture", request, Charge.class);
    }

    public Charge retrieveCharge(String chargeId) {
        return this.get("/charges/" + chargeId, Charge.class);
    }

    public Charge updateCharge(ChargeUpdateRequest request) {
        return this.post("/charges/" + request.getChargeId(), request, Charge.class);
    }

    public Charge refundCharge(RefundRequest request) {
        return this.post("/charges/" + request.getChargeId() + "/refund", request, Charge.class);
    }

    public ListResponse<Charge> listCharges() {
        return this.list(CHARGES_PATH, Charge.class);
    }

    public ListResponse<Charge> listCharges(ChargeListRequest request) {
        return this.list(CHARGES_PATH, request, Charge.class);
    }

    public Customer createCustomer(CustomerRequest request) {
        return this.post(CUSTOMERS_PATH, request, Customer.class);
    }

    public Customer retrieveCustomer(String customerId) {
        return this.get("/customers/" + customerId, Customer.class);
    }

    public Customer updateCustomer(CustomerUpdateRequest request) {
        return this.post("/customers/" + request.getCustomerId(), request, Customer.class);
    }

    public DeleteResponse deleteCustomer(String customerId) {
        return this.delete("/customers/" + customerId, DeleteResponse.class);
    }

    public ListResponse<Customer> listCustomers() {
        return this.list(CUSTOMERS_PATH, Customer.class);
    }

    public ListResponse<Customer> listCustomers(CustomerListRequest request) {
        return this.list(CUSTOMERS_PATH, request, Customer.class);
    }

    public Card createCard(CardRequest request) {
        return this.post(String.format(CARDS_PATH, request.getCustomerId()), request, Card.class);
    }

    public Card retrieveCard(String customerId, String cardId) {
        return this.get(String.format(CARDS_PATH, customerId) + "/" + cardId, Card.class);
    }

    public Card updateCard(CardUpdateRequest card) {
        return this.post(String.format(CARDS_PATH, card.getCustomerId()) + "/" + card.getCardId(), card, Card.class);
    }

    public DeleteResponse deleteCard(String customerId, String cardId) {
        return this.delete(String.format(CARDS_PATH, customerId) + "/" + cardId, DeleteResponse.class);
    }

    public ListResponse<Card> listCards(String customerId) {
        return this.listCards(new CardListRequest().customerId(customerId));
    }

    public ListResponse<Card> listCards(CardListRequest listCards) {
        return this.list(String.format(CARDS_PATH, listCards.getCustomerId()), listCards, Card.class);
    }

    public Subscription createSubscription(SubscriptionRequest request) {
        return this.post(String.format(SUBSCRIPTIONS_PATH, request.getCustomerId()), request, Subscription.class);
    }

    public Subscription retrieveSubscription(String customerId, String subscriptionId) {
        return this.get(String.format(SUBSCRIPTIONS_PATH, customerId) + "/" + subscriptionId, Subscription.class);
    }

    public Subscription updateSubscription(SubscriptionUpdateRequest request) {
        return this.post(String.format(SUBSCRIPTIONS_PATH, request.getCustomerId()) + "/" + request.getSubscriptionId(), request, Subscription.class);
    }

    public Subscription cancelSubscription(SubscriptionCancelRequest request) {
        return this.delete(String.format(SUBSCRIPTIONS_PATH, request.getCustomerId()) + "/" + request.getSubscriptionId(), request, Subscription.class);
    }

    public ListResponse<Subscription> listSubscriptions(String customerId) {
        return this.list(String.format(SUBSCRIPTIONS_PATH, customerId), Subscription.class);
    }

    public ListResponse<Subscription> listSubscriptions(SubscriptionListRequest request) {
        return this.list(String.format(SUBSCRIPTIONS_PATH, request.getCustomerId()), request, Subscription.class);
    }

    public Plan createPlan(PlanRequest request) {
        return this.post(PLANS_PATH, request, Plan.class);
    }

    public Plan retrievePlan(String planId) {
        return this.get("/plans/" + planId, Plan.class);
    }

    public Plan updatePlan(PlanUpdateRequest request) {
        return this.post("/plans/" + request.getPlanId(), request, Plan.class);
    }

    public DeleteResponse deletePlan(String planId) {
        return this.delete("/plans/" + planId, DeleteResponse.class);
    }

    public ListResponse<Plan> listPlans() {
        return this.list(PLANS_PATH, Plan.class);
    }

    public ListResponse<Plan> listPlans(PlanListRequest request) {
        return this.list(PLANS_PATH, request, Plan.class);
    }

    public Event retrieveEvent(String eventId) {
        return this.get(String.format("/events/" + eventId, new Object[0]), Event.class);
    }

    public ListResponse<Event> listEvents() {
        return this.list(EVENTS_PATH, Event.class);
    }

    public ListResponse<Event> listEvents(EventListRequest listEvents) {
        return this.list(EVENTS_PATH, listEvents, Event.class);
    }

    public Token createToken(TokenRequest request) {
        return this.post(TOKENS_PATH, request, Token.class);
    }

    public Token retrieveToken(String tokenId) {
        return this.get("/tokens/" + tokenId, Token.class);
    }

    public BlacklistRule createBlacklistRule(BlacklistRuleRequest request) {
        return this.post(BLACKLIST_RULE_PATH, request, BlacklistRule.class);
    }

    public BlacklistRule retrieveBlacklistRule(String blacklistRuleId) {
        return this.get("/blacklist/" + blacklistRuleId, BlacklistRule.class);
    }

    public DeleteResponse deleteBlacklistRule(String blacklistRuleId) {
        return this.delete("/blacklist/" + blacklistRuleId, DeleteResponse.class);
    }

    public ListResponse<BlacklistRule> listBlacklistRules() {
        return this.list(BLACKLIST_RULE_PATH, BlacklistRule.class);
    }

    public ListResponse<BlacklistRule> listBlacklistRules(BlacklistRuleListRequest request) {
        return this.list(BLACKLIST_RULE_PATH, request, BlacklistRule.class);
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    private <T> T get(String path, Class<T> responseClass) {
        Response response = this.connection.get(this.endpoint + path, this.buildHeaders());
        this.ensureSuccess(response);
        return this.objectSerializer.deserialize(response.getBody(), responseClass);
    }

    private <T> T post(String path, Object request, Class<T> responseClass) {
        String requestBody = this.objectSerializer.serialize(request);
        Response response = this.connection.post(this.endpoint + path, requestBody, this.buildHeaders());
        this.ensureSuccess(response);
        return this.objectSerializer.deserialize(response.getBody(), responseClass);
    }

    private <T> ListResponse<T> list(String path, Class<T> elementClass) {
        return this.list(path, null, elementClass);
    }

    private <T> ListResponse<T> list(String path, Object request, Class<T> elementClass) {
        String url = this.buildQueryString(this.endpoint + path, request);
        Response response = this.connection.get(url, this.buildHeaders());
        this.ensureSuccess(response);
        return this.objectSerializer.deserializeList(response.getBody(), elementClass);
    }

    private <T> T delete(String path, Class<T> responseClass) {
        return this.delete(path, null, responseClass);
    }

    private <T> T delete(String path, Object request, Class<T> responseClass) {
        String url = this.buildQueryString(this.endpoint + path, request);
        Response response = this.connection.delete(url, this.buildHeaders());
        this.ensureSuccess(response);
        return this.objectSerializer.deserialize(response.getBody(), responseClass);
    }

    private Response ensureSuccess(Response response) {
        if (response.getStatus() != 200) {
            ErrorResponse error = this.objectSerializer.deserialize(response.getBody(), ErrorResponse.class);
            throw new SecurionPayException(error);
        }
        return response;
    }

    private String buildQueryString(String url, Object request) {
        if (request == null) {
            return url;
        }
        return url + this.objectSerializer.serializeToQueryString(request);
    }

    private Map<String, String> buildHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.privateKey + ":").getBytes()));
        headers.put("Content-Type", "application/json");
        headers.put("User-Agent", "SecurionPay-Java/" + SecurionPayUtils.getBuildVersion() + " (Java/" + SecurionPayUtils.getJavaVersion() + ")");
        return headers;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }
}

